
;****************************************************************************
;* File Name            : ADC.asm										*
;* Title                :													*
;* Version              : 1.0												*
;* Erstellt             : April 2008										*
;* Verfasser 			:                             	               		*
;* Beschreibung			: Programm zur Ausgabe eines Zeichens, welches auf 	*
;*				  		  dem LCD-Display angezeigt wird.					*	
;****************************************************************************
          
;****************************************************************************
;*Interruptvektortabelle
;****************************************************************************

.include "m32def.inc" 

;Sprungbefehle zu Programmteilen, die je nach Interrupt ausgefhrt werden sollen.
.org 0x000				rjmp main			; Reset             
.org OVF2addr           rjmp TIM2_OVF		; Overflow2 Interrupt Vector Address
.org OVF1addr			rjmp TIM1_OVF       ; Overflow1 Interrupt Vector Address
.org OVF0addr           rjmp TIM0_OVF      	; Overflow0 Interrupt Vector Address       
.org SPIaddr            rjmp SPI_STC      	; SPI Interrupt Vector Address
.org URXCaddr           rjmp USART_RXC      ; USART Receive Complete Interrupt Vector Address
.org UDREaddr           rjmp USART_DRE      ; USART Data Register Empty Interrupt Vector Address    
.org UTXCaddr           rjmp USART_TXC      ; USART Transmit Complete Interrupt Vector Address      
.org ADCCaddr           rjmp ADCC        	; ADC Interrupt Vector Address        
.org ACIaddr            rjmp ANA_COMP      	; Analog Comparator Interrupt Vector Address      
.org TWIaddr            rjmp TWSI       	; Irq. vector address for Two-Wire Interface
       
                 
;.ORG 0x000  			;Setze Adresszhler des aktuellen Segments auf den angegebenen
						;Wert, hier hexadezimal 0x000. Das ist die Adresse nach den obigen
						;Sprungbefehlen.

;****************************************************************************
;*Hauptprogramm
;****************************************************************************

.include "arbeitsregister.asm"

;.include "lcd_text_init.asm"
.include "lcd_routines.asm"

.include "usart_init.asm"
.include "string_out.asm"


main:

	ldi temp1, low(RAMEND)		;Die Startadresse des Stack (Stapelspeicher) wird festgelegt und der Stackpointer
	out SPL, temp1				;(Stapelzeiger) auf diesen Wert gesetzt. Die weitere Nutzung des Stack bernimmt
	ldi temp1, high(RAMEND)		;der Mikrocontroller selbst.
	out SPH, temp1 


   	ldi temp1, 0xFF      
	out DDRC, temp1				;PortC als Ausgang
	out DDRB, temp1				;PortB als Ausgang

	clr temp1
	out PORTC, temp1			;PORTC zurcksetzen
	out PORTB, temp1			;Led an

    call lcd_init              	;LC-Display initialisieren
    call lcd_clear             	;Display lschen
;	call text_init

	ldi zeile, 1
	ldi spalte, 8
	call set_cursor

	call usart_init
 

/*
	ldi zeile, 1
	ldi spalte, 8
	call set_cursor
*/


	call wait_1s
	call call_phone	

ende:



   

jmp   ende


wait_1s:
push R25
push R26
push R27
; warte 11058993 Zyklen:
          ldi  R25, $BB
WGLOOP0a:  ldi  R26, $4D
WGLOOP1a:  ldi  R27, $FF
WGLOOP2a:  dec  R27
          brne WGLOOP2a
          dec  R26
          brne WGLOOP1a
          dec  R25
          brne WGLOOP0a
; ----------------------------- 
; warte 6 Zyklen:
          ldi  R25, $02
WGLOOP3a:  dec  R25
          brne WGLOOP3a
; ----------------------------- 
; warte 1 Zyklus:
          nop
pop R27
pop R26
pop R25
ret

;****************************************************************************
;Subroutinen / ISRs
;**************************************************************************** 

TIM2_OVF:
         sbi PORTB, 0
         reti
 
TIM1_OVF:
         reti                              

TIM0_OVF:
         sbi PORTB, 0
         reti

SPI_STC:
         sbi PORTB, 0
         reti


USART_RXC:
    	push temp1	
    	in temp1, sreg          ; SREG sichern
    	push temp1

    	in temp1, UDR           ; empfangendes Byte lesen
    	call lcd_data	        ; Daten ausgeben

    	pop temp1
	    out sreg, temp1         ; SREG wiederherstellen
   		pop temp1                  
    	reti                    ; Interrupt beenden 


USART_DRE:
         sbi PORTB, 0
         reti

USART_TXC:
              
	     reti                  

ADCC:
         sbi PORTB, 0
         reti

ANA_COMP:
         sbi PORTB, 0
         reti

TWSI:
         sbi PORTB, 0
         reti

