;****************************************************************************
;*		Anschlussplan Display zum AVR	       								*
;*--------------------------------------------------------------------------*
;*    Pin Belegung Display		: Pin Belegung ATMega32        				*
;*--------------------------------------------------------------------------*
;* 1.  GND          			: 01.	GND		       						*
;* 2.  +5V						: 02.	+5V		      						*
;* 3.  Vo Contrast				: 03. ber 10k Poti auf +5V					*
;* 4.  RS Daten oder Code Input	: 04.	PD3									*
;* 5.  R/W 						: 05.	 -									*		
;* 6.  Enable					: 06.	PD2									*
;* 7.  DB0						: 07. 	n.c.								*
;* 8.  DB1						: 08.	n.c.								*
;* 9.  DB2						: 09.	n.c.								*
;* 10. DB3						: 10.	n.c.								*
;* 11. DB4						: 11.	PD4	   	   							*
;* 12. DB5						: 12.	PD5	      							*
;* 13. DB6						: 13.	PD6	      							*
;* 14. DB7						: 14.	PD7	      							*
;* 15. Anode  LED				: 17. +5V ber Vorwiderstand 				*
;* 16. Katode LED				: 18.	GND		       						*
;****************************************************************************

;----------------------------------------------------------------------------
;   Definition der Steuerleitungen
;----------------------------------------------------------------------------
.equ	LCD_Port = PortD		; Port fr Datenleitungen
.equ	LCD_DDR	 = DDRD			; Datenrichtungsregister fr Datenleitung
.equ	LCD_E	 = PD2			; Enable Leitung
.equ	LCD_RS	 = PD3			; Befehlsleitung
;.equ	PIN_RW   =  -			; Read / Write Leitung
.equ	DB4		 = PD4
.equ	DB5		 = PD5
.equ	DB6		 = PD6
.equ	DB7		 = PD7

;----------------------------------------------------------------------------
;   Definition der Arbeitsregister
;----------------------------------------------------------------------------
.def	zeile	=	r19			; zur Angabe in welche Zeile, Spalte des
.def	spalte	=	r20			; Display der Cursor gesetzt werden soll

;----------------------------------------------------------------------------
;   Definition der Arbeitsfrequenz
;----------------------------------------------------------------------------
.ifndef XTAL
.equ XTAL = 11059000
.endif

;--------Unterprogramm zur Initialisierung-----------------------------------
lcd_init:								; Aktivierung 4-Bit Modus

		   push temp1	
		   push temp2
		   ldi temp1, 0xfc				; 0x0b11111100
		   out LCD_DDR, temp1			; LCD Port-Pins als Ausgang

           ldi temp2,50					; wait for more than 15ms
powerupwait:							; 5ms*50=250ms
           rcall delay5ms
           dec  temp2
           brne powerupwait				; branch if not equal
		   								; Tests the Zero Flag and branches relatively to PC
										; if Z is cleared.
		   								; Das Zero Flag ist gesetzt, wenn das letzte 
										; Rechenergebnis gleich null ist.

		   cbi LCD_Port, LCD_E			; clear bit in I/O-Register E=0
		   cbi LCD_Port, LCD_RS			; RS=0; ankommendes Byte als Befehl
		   sbi LCD_Port, DB4			; set bit in I/O-Register DB4=1
		   sbi LCD_Port, DB5			; muss 3mal hintereinander gesendet
		   cbi LCD_Port, DB6		   	; werden zur Initialisierung
		   cbi LCD_Port, DB7         
           rcall lcd_enable

           rcall delay5ms				; wait for more than 4.1ms
           rcall lcd_enable             
           rcall delay5ms				; wait fore more than 100us
           rcall lcd_enable             
           rcall delay5ms	

		   cbi LCD_Port, LCD_RS			; 4bit-Modus aktivieren					
		   cbi LCD_Port, DB4					
		   sbi LCD_Port, DB5		   	
		   cbi LCD_Port, DB6
		   cbi LCD_Port, DB7		
           rcall lcd_enable
           rcall delay5ms

           ldi temp1, 0b00101000        ; 4Bit / 2 Zeilen / 5x7
           rcall lcd_command
           ldi temp1, 0b00001100        ; Display ein / Cursor aus / kein Blinken
           rcall lcd_command
           ldi temp1, 0b00000110        ; set cursor move increase, display is not shifted
           rcall lcd_command

		   pop temp2
           pop temp1
           ret

;--------Unterprogramm zur Sendung eines Befehls an das LCD------------------
lcd_command:                            ; wie lcd_data, nur RS=0
           push temp2
		   push temp1
           mov temp2, temp1				; Sicherungskopie
           andi temp1, 0b11110000
           out LCD_PORT, temp1
           rcall lcd_enable

           swap temp2					; Nibble tauschen
           andi temp2, 0b11110000
           out LCD_PORT, temp2
           rcall lcd_enable
           rcall delay50us
			
		   pop temp1
           pop temp2
           ret	   
		    
;--------Unterprogramm zur Sendung eines Datenbytes an das LCD---------------
lcd_data:
           push temp2
		   push temp1

           mov temp2, temp1             ; "Sicherungskopie" fr die bertragung des 2.Nibbles
           andi temp1, 0b11110000       ; oberes Nibble auf Null setzen
           out LCD_PORT, temp1          ; ausgeben
		   sbi LCD_Port, LCD_RS			 
           rcall lcd_enable             ; Enable-Routine aufrufen
                                        ; 2. Nibble, kein swap da es schon
                                        ; an der richtigen stelle ist
		   swap temp2	
           andi temp2, 0b11110000       ; obere Hlfte auf Null setzen 
           out LCD_PORT, temp2          ; ausgeben
		   sbi LCD_Port, LCD_RS	
           rcall lcd_enable             ; Enable-Routine aufrufen
           rcall delay50us              ; Delay-Routine aufrufen

		   pop temp1
           pop temp2
           ret                          ; zurck zum Hauptprogramm

;--------Unterprogramm zur Ausgabe eines Textes aus dem Flash-Speicher-------

lcd_flash_string:
           push  temp1

lcd_flash_string_1:
           lpm   temp1, Z+
           cpi   temp1, 0
           breq  lcd_flash_string_2
           rcall lcd_data
           rjmp  lcd_flash_string_1
 
lcd_flash_string_2:
           pop   temp1
           ret

;--------Unterprogramm zur Erzeugung eines Enable-Puls-----------------------
lcd_enable:
           sbi LCD_PORT, LCD_E          ; Enable high
           nop                          ; 3 Taktzyklen warten
           nop
           nop
           cbi LCD_PORT, LCD_E          ; Enable wieder low
           ret                          ; Und wieder zurck

;--------Unterprogramm wait 5ms----------------------------------------------
delay5ms:                               ; 5ms Pause
		   push temp1
		   push temp2
           ldi  temp1, ( XTAL * 5 / 607 ) / 1000
WGLOOP0:   ldi  temp2, $C9
WGLOOP1:   dec  temp2
           brne WGLOOP1
           dec  temp1
           brne WGLOOP0
		   pop 	temp2
		   pop	temp1
           ret                          

;--------Unterprogramm wait 50us----------------------------------------------
delay50us:                              ; 50us Pause
		   push temp1
           ldi  temp1, ( XTAL * 50 / 3 ) / 1000000
delay50us_:dec  temp1
           brne delay50us_
		   pop 	temp1
           ret

;--------Unterprogramm zur Lschung des Displays-----------------------------
lcd_clear:
           push  temp1
           ldi   temp1, 0b00000001      ; Display lschen
           rcall lcd_command
           rcall delay5ms
           pop   temp1
           ret

;--------Unterprogramm Cursor Home------------------------------------------- 
lcd_home:
           push  temp1
           ldi   temp1, 0b00000010      ; cursor move to first digit
           rcall lcd_command
           rcall delay5ms
           pop   temp1
           ret

;--------Unterprogramm Set Cursor-------------------------------------------- 
set_cursor:

			push temp1
			push temp2
			push zeile
			push spalte

			mov temp2, zeile			; in temp2 wird die Zahl, in welche Zeile der Cursor gesetzt werden soll, geladen 
			ldi temp1, 0x80				; Adresse der 1. Zeile in temp1 laden
			dec temp2					; Zeilenzahl um eins erniedrigen
										; wenn Cursor in 1. Zeile gesetzt werden soll, dann springe nach finish
			breq finish					; branch if equal, branches if zero flag is set
			dec temp2					; wenn Cursor nicht in 1. Zeile gesetzt werden soll, dann erniedrige Zeilenzahl erneut
			ldi temp1, 0xC0				; Cursor soll mind. in die zweite Zeile gesetzt werden
										; Adresse der 2. Zeile wird in temp1 geladen
			breq finish					; wenn nun Zeilenzahl Null,  dann springe nach finish
										; ansonsten Zeilenzahl weiter erniedrigen und dementsprechend die Adresse der Zeile in temp1 laden
			dec temp2
			ldi temp1, 0x94				; Adresse der 3. Zeile 
			breq finish					

			ldi temp1, 0xD4				; Adresse der 4. Zeile
			dec spalte
			add temp1, spalte			
			rcall lcd_command
			
			pop spalte
			pop zeile
			pop temp2
			pop temp1
			ret
finish:		
			dec spalte
			add temp1, spalte			;  Addition der Adresse der Zeile (temp1) und Adresse der Spalte
			rcall lcd_command
			pop spalte
			pop zeile
			pop temp2
			pop temp1						
			ret

;zeile1	= 0x80			; Startadresse der 1. Display Zeile		// 0x80+0x00+x
;zeile2	= 0xC0			; Startadresse der 2. Display Zeile		// 0x80+0x40+x	
;zeile3	= 0x94			; Startadresse der 3. Display Zeile		// 0x94+0x00+x
;zeile4	= 0xD4			; Startadresse der 4. Display Zeile		// 0x94+0x40+x


