
;--------Variablendefinitionen zur Nutzung des USART--------------------------

.equ F_CPU = 11059000                           ; Systemtakt in Hz
.equ BAUD  = 9600                               ; Baudrate

; Berechnungen
.equ UBRR_VAL   = ((F_CPU+BAUD*8)/(BAUD*16)-1)  ; clever runden

;--------Unterprogramm zur Initialisierung des USART--------------------------

usart_init:
	
	push temp1
	push temp2

	sei								; set global interrupt enable
									; Status Register SREG
									 
    ; Baudrate einstellen
    ldi temp1, HIGH(UBRR_VAL)
    out UBRRH, temp1
    ldi temp1, LOW(UBRR_VAL)
    out UBRRL, temp1


	; USART Control and Status Register B UCSRB
	; RXCIE TXCIE UDRIE RXEN TXEN UCSZ2 RXB8 TXB8
	sbi UCSRB, RXCIE				; RXCIE=1	Receive Complete Interrupt enable
	sbi UCSRB, RXEN					; RXEN=1	Receiver enable	
    sbi UCSRB, TXEN                 ; TXEN=1	Transmitter enable 


	; USART Control and Status Register C UCSRC
	; URSEL UMSEL UPM1 UPM0 USBS UCSZ1 UCSZ0 UCPOL
	ldi temp1, (1<<URSEL)|(1<<UCSZ1)|(1<<UCSZ0)		 
	out UCSRC, temp1
	cbi UCSRB, UCSZ2				; 8-Bit Character Size

	; UCSZ2, UCSZ1, UCSZ0 Character Size		
	; sets the number of data bits in a frame the Receiver and Transmitter use.
		
/*

	; URSEL=1			URSEL Register Select
							; selects between accessing the UCSRC or the UBRRH Register
							; must be one when writing the UCSRC

	; UMSEL=0			USART Mode Select 		UMSEL=0			Asynchronous Operation	
	; UPM1=0, UPM0=0	Parity Mode 			UPM1=0, UPM0=0	Disabled
	; USBS=0 			USBS Stop Bit Select	USBS=0 			one Stop Bit	
	; UCPOL=0			UCPOL Clock Polarity
							; This bit is used for Synchronous mode only. 
							; Write this bit to zero when Asynchronous mode is used.
*/
				
	ldi temp1, 0x00
	out UDR, temp1					; clear USART Data Register

	pop temp2
	pop temp1
	ret
