/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : clock20x37.h
    Date                : 30.03.2004
    Font size in bytes  : 0x04E8, 1256
    Font width          : 20
    Font height         : 37
    Font first char     : 0x30
    Font last char      : 0x3A
    Font bits per pixel : 2
    Font is compressed  : true

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef clock20x37_H
#define clock20x37_H

#define clock20x37_WIDTH 20
#define clock20x37_HEIGHT 37

static uint8_t __attribute__ ((progmem)) clock20x37[] = {
    0x04, 0xE8, 0x14, 0x25, 0x82, 0x30, 0x3A,
    0x13, 0x0C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x08, 
    0x01, 0x02, 0x05, 0x0B, 
    0x6C, 0x32, 0x7E, 0x9B, 0x62, 0x96, 0x8E, 0x57, 0x77, 0x85, 0x37, 
    0xC2, 0x66, 0x3C, 0x03, 0x5C, 0xAC, 0xD8, 0x67, 0xC4, 0x02, 0x4C, 0xAC, 0x99, 0x7C, 0x56, 0xC4, 
    0x01, 0x4C, 0xAC, 0x7A, 0x66, 0x1C, 0xC4, 0xAB, 0xC8, 0x57, 0x05, 0x4C, 0xAB, 0xC9, 0x57, 0xC5, 
    0xC4, 0x9A, 0x7C, 0x67, 0xA4, 0x89, 0x67, 0x55, 0x8C, 0x6C, 0xA4, 0x89, 0x5C, 0x3C, 0x01, 0x4C, 
    0x99, 0x5C, 0xA5, 0x99, 0xC4, 0x23, 0xA4, 0x5C, 0xA4, 0x89, 0x4C, 0x23, 0x40, 0xCA, 0x45, 0x9A, 
    0x58, 0x3C, 0x11, 0x4C, 0xCA, 0x45, 0xAC, 0x89, 0x7C, 0x56, 0x6D, 0xC4, 0xC4, 0xAA, 0x7C, 0xC7, 
    0x50, 0xAC, 0xCA, 0x67, 0x16, 0x5C, 0xAC, 0xCA, 0x67, 0x45, 0x1C, 0xC1, 0xC4, 0x9A, 0xC8, 0x67, 
    0x45, 0x2C, 0x50, 0xC5, 0x99, 0x7C, 0x56, 0x3C, 0x6C, 0xC5, 0x23, 0x02, 0x01, 0x6C, 0x3C, 0x23, 
    0xC1, 0xC4, 0x89, 0x4C, 0x33, 0x12, 0xC4, 0x99, 0x4C, 0x33, 0x02, 0x4C, 0x5A, 0x33, 0xC2, 0xC4, 
    0x5A, 0x3C, 0x13, 0x41, 0xAC, 0xC8, 0x77, 0x56, 0xBC, 0xAA, 0x7D, 0x45, 0xBB, 0x7C, 0xC5, 0x9B, 
    0xC8, 0x67, 0xA6, 0x89, 0x7C, 0x67, 0xC4, 0xCA, 0x77, 0x56, 0x6C, 0x45, 0x3C, 0x23, 0x11, 0x6C, 
    0xC5, 0x33, 0xC2, 0xC4, 0xCA, 0x34, 0xC0, 0x17, 0x4C, 0xAC, 0xC8, 0x24, 0xC2, 0x57, 0xC0, 0xC4, 
    0x5A, 0xC4, 0x12, 0xC0, 0x57, 0x05, 0xC4, 0xCA, 0xC5, 0x12, 0x7C, 0x46, 0x4C, 0x5A, 0x25, 0xC1, 
    0x67, 0x45, 0xAC, 0x55, 0xC2, 0x57, 0xD4, 0xA6, 0x58, 0x2C, 0x7C, 0x45, 0x9C, 0xA6, 0x4C, 0x1C, 
    0xC1, 0x47, 0x0C, 0x4C, 0x89, 0xA6, 0xC5, 0xC1, 0x47, 0x1C, 0x41, 0x99, 0x5D, 0x9C, 0xC9, 0x67, 
    0x2C, 0xA4, 0x5C, 0xA4, 0x57, 0xC4, 0x12, 0x94, 0x68, 0xA4, 0x47, 0x2C, 0x11, 0x94, 0xC8, 0x45, 
    0x4C, 0xAC, 0x6C, 0x55, 0x2C, 0x42, 0x99, 0x45, 0x50, 0xCB, 0xC5, 0x43, 0x99, 0x45, 0xC0, 0xC4, 
    0x4B, 0x3C, 0x40, 0x99, 0x45, 0xC1, 0xC5, 0x9A, 0xC8, 0x34, 0x41, 0x9C, 0xC8, 0x15, 0xC0, 0xC5, 
    0xCA, 0xC5, 0x13, 0xC5, 0xC8, 0x45, 0xC2, 0x56, 0x3C, 0xC2, 0x45, 0x1C, 0xC2, 0x56, 0x3C, 0x01, 
    0x5C, 0xC4, 0x12, 0x5C, 0xAC, 0x4C, 0x03, 0x5C, 0x8C, 0x4C, 0x2C, 0x4C, 0xAC, 0xC9, 0x34, 0x50, 
    0x9C, 0xC8, 0x24, 0xC4, 0x8A, 0x45, 0x3C, 0x50, 0x99, 0x4C, 0x1C, 0xC0, 0xA4, 0xC9, 0xC4, 0x13, 
    0x95, 0x58, 0xC5, 0x41, 0xAC, 0xC9, 0x14, 0xC0, 0xC6, 0x11, 0xC4, 0x89, 0x16, 0xA4, 0xC9, 0xC4, 
    0xC1, 0xC4, 0x89, 0x4C, 0x1C, 0x50, 0x89, 0x5C, 0xC5, 0x40, 0x8A, 0x5C, 0x01, 0x95, 0x59, 0x14, 
    0x50, 0x9C, 0xC8, 0x55, 0x4C, 0x5A, 0x1C, 0x51, 0x99, 0x5C, 0x01, 0x45, 0x4C, 0xC9, 0xA6, 0xC4, 
    0x52, 0x99, 0x5C, 0xC2, 0xC4, 0x89, 0x5C, 0xA5, 0xC5, 0x11, 0x4C, 0x89, 0x5C, 0xC4, 0xC2, 0x94, 
    0xC8, 0x55, 0xCA, 0xC4, 0x11, 0x4C, 0x89, 0x55, 0x2C, 0x4C, 0x89, 0x5C, 0xA5, 0xC8, 0x56, 0x9C, 
    0xC8, 0x66, 0x5D, 0xC5, 0xA4, 0x89, 0x6C, 0xD5, 0x67, 0x0C, 0xC4, 0x8A, 0x7D, 0x57, 0x14, 0x4C, 
    0xAC, 0x77, 0x55, 0x1C, 0x50, 0xAC, 0xD9, 0xC6, 0x57, 0xC4, 0x11, 0x5C, 0xC4, 0x8A, 0x5C, 0xC5, 
    0xC0, 0xC7, 0x12, 0xC1, 0x56, 0xC4, 0x33, 0xC0, 0x56, 0xC4, 0x33, 0x42, 0x9C, 0x94, 0xC8, 0xC4, 
    0x33, 0x01, 0x4C, 0x8A, 0x7C, 0x45, 0x13, 0x40, 0xAC, 0xCA, 0x66, 0x13, 0x40, 0x8B, 0x66, 0x13, 
    0x40, 0xBC, 0x89, 0x6C, 0x34, 0x01, 0x4C, 0x9B, 0x6C, 0x35, 0x11, 0xC4, 0x99, 0x7C, 0x55, 0x13, 
    0xC1, 0xC4, 0x55, 0x1C, 0xD1, 0x84, 0x6C, 0x13, 0xC1, 0xC6, 0x02, 0x4C, 0x9C, 0xC8, 0xC5, 0x13, 
    0x40, 0x9C, 0xC8, 0x77, 0x56, 0xC4, 0xA4, 0xC9, 0x77, 0x46, 0xAC, 0x89, 0x77, 0x46, 0xDB, 0x77, 
    0xB5, 0xC8, 0x77, 0xC5, 0xCA, 0x77, 0x56, 0x4C, 0x9C, 0x6C, 0xC6, 0x48, 0xD8, 0x57, 0x05, 0xC6, 
    0x12, 0x4C, 0xCA, 0xC4, 0x33, 0x02, 0x6C, 0x35, 0x01, 0xC0, 0x56, 0x3C, 0x01, 0x46, 0x2C, 0x41, 
    0x9C, 0xC9, 0x47, 0x01, 0x4C, 0x9C, 0xC8, 0xC5, 0x42, 0x8A, 0x7C, 0x01, 0x95, 0x69, 0x1C, 0x40, 
    0x89, 0x7C, 0x45, 0x01, 0xC4, 0xDA, 0x45, 0x0C, 0x4C, 0x89, 0x57, 0x15, 0x40, 0x9A, 0x5C, 0x05, 
    0xC4, 0x89, 0x57, 0x15, 0x40, 0xAC, 0x6C, 0x4C, 0x99, 0x7C, 0x45, 0x01, 0xC5, 0xC9, 0x56, 0xA5, 
    0xC5, 0xC0, 0xC4, 0xD8, 0x45, 0x1C, 0xC0, 0xC6, 0x56, 0xC4, 0x89, 0x45, 0xC1, 0x94, 0x59, 0x3C, 
    0x6C, 0xC4, 0x94, 0x5C, 0x14, 0xC4, 0x89, 0x5C, 0x3C, 0x6C, 0xC4, 0x94, 0x55, 0x41, 0x99, 0x45, 
    0x3C, 0x6C, 0x04, 0x94, 0x55, 0x41, 0x99, 0x5C, 0xC4, 0x12, 0xC1, 0x56, 0x40, 0xC9, 0x45, 0x41, 
    0x9A, 0x7C, 0x56, 0x40, 0x89, 0x45, 0x41, 0xBC, 0xC8, 0xC7, 0x40, 0x89, 0x45, 0xC1, 0xA4, 0x89, 
    0x67, 0x41, 0x99, 0x4C, 0x01, 0xC4, 0x9A, 0xC8, 0x57, 0x1C, 0xC4, 0xC8, 0x45, 0x01, 0x4C, 0xAC, 
    0x89, 0x7C, 0x1C, 0x50, 0xC5, 0x02, 0x4C, 0x9C, 0x7C, 0x45, 0x3C, 0x02, 0x6C, 0x3C, 0x02, 0xC2, 
    0x56, 0xC5, 0x33, 0x01, 0x4C, 0xAC, 0xC9, 0x67, 0xC4, 0x12, 0xC5, 0x9A, 0x67, 0xC6, 0x11, 0x4C, 
    0xAC, 0x89, 0x77, 0x1C, 0x4C, 0xBC, 0x89, 0x7C, 0x46, 0x41, 0xBC, 0x89, 0x67, 0x45, 0x0C, 0xA4, 
    0x68, 0x94, 0xD9, 0x67, 0xC4, 0xA4, 0x4C, 0x0C, 0x4C, 0xAC, 0x4C, 0x2C, 0x4D, 0x8C, 0x6C, 0xA4, 
    0xC4, 0x01, 0xC4, 0x99, 0x5C, 0x12, 0x40, 0xCA, 0x45, 0x4A, 0x1C, 0x40, 0x9C, 0x59, 0x24, 0x01, 
    0xA4, 0x58, 0xA4, 0x4C, 0x4C, 0x5C, 0x99, 0x5C, 0x2C, 0xC0, 0xC4, 0x99, 0x5C, 0xA4, 0xC8, 0xC4, 
    0xC4, 0xA4, 0x67, 0xC5, 0xA4, 0x99, 0x04, 0xA4, 0x7C, 0xC6, 0x40, 0xAC, 0x48, 0x4C, 0x40, 0xBC, 
    0xC9, 0x56, 0x51, 0x8A, 0x5C, 0xC0, 0xC4, 0x99, 0xC4, 0x99, 0x6C, 0x45, 0x1C, 0x4C, 0x9C, 0xC9, 
    0x45, 0x51, 0x9C, 0xC8, 0x57, 0x1C, 0xC1, 0xC5, 0xC8, 0x55, 0xC1, 0xC5, 0x99, 0x6D, 0x55, 0x2C, 
    0xC0, 0x56, 0x1C, 0xC0, 0x45, 0x9C, 0xC8, 0xC4, 0x33, 0x12, 0x6C, 0x3C, 0x00, 0xC0, 0x56, 0x3C, 
    0x23, 0xC5, 0xCA, 0x34, 0x23, 0xC4, 0xCA, 0x35, 0x23, 0xA4, 0x48, 0x3C, 0x23, 0x40, 0x8A, 0x34, 
    0x13, 0x6C, 0x8A, 0x34, 0x12, 0xC1, 0x56, 0xA5, 0x48, 0x13, 0xC1, 0x57, 0xA4, 0x48, 0xC3, 0x67, 
    0xA5, 0x48, 0x12, 0x7C, 0xA7, 0x48, 0x7D, 0x67, 0xA4, 0x58, 0xC4, 0x8A, 0x7D, 0xC6, 0x40, 0xAB, 
    0xC8, 0xC7, 0x02, 0xB4, 0xC9, 0xC7, 0x22, 0xB4, 0x6C, 0x55, 0x3C, 0x01, 0xB4, 0x46, 0x3C, 0x12, 
    0xC4, 0xAA, 0x4C, 0x3C, 0x53, 0x9A, 0xC8, 0xC5, 0x33, 0xC0, 0xC4, 0xC8, 0x46, 0x3C, 0x13, 0xC1, 
    0x45, 0x3C, 0x23, 0x11, 0xC2, 0x56, 0xC4, 0x33, 0x01, 0x5C, 0xAC, 0x5C, 0xC5, 0xC1, 0xC7, 0x02, 
    0x4C, 0xAC, 0x69, 0xC5, 0x57, 0xC4, 0x11, 0xC4, 0xCB, 0x67, 0x45, 0x1C, 0x4C, 0x8B, 0x7C, 0x56, 
    0x15, 0xC4, 0xAA, 0x7C, 0xD7, 0xA4, 0x6C, 0x45, 0x7D, 0xC5, 0xC8, 0x55, 0xAC, 0xC4, 0x11, 0x4C, 
    0x9C, 0xC6, 0x11, 0x4C, 0x9C, 0xC8, 0x45, 0x8A, 0x24, 0x40, 0xCA, 0x25, 0x40, 0x89, 0xA6, 0x48, 
    0x02, 0xA4, 0x58, 0x02, 0x94, 0x68, 0x8A, 0xC4, 0x42, 0xCA, 0x25, 0x40, 0x8C, 0x6C, 0x8A, 0x46, 
    0x4C, 0x9C, 0x5C, 0xC5, 0x11, 0x5C, 0x6C, 0xB4, 0x7C, 0x57, 0xB4, 0x7C, 0x47, 0x4C, 0xAC, 0x99, 
    0x77, 0x45, 0xC0, 0xC4, 0xAA, 0x7C, 0x66, 0x1C, 0x45, 0xAC, 0x99, 0x5C, 0xC5, 0x57, 0xC4, 0x11, 
    0x5D, 0xAC, 0x5C, 0xC5, 0xC1, 0xC7, 0x12, 0xC1, 0x56, 0x3C, 0x03, 0xC2, 0x56, 0xC4, 0xC3, 0x55, 
    0x2C, 0x01, 0x5C, 0xAC, 0xC8, 0xC6, 0x02, 0xC4, 0xC9, 0xC4, 0x02, 0x4C, 0xAC, 0x48, 0x6D, 0xC5, 
    0x01, 0x4C, 0x89, 0x5C, 0xC4, 0x11, 0xC4, 0x9A, 0xC7, 0x41, 0x9C, 0x48, 0x5D, 0x1C, 0x4C, 0x9B, 
    0xC8, 0xC6, 0xC0, 0xA4, 0x5C, 0x14, 0xC4, 0x9B, 0x6D, 0x04, 0xC4, 0x89, 0x6C, 0x4D, 0x8A, 0x67, 
    0xC0, 0xC4, 0xC8, 0x56, 0xC4, 0xCA, 0xC4, 0xC2, 0xC4, 0xC8, 0x55, 0xC1, 0xA7, 0x48, 0x2C, 0x41, 
    0x89, 0x55, 0x11, 0x6C, 0x55, 0xCA, 0xC4, 0x12, 0x94, 0x58, 0x25, 0x56, 0xA5, 0x45, 0x2C, 0x4C, 
    0x89, 0x55, 0x1C, 0xC0, 0x56, 0xA5, 0xC9, 0x56, 0xC4, 0xC9, 0x67, 0xC4, 0x9B, 0x7C, 0x56, 0xD5, 
    0xB4, 0x89, 0x67, 0x55, 0x41, 0xBC, 0x89, 0x7C, 0x46, 0x1C, 0x4C, 0xBC, 0xC8, 0x67, 0xC4, 0x11, 
    0x4C, 0xAC, 0x7A, 0x46, 0x2C, 0xC1, 0x55, 0xAC, 0x4C, 0x3C, 0x13, 0xC0, 0x56, 0xC5, 0x23, 0x02, 
    0xC3, 0xC5, 0x12, 0xC1, 0xC5, 0x23, 0x01, 0x4C, 0x5D, 0xC4, 0xC2, 0xD4, 0xC5, 0x23, 0x40, 0x9C, 
    0x55, 0x1C, 0x41, 0x9C, 0x45, 0x3C, 0x42, 0xC9, 0x16, 0xC0, 0x94, 0xD9, 0x34, 0x42, 0x8C, 0x46, 
    0x01, 0x95, 0xC8, 0x45, 0x23, 0xD5, 0x16, 0x50, 0x9C, 0x55, 0x23, 0xC0, 0xC6, 0x11, 0x5C, 0x5D, 
    0xC4, 0x33, 0x12, 0x5C, 0xC4, 0x12, 0x01
};

#endif

