/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : clock27x49.h
    Date                : 30.03.2004
    Font size in bytes  : 0x071C, 1820
    Font width          : 27
    Font height         : 49
    Font first char     : 0x30
    Font last char      : 0x3A
    Font bits per pixel : 2
    Font is compressed  : true

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef clock27x49_H
#define clock27x49_H

#define clock27x49_WIDTH 27
#define clock27x49_HEIGHT 49

static uint8_t __attribute__ ((progmem)) clock27x49[] = {
    0x07, 0x1C, 0x1B, 0x31, 0x82, 0x30, 0x3A,
    0x1A, 0x12, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x0C, 
    0x01, 0x02, 0x05, 0x0D, 
    0x96, 0x51, 0xD0, 0xD8, 0x94, 0xDD, 0xC1, 0x89, 0xA2, 0xB8, 0x57, 
    0x12, 0xC1, 0x56, 0x3C, 0x23, 0x02, 0x7C, 0xC4, 0x33, 0xC2, 0x55, 0xAC, 0xC8, 0x67, 0x56, 0x2C, 
    0x11, 0x5C, 0xC4, 0xAA, 0x7C, 0x66, 0xC5, 0x02, 0x5C, 0xBC, 0x7C, 0x66, 0xC5, 0x11, 0x5C, 0xAC, 
    0x9A, 0x7C, 0x57, 0x1C, 0x50, 0xBC, 0x89, 0x7C, 0xC7, 0xC0, 0xC4, 0xAB, 0xCA, 0x67, 0x45, 0x50, 
    0xAC, 0x89, 0x7C, 0x67, 0xC6, 0xA5, 0x99, 0x77, 0x47, 0x9A, 0x79, 0x77, 0xA4, 0x99, 0x5C, 0x3C, 
    0x12, 0x5C, 0x8C, 0x6C, 0xA6, 0xCA, 0x35, 0x12, 0x40, 0x9C, 0xC8, 0x56, 0xA5, 0x8A, 0x35, 0x12, 
    0x40, 0xAC, 0xC8, 0x46, 0x9A, 0xC9, 0x45, 0x3C, 0x02, 0x4C, 0xAC, 0xC8, 0x46, 0x9A, 0xC9, 0x77, 
    0x6D, 0x46, 0xAA, 0xC8, 0x77, 0x66, 0xC4, 0xAA, 0xC8, 0x77, 0x56, 0xC4, 0xC4, 0x8B, 0x7C, 0x57, 
    0xC5, 0x50, 0xBC, 0xC8, 0x77, 0x45, 0xC1, 0xC5, 0x8B, 0x7C, 0x47, 0x1C, 0xC0, 0xC5, 0xCB, 0x77, 
    0x2C, 0x5C, 0xC4, 0xAA, 0x7C, 0xC7, 0x12, 0x5C, 0xC5, 0x9A, 0x7C, 0xC7, 0x22, 0x7C, 0x67, 0x55, 
    0x3C, 0xC1, 0x56, 0xC5, 0x33, 0x01, 0xC2, 0x46, 0x3C, 0x33, 0x60, 0x55, 0x3C, 0x23, 0x12, 0x5C, 
    0x9C, 0xC8, 0x45, 0x33, 0x22, 0xC0, 0x45, 0xCA, 0x35, 0x23, 0x02, 0xC5, 0xCA, 0x45, 0x33, 0x22, 
    0x5C, 0x8A, 0x55, 0x33, 0x12, 0xC1, 0xC5, 0x8A, 0x77, 0x66, 0xC5, 0xC5, 0x9A, 0x7C, 0x77, 0xA4, 
    0x99, 0x7C, 0x77, 0xBB, 0x89, 0x7C, 0x46, 0xBB, 0x99, 0x7C, 0xB6, 0x8A, 0x7C, 0x57, 0xA4, 0xCA, 
    0x77, 0x66, 0xA5, 0x99, 0x7C, 0x77, 0xAC, 0xC8, 0x77, 0xC7, 0x45, 0x7C, 0x77, 0x55, 0x0C, 0x6C, 
    0x46, 0x3C, 0x23, 0x12, 0x6C, 0x3C, 0x33, 0x12, 0x6C, 0xC5, 0x23, 0x11, 0x6C, 0x55, 0x2C, 0xC0, 
    0x66, 0x3C, 0x11, 0x7C, 0xC2, 0xC5, 0xCA, 0x45, 0x13, 0x7C, 0x15, 0xC1, 0xC5, 0x9A, 0x4C, 0x3C, 
    0x7C, 0x55, 0x01, 0x5C, 0xAC, 0xC8, 0x45, 0x22, 0xC1, 0x67, 0x14, 0x5C, 0xAC, 0xC8, 0x55, 0x22, 
    0xC0, 0x67, 0x05, 0x5C, 0xAC, 0x59, 0xC4, 0x22, 0x7C, 0x56, 0x05, 0xC5, 0x9A, 0x5C, 0x24, 0x11, 
    0x7C, 0x66, 0xC4, 0xA5, 0xC9, 0x45, 0x2C, 0x01, 0x7C, 0x47, 0xAC, 0xC8, 0x55, 0x12, 0x7C, 0x57, 
    0xA4, 0x59, 0xC5, 0x02, 0x7C, 0x46, 0x9C, 0x6C, 0xC4, 0x9A, 0x45, 0x2C, 0x7C, 0x46, 0x4C, 0x99, 
    0x46, 0xAC, 0xC8, 0xC5, 0x11, 0x7C, 0xC6, 0x01, 0x94, 0xC9, 0x46, 0x8A, 0x55, 0x0C, 0x7C, 0x46, 
    0x1C, 0x41, 0x9A, 0x5C, 0xA4, 0x78, 0x66, 0xC5, 0x42, 0x8A, 0x5C, 0xA5, 0xC8, 0x67, 0x55, 0x2C, 
    0x41, 0x99, 0x6C, 0xA4, 0x79, 0x56, 0xC4, 0x12, 0x40, 0x9C, 0x68, 0x4C, 0xAC, 0xC8, 0x67, 0xC4, 
    0x12, 0x51, 0x89, 0x06, 0xA5, 0x79, 0x55, 0x2C, 0x02, 0x95, 0x68, 0xC0, 0xC4, 0x8A, 0x7C, 0xC5, 
    0x22, 0x41, 0x9C, 0xC8, 0x55, 0x51, 0xAC, 0xC9, 0xC6, 0xC6, 0x03, 0xA4, 0x55, 0xC1, 0xC5, 0x8B, 
    0x5C, 0x3C, 0x41, 0x5A, 0x15, 0xC0, 0xC5, 0xAA, 0xC9, 0xC5, 0x13, 0x40, 0x9C, 0xC9, 0x45, 0x11, 
    0x5C, 0xC4, 0x9A, 0xC8, 0x55, 0x13, 0x51, 0x9C, 0x5D, 0x2C, 0x7C, 0xC4, 0x23, 0x6C, 0xC5, 0x12, 
    0xC0, 0x66, 0x3C, 0x12, 0xC0, 0xC6, 0x01, 0x02, 0x6C, 0xC6, 0x23, 0x5C, 0xC5, 0x22, 0xC0, 0x37, 
    0x11, 0x6C, 0xC5, 0x12, 0xC0, 0x55, 0xAC, 0x5D, 0x13, 0x51, 0x9C, 0x5C, 0x24, 0xC1, 0x45, 0xAC, 
    0x89, 0x5C, 0x13, 0xC0, 0xC4, 0xCA, 0xC4, 0x02, 0x45, 0xAC, 0xC8, 0x55, 0x3C, 0x01, 0xA5, 0x5C, 
    0xC5, 0x01, 0x5C, 0xAC, 0x59, 0xC5, 0x13, 0x51, 0x99, 0x56, 0x01, 0xC5, 0x9A, 0xC8, 0xC5, 0x11, 
    0x56, 0x2C, 0x50, 0x99, 0x56, 0x0C, 0x5C, 0xAA, 0x15, 0xC1, 0x56, 0xC4, 0x52, 0x99, 0x6C, 0x05, 
    0x4C, 0xAC, 0x5A, 0x11, 0x45, 0x9C, 0xC8, 0x45, 0x11, 0xA5, 0x56, 0x5C, 0xAA, 0x5C, 0x11, 0xC5, 
    0x99, 0x55, 0x11, 0xA5, 0xC8, 0x56, 0xA4, 0x99, 0x5C, 0x14, 0x51, 0x5A, 0x15, 0x51, 0x8A, 0x6C, 
    0x45, 0x8A, 0x6C, 0x1C, 0x51, 0x5A, 0x15, 0x51, 0xAC, 0x68, 0x45, 0x8A, 0x55, 0x2C, 0x50, 0xCA, 
    0x45, 0x11, 0x6C, 0x89, 0x6C, 0xA5, 0x58, 0xC4, 0x12, 0x95, 0x69, 0x1C, 0xC1, 0x55, 0xCA, 0xA6, 
    0x58, 0xC4, 0x12, 0x95, 0x69, 0xC4, 0x02, 0x4C, 0xCA, 0xA6, 0x78, 0x99, 0x7C, 0xC4, 0xC8, 0x56, 
    0xA4, 0xC8, 0x47, 0x8C, 0x7C, 0x66, 0xA5, 0x99, 0x7C, 0x67, 0x46, 0x4C, 0xAC, 0xCA, 0x77, 0x56, 
    0xD4, 0xA5, 0x99, 0x7C, 0x67, 0x55, 0x51, 0xAC, 0x79, 0x67, 0xC6, 0xC1, 0xC5, 0x8A, 0x7C, 0x67, 
    0x45, 0x1C, 0xC1, 0xC5, 0xAA, 0x6C, 0x45, 0x7C, 0x46, 0x2C, 0x50, 0xC5, 0x9A, 0xC9, 0x46, 0x0C, 
    0x7C, 0x55, 0x2C, 0x01, 0x7C, 0xC6, 0x01, 0x7C, 0xC4, 0x22, 0xC1, 0x66, 0xC4, 0x33, 0x11, 0xC1, 
    0x55, 0xCD, 0xC6, 0x33, 0x12, 0xC0, 0xC4, 0xC9, 0x45, 0x8C, 0x7C, 0x55, 0x3C, 0x02, 0xA5, 0x7A, 
    0x36, 0xC2, 0xC4, 0xAA, 0x7C, 0x55, 0x23, 0xB5, 0xC9, 0x37, 0x42, 0xBC, 0x89, 0x6C, 0x56, 0x23, 
    0xB5, 0x8A, 0x6C, 0x55, 0x23, 0x4C, 0xAC, 0xC9, 0x67, 0x35, 0xC2, 0xC5, 0x99, 0x7C, 0x56, 0x35, 
    0x02, 0x7C, 0x57, 0x34, 0x12, 0x6D, 0xD5, 0x12, 0x4C, 0x8C, 0x6C, 0x34, 0x23, 0x12, 0x95, 0xC8, 
    0x36, 0x12, 0xC0, 0xC6, 0x12, 0xC1, 0xC5, 0x99, 0x5C, 0x34, 0x12, 0x67, 0x45, 0x7C, 0x66, 0xC4, 
    0x41, 0x9C, 0xC9, 0x77, 0x47, 0xC0, 0xA4, 0x99, 0x7C, 0x67, 0x06, 0xA5, 0xCA, 0x77, 0x56, 0x05, 
    0xC4, 0x9B, 0xC8, 0x77, 0x45, 0x40, 0x9B, 0xD8, 0x77, 0x45, 0x40, 0x9A, 0xC9, 0x77, 0x66, 0x04, 
    0xC4, 0x8A, 0x7C, 0x77, 0x50, 0x9C, 0xC8, 0x77, 0x57, 0xC0, 0x67, 0xC5, 0x8A, 0x7C, 0xC6, 0xC1, 
    0x46, 0x2C, 0x11, 0x5C, 0x9C, 0xC8, 0x55, 0x33, 0x22, 0x51, 0xC4, 0xC8, 0x36, 0x23, 0x12, 0x6C, 
    0xC5, 0x23, 0x01, 0x11, 0x5C, 0xC5, 0x23, 0x11, 0x5C, 0xC5, 0xC3, 0x56, 0xC5, 0x23, 0x6C, 0xC5, 
    0x22, 0x5C, 0xC4, 0xC9, 0x57, 0xC5, 0x11, 0x45, 0x8C, 0x6C, 0x2C, 0x51, 0xAC, 0xC8, 0x57, 0x14, 
    0xC0, 0xC5, 0x89, 0x6C, 0xC4, 0x11, 0x4C, 0xAC, 0xC8, 0x57, 0x15, 0x50, 0xAC, 0x56, 0x1C, 0x50, 
    0x99, 0x7C, 0x56, 0x01, 0xA5, 0x89, 0x6C, 0x1C, 0x95, 0x79, 0x56, 0x14, 0x50, 0x9A, 0xC9, 0xC6, 
    0x50, 0x99, 0x67, 0x45, 0x01, 0xA5, 0x89, 0x6C, 0x05, 0x95, 0xC9, 0x67, 0x15, 0x50, 0x9A, 0x6C, 
    0x45, 0x5C, 0x7A, 0x56, 0x01, 0xC5, 0x89, 0x7C, 0xA4, 0x6C, 0x55, 0x8C, 0x6C, 0x15, 0x50, 0xC4, 
    0xC8, 0x57, 0x99, 0x6C, 0x45, 0x9C, 0x69, 0xC4, 0x01, 0x7C, 0x56, 0x89, 0x5C, 0x15, 0x50, 0x99, 
    0x5C, 0xC5, 0x02, 0x6C, 0xD4, 0x66, 0x94, 0x68, 0x01, 0xC4, 0x99, 0x26, 0xC2, 0xC4, 0x99, 0x6C, 
    0x55, 0x89, 0x16, 0x40, 0x6A, 0x2C, 0x11, 0x4C, 0x9C, 0x6C, 0x46, 0x89, 0x16, 0x40, 0x7A, 0xC6, 
    0x68, 0x56, 0x89, 0x16, 0x40, 0xCA, 0x77, 0x96, 0xC8, 0x55, 0x01, 0xA4, 0x99, 0x7C, 0x47, 0x99, 
    0x55, 0x01, 0xC4, 0x9B, 0xC8, 0x57, 0xC4, 0x95, 0x59, 0x15, 0x50, 0xCB, 0x67, 0x04, 0x95, 0xC9, 
    0x45, 0x01, 0x4C, 0xAC, 0x99, 0x7C, 0x56, 0xC4, 0x50, 0x9C, 0xC9, 0x15, 0x51, 0xAC, 0xCA, 0x67, 
    0x1C, 0x45, 0x9C, 0x5C, 0x14, 0xC1, 0xC5, 0xAA, 0x7C, 0x45, 0x1C, 0xC0, 0x56, 0xC4, 0xC2, 0xC5, 
    0x99, 0x7C, 0x56, 0x2C, 0x46, 0x2C, 0x01, 0x7C, 0x66, 0xC5, 0x23, 0x02, 0x6C, 0x3C, 0x22, 0x00, 
    0x12, 0x6C, 0x55, 0x3C, 0x23, 0xC2, 0x77, 0x56, 0xD5, 0x22, 0x5C, 0xC4, 0x9A, 0xC8, 0x77, 0x2C, 
    0xC1, 0xC5, 0x9A, 0xC8, 0x77, 0x45, 0x2C, 0x5C, 0xAC, 0xC9, 0x77, 0x46, 0x1C, 0x51, 0xAC, 0x7C, 
    0x67, 0xC6, 0xC1, 0xC4, 0x9A, 0xC9, 0x77, 0x56, 0x14, 0xA5, 0x8A, 0x6C, 0x9C, 0xC8, 0x67, 0xD6, 
    0xC4, 0x9A, 0xC9, 0xC6, 0x89, 0x7C, 0x57, 0x9A, 0xC8, 0x46, 0x9C, 0x79, 0x57, 0xA4, 0x69, 0x45, 
    0x9A, 0x7C, 0xA7, 0x59, 0x42, 0x9A, 0x45, 0x2C, 0x11, 0x4C, 0x9C, 0x6C, 0x45, 0x9A, 0x25, 0xA4, 
    0x59, 0x24, 0x02, 0xC4, 0x89, 0x4C, 0x6C, 0x9A, 0xC5, 0x11, 0xA4, 0x59, 0xC4, 0x12, 0xC1, 0xC4, 
    0x8A, 0xA6, 0x59, 0xC4, 0x01, 0xC4, 0x8A, 0x57, 0xC4, 0xCA, 0x55, 0x9A, 0x5C, 0xC4, 0x51, 0x8A, 
    0x77, 0xA4, 0x99, 0x5C, 0xC1, 0xA4, 0x79, 0xA7, 0x5A, 0x01, 0xC4, 0x9A, 0x67, 0x55, 0x4D, 0xAC, 
    0xC9, 0x45, 0x01, 0xB5, 0x99, 0x6C, 0x46, 0x51, 0xCA, 0x16, 0xC0, 0xC4, 0xAA, 0xC9, 0x47, 0x1C, 
    0x4C, 0xAC, 0xC8, 0x45, 0x11, 0xC5, 0x7A, 0x56, 0x1C, 0x51, 0xAC, 0xC8, 0x15, 0xC1, 0x45, 0x9C, 
    0xC8, 0x67, 0x2C, 0x5C, 0xC4, 0x5A, 0xC2, 0x45, 0xAC, 0xC8, 0xC7, 0x12, 0x6C, 0x55, 0x2C, 0xC0, 
    0x56, 0x8C, 0x6C, 0xD6, 0x22, 0xC0, 0x46, 0x2C, 0x01, 0x6C, 0xC6, 0x33, 0x13, 0xC1, 0x45, 0x3C, 
    0x11, 0xC1, 0x46, 0x3C, 0x33, 0x6C, 0x56, 0x3C, 0x23, 0x11, 0x45, 0x9C, 0xC8, 0x46, 0x33, 0x12, 
    0x51, 0xAC, 0x89, 0x5C, 0x33, 0x12, 0x51, 0x9A, 0x58, 0x35, 0x23, 0x11, 0xA5, 0xC9, 0xC5, 0x33, 
    0x11, 0x0E, 0xA5, 0x59, 0x3C, 0x13, 0xC0, 0x46, 0x5C, 0x9A, 0x35, 0xC3, 0xA7, 0x59, 0x23, 0x11, 
    0x7C, 0x55, 0x9A, 0x35, 0xC2, 0x67, 0x45, 0x9A, 0x35, 0x7C, 0xA7, 0x59, 0x12, 0xC1, 0x77, 0x55, 
    0x9A, 0xC5, 0x01, 0x7C, 0x67, 0x55, 0x9A, 0x77, 0x57, 0xA4, 0xC9, 0x46, 0x8C, 0xC4, 0x77, 0xC5, 
    0xA5, 0x89, 0xC4, 0xCB, 0x67, 0xC4, 0x01, 0xB5, 0x9A, 0x7C, 0xC6, 0x12, 0xB5, 0x99, 0x7C, 0x45, 
    0x2C, 0x12, 0xB5, 0xC9, 0x47, 0x3C, 0x01, 0xB5, 0x69, 0x46, 0x3C, 0x12, 0xB5, 0x69, 0xC5, 0x23, 
    0x02, 0xC5, 0xCB, 0x45, 0x3C, 0x13, 0x45, 0xAA, 0x6C, 0x3C, 0x13, 0x50, 0xC4, 0x89, 0x6C, 0x55, 
    0x3C, 0x23, 0x7C, 0x3C, 0x23, 0x11, 0x6C, 0xC4, 0x33, 0x03, 0x22, 0xC0, 0x55, 0x3C, 0x23, 0x12, 
    0x6C, 0x46, 0x3C, 0x23, 0x01, 0x6C, 0xC4, 0xC9, 0x56, 0x2C, 0x7C, 0x2C, 0x11, 0x5C, 0xC4, 0x9A, 
    0xC9, 0x46, 0x0C, 0x7C, 0x55, 0x2C, 0x51, 0xAC, 0xCA, 0x77, 0xC5, 0xC2, 0xC4, 0xAA, 0x7C, 0x57, 
    0xC5, 0x11, 0xB5, 0xC9, 0x77, 0xC4, 0xC1, 0xC4, 0x9B, 0xC8, 0x77, 0x14, 0xB5, 0xC8, 0x77, 0x55, 
    0x4D, 0xAC, 0x99, 0x7C, 0x67, 0xC6, 0xA4, 0xC9, 0x66, 0xC4, 0x77, 0x45, 0x9A, 0x66, 0xC4, 0xC8, 
    0x57, 0xC5, 0x89, 0x6C, 0xA4, 0x59, 0x2C, 0x50, 0x89, 0x6C, 0xC4, 0x02, 0x5C, 0x89, 0x6C, 0xA5, 
    0x69, 0x05, 0x4C, 0x9C, 0xC9, 0xC6, 0x02, 0x4C, 0x9C, 0x68, 0x45, 0x9A, 0x6C, 0xC6, 0x67, 0x94, 
    0x6C, 0x45, 0xCB, 0x67, 0x46, 0x6D, 0x55, 0x8B, 0x7C, 0x67, 0x45, 0x9B, 0x7C, 0x57, 0xC5, 0xB5, 
    0x7C, 0x67, 0x04, 0x4C, 0xAC, 0x9A, 0x77, 0x46, 0x1C, 0x45, 0xBC, 0x7C, 0x47, 0x1C, 0xC0, 0x45, 
    0xBC, 0x7C, 0x66, 0xC5, 0xC2, 0xC6, 0x9A, 0x6C, 0xC5, 0xC0, 0x57, 0xC5, 0x12, 0xC0, 0x56, 0xD5, 
    0x46, 0x2C, 0x7C, 0x3C, 0x6C, 0xC6, 0x33, 0x03, 0x6C, 0x3C, 0x23, 0x00, 0x12, 0x6C, 0x55, 0x3C, 
    0x11, 0x5C, 0xC5, 0xC3, 0x67, 0xC4, 0x12, 0x61, 0xC4, 0x22, 0xC0, 0x45, 0xAC, 0xC9, 0x66, 0x2C, 
    0xC0, 0xC4, 0xC9, 0xC5, 0x12, 0xC1, 0xC5, 0xAA, 0x6C, 0xC6, 0x52, 0x99, 0x5C, 0xC4, 0x02, 0x5C, 
    0xAC, 0x89, 0x7C, 0xC4, 0x11, 0xC4, 0x89, 0x56, 0x1C, 0x51, 0xAC, 0x99, 0x57, 0xC4, 0x01, 0x94, 
    0x69, 0x45, 0x01, 0x4C, 0xBC, 0x89, 0x6C, 0x16, 0x40, 0x9A, 0x58, 0xC5, 0x51, 0xAB, 0x6C, 0x55, 
    0x1C, 0xA4, 0x4C, 0x6C, 0xC0, 0xC4, 0x8A, 0x5C, 0xC4, 0xC8, 0x57, 0x14, 0xC4, 0x89, 0x6C, 0x45, 
    0x5C, 0x9A, 0x67, 0x16, 0xC5, 0xC8, 0x66, 0xA5, 0x79, 0xC4, 0x56, 0x14, 0x7C, 0x45, 0x8A, 0x5C, 
    0x22, 0xC4, 0xC8, 0x56, 0x01, 0x7C, 0xA5, 0x58, 0x2C, 0x42, 0x89, 0x6C, 0x24, 0x70, 0x8A, 0x45, 
    0x2C, 0x11, 0x94, 0x69, 0x24, 0x70, 0x8A, 0x7C, 0x9C, 0x7C, 0x66, 0xA5, 0x89, 0x7C, 0x77, 0xB4, 
    0x99, 0x7C, 0x67, 0xAB, 0x77, 0xD5, 0xC4, 0x9B, 0x79, 0x57, 0x51, 0xBC, 0x99, 0x7C, 0x66, 0xC5, 
    0xC1, 0xC5, 0x9B, 0xC8, 0x67, 0x46, 0x1C, 0xC1, 0x45, 0xAC, 0x9A, 0x77, 0x2C, 0xC0, 0x55, 0xAC, 
    0x99, 0x7C, 0x66, 0xC5, 0x12, 0xC1, 0x56, 0xC4, 0xC8, 0x67, 0x56, 0x3C, 0x6C, 0x56, 0x3C, 0x33, 
    0xC1, 0x45, 0x3C, 0x23, 0x03, 0x5C, 0xC4, 0x22, 0xC0, 0x45, 0x3C, 0xC3, 0x56, 0xC4, 0x12, 0x6C, 
    0xC5, 0x23, 0x62, 0x26, 0x51, 0x9C, 0x5C, 0x35, 0x12, 0x51, 0x6D, 0xC4, 0xC2, 0xC4, 0x99, 0x5C, 
    0xC4, 0x23, 0xC1, 0xC4, 0xC9, 0x46, 0x52, 0x8A, 0x5C, 0x34, 0x12, 0x95, 0x69, 0x24, 0xA5, 0xC8, 
    0x45, 0x23, 0x41, 0x9C, 0x69, 0x24, 0xA5, 0x5C, 0x35, 0x12, 0xC5, 0xC9, 0xC6, 0x52, 0x9C, 0x6C, 
    0x34, 0x12, 0x5C, 0x6D, 0x24, 0xC0, 0xD5, 0x46, 0x3C, 0x12, 0x60, 0x55, 0x2C, 0x61, 0x36, 0x22, 
    0x6C, 0x2C, 0x11, 0x6C, 0x45, 0x3C, 0x33, 0xC1, 0x55, 0x2C, 0x12
};

#endif

