/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : eye.h
    Date                : 30.03.2004
    Font size in bytes  : 0x00DE, 222
    Font width          : 55
    Font height         : 28
    Font first char     : 0x20
    Font last char      : 0x20
    Font bits per pixel : 2
    Font is compressed  : true

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef eye_H
#define eye_H

#define eye_WIDTH 55
#define eye_HEIGHT 28

static uint8_t __attribute__ ((progmem)) eye[] = {
    0x00, 0xDE, 0x37, 0x1C, 0x82, 0x20, 0x20,
    0x36, 
    0x01, 0x02, 0x04, 0x0A, 
    0xD1, 
    0x13, 0x50, 0x33, 0x02, 0x36, 0x13, 0x66, 0x23, 0x02, 0x37, 0x12, 0x70, 0x35, 0x02, 0x56, 0x69, 
    0x35, 0x62, 0xA4, 0x46, 0x13, 0x60, 0xA4, 0x69, 0x34, 0x60, 0xA4, 0x6A, 0x24, 0x02, 0x46, 0x6B, 
    0x22, 0x60, 0x9B, 0x26, 0x01, 0x46, 0x9B, 0x46, 0x12, 0xB6, 0x6A, 0x02, 0xB6, 0x9A, 0x26, 0xA6, 
    0x56, 0xA4, 0x68, 0x62, 0x89, 0x97, 0x68, 0x01, 0xA6, 0x57, 0x69, 0x61, 0x8B, 0x56, 0x68, 0x61, 
    0x9B, 0x68, 0x46, 0x51, 0xA4, 0xEA, 0x9C, 0x58, 0x84, 0x45, 0x51, 0xA4, 0xEA, 0x9D, 0x68, 0x05, 
    0xA6, 0xEA, 0xCD, 0x79, 0xA5, 0xEA, 0xCD, 0x79, 0xA5, 0x89, 0xDE, 0x9C, 0x47, 0xAA, 0xE8, 0xCD, 
    0x79, 0xD9, 0xAC, 0xDE, 0x9C, 0x97, 0xCE, 0xE9, 0xCD, 0x79, 0xE9, 0xCD, 0xE8, 0x9D, 0x97, 0xEF, 
    0x79, 0xF9, 0x9E, 0x47, 0xF9, 0x9D, 0x57, 0xF9, 0x9D, 0x57, 0x89, 0x9F, 0x68, 0x05, 0x56, 0x89, 
    0xEE, 0x89, 0x56, 0x51, 0x84, 0x45, 0x89, 0xCE, 0x5A, 0x84, 0x45, 0x61, 0x58, 0xB4, 0x45, 0x68, 
    0x61, 0x68, 0xA4, 0x69, 0x84, 0x16, 0x96, 0x67, 0x69, 0x01, 0x96, 0x78, 0x5A, 0x24, 0xA6, 0x68, 
    0xA5, 0x68, 0x62, 0xAB, 0x69, 0x02, 0xB6, 0x6A, 0x12, 0x46, 0x9B, 0x68, 0x12, 0x60, 0x9B, 0x26, 
    0x62, 0xB4, 0x46, 0x22, 0x60, 0xA4, 0x6A, 0x34, 0x60, 0xA4, 0x69, 0x34, 0x01, 0x46, 0x6A, 0x34, 
    0x62, 0x95, 0x56, 0x23, 0x70, 0x35, 0x12, 0x70, 0x23, 0x02, 0x66, 0x33, 0x61, 0x33, 0x02, 0x35, 
    0x01
};

#endif

