/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : f13x16.h
    Date                : 30.03.2004
    Font size in bytes  : 0x05EE, 1518
    Font width          : 13
    Font height         : 16
    Font first char     : 0x20
    Font last char      : 0x7E
    Font bits per pixel : 1
    Font is compressed  : false

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef f13x16_H
#define f13x16_H

#define f13x16_WIDTH 13
#define f13x16_HEIGHT 16

static uint8_t __attribute__ ((progmem)) f13x16[] = {
    0x05, 0xEE, 0x0D, 0x10, 0x01, 0x20, 0x7E,
    0x04, 0x02, 0x05, 0x09, 0x08, 0x0B, 0x0B, 0x02, 0x04, 0x04, 0x06, 0x08, 0x03, 0x06, 0x02, 0x05, 
    0x08, 0x04, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x02, 0x03, 0x08, 0x08, 0x08, 0x08, 
    0x0C, 0x0C, 0x09, 0x0B, 0x0A, 0x09, 0x09, 0x0B, 0x09, 0x02, 0x07, 0x09, 0x08, 0x0A, 0x08, 0x0B, 
    0x09, 0x0B, 0x0A, 0x0A, 0x0A, 0x09, 0x0C, 0x0C, 0x0C, 0x0C, 0x0B, 0x03, 0x05, 0x03, 0x06, 0x0A, 
    0x04, 0x09, 0x08, 0x08, 0x08, 0x08, 0x06, 0x08, 0x08, 0x02, 0x03, 0x08, 0x02, 0x0C, 0x08, 0x08, 
    0x08, 0x08, 0x05, 0x07, 0x06, 0x08, 0x08, 0x0C, 0x08, 0x08, 0x07, 0x04, 0x02, 0x04, 0x08, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x13, 0xFE, 0x13, 0x1E, 0x00, 0x1E, 0x00, 
    0x00, 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x00, 0x02, 0x10, 0x1E, 0xF0, 0x1F, 0xFE, 0x03, 0x1E, 0x1E, 
    0xF0, 0x1F, 0xFE, 0x03, 0x1E, 0x02, 0x10, 0x00, 0x18, 0x04, 0x3C, 0x0C, 0x66, 0x18, 0xFF, 0x3F, 
    0xFF, 0x3F, 0xC6, 0x18, 0x8C, 0x0F, 0x08, 0x07, 0x1C, 0x08, 0x3E, 0x0C, 0x22, 0x06, 0x22, 0x03, 
    0xBE, 0x01, 0xDC, 0x0E, 0x60, 0x1F, 0x30, 0x11, 0x18, 0x11, 0x0C, 0x1F, 0x04, 0x0E, 0x00, 0x07, 
    0x9C, 0x0F, 0xFE, 0x18, 0x62, 0x10, 0xFE, 0x10, 0x9C, 0x11, 0x00, 0x1B, 0x00, 0x0E, 0x00, 0x0F, 
    0x00, 0x1B, 0x00, 0x10, 0x1E, 0x00, 0x1E, 0x00, 0xF0, 0x0F, 0xFE, 0x7F, 0x0F, 0xF0, 0x01, 0x80, 
    0x01, 0x80, 0x0F, 0xF0, 0xFE, 0x7F, 0xF0, 0x0F, 0x12, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0F, 0x00, 
    0x1E, 0x00, 0x12, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0xF0, 0x07, 0xF0, 0x07, 0x80, 0x00, 
    0x80, 0x00, 0x80, 0x00, 0x00, 0x20, 0x00, 0x30, 0x00, 0x10, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 
    0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x3E, 0xE0, 0x1F, 
    0xFE, 0x01, 0x1E, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x02, 0x10, 0x02, 0x10, 0x0E, 0x1C, 
    0xFC, 0x0F, 0xF0, 0x03, 0x04, 0x00, 0x04, 0x00, 0xFE, 0x1F, 0xFE, 0x1F, 0x18, 0x18, 0x1C, 0x1C, 
    0x06, 0x16, 0x02, 0x13, 0x82, 0x11, 0xC6, 0x10, 0x7C, 0x10, 0x38, 0x10, 0x18, 0x06, 0x1C, 0x0E, 
    0x46, 0x18, 0x42, 0x10, 0x42, 0x10, 0xE6, 0x18, 0xBC, 0x0F, 0x18, 0x07, 0x00, 0x03, 0x80, 0x03, 
    0xE0, 0x02, 0x70, 0x02, 0x1C, 0x02, 0xFE, 0x1F, 0xFE, 0x1F, 0x00, 0x02, 0xFE, 0x06, 0xFE, 0x0E, 
    0x62, 0x18, 0x22, 0x10, 0x22, 0x10, 0x62, 0x18, 0xC2, 0x0F, 0x82, 0x07, 0xF8, 0x07, 0xFC, 0x0F, 
    0x66, 0x18, 0x22, 0x10, 0x22, 0x10, 0x66, 0x18, 0xCC, 0x0F, 0x88, 0x07, 0x02, 0x00, 0x02, 0x00, 
    0x02, 0x00, 0x02, 0x1E, 0xC2, 0x1F, 0xF2, 0x01, 0x3E, 0x00, 0x0E, 0x00, 0x18, 0x07, 0xBC, 0x0F, 
    0xE6, 0x18, 0x42, 0x10, 0x42, 0x10, 0xE6, 0x18, 0xBC, 0x0F, 0x18, 0x07, 0x78, 0x04, 0xFC, 0x0C, 
    0x86, 0x19, 0x02, 0x11, 0x02, 0x11, 0x86, 0x19, 0xFC, 0x0F, 0xF8, 0x07, 0x10, 0x10, 0x10, 0x10, 
    0x00, 0x20, 0x10, 0x30, 0x10, 0x10, 0x80, 0x00, 0xC0, 0x01, 0x40, 0x01, 0x60, 0x03, 0x20, 0x02, 
    0x30, 0x06, 0x10, 0x04, 0x10, 0x04, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 
    0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x10, 0x04, 0x10, 0x04, 0x30, 0x06, 0x20, 0x02, 0x60, 0x03, 
    0x40, 0x01, 0xC0, 0x01, 0x80, 0x00, 0x18, 0x00, 0x1C, 0x00, 0x06, 0x00, 0x02, 0x13, 0x82, 0x13, 
    0xC6, 0x00, 0x7C, 0x00, 0x38, 0x00, 0xF0, 0x07, 0xF8, 0x0F, 0x0C, 0x18, 0xE6, 0x19, 0x32, 0x12, 
    0x12, 0x13, 0xF2, 0x11, 0xE2, 0x13, 0x06, 0x12, 0x0C, 0x03, 0xF8, 0x01, 0xF0, 0x00, 0x00, 0x18, 
    0x00, 0x1E, 0x80, 0x07, 0xE0, 0x03, 0x78, 0x02, 0x1E, 0x02, 0x1E, 0x02, 0x78, 0x02, 0xE0, 0x03, 
    0x80, 0x07, 0x00, 0x1E, 0x00, 0x18, 0xFE, 0x1F, 0xFE, 0x1F, 0x42, 0x10, 0x42, 0x10, 0x42, 0x10, 
    0x42, 0x10, 0xE6, 0x18, 0xBC, 0x0F, 0x18, 0x07, 0xF0, 0x03, 0xFC, 0x0F, 0x0C, 0x0C, 0x06, 0x18, 
    0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x06, 0x18, 0x0C, 0x0C, 0x1C, 0x0E, 0x10, 0x02, 0xFE, 0x1F, 
    0xFE, 0x1F, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x06, 0x18, 0x0C, 0x0C, 0xFC, 0x0F, 
    0xF0, 0x03, 0xFE, 0x1F, 0xFE, 0x1F, 0x42, 0x10, 0x42, 0x10, 0x42, 0x10, 0x42, 0x10, 0x42, 0x10, 
    0x42, 0x10, 0x02, 0x10, 0xFE, 0x1F, 0xFE, 0x1F, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 
    0x42, 0x00, 0x42, 0x00, 0x02, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0C, 0x0C, 0x06, 0x18, 0x02, 0x10, 
    0x82, 0x10, 0x82, 0x10, 0x86, 0x18, 0x8C, 0x0C, 0x9C, 0x1F, 0x90, 0x1F, 0xFE, 0x1F, 0xFE, 0x1F, 
    0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x1F, 
    0xFE, 0x1F, 0x00, 0x0E, 0x00, 0x1E, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0xFE, 0x1F, 0xFE, 0x0F, 
    0xFE, 0x1F, 0xFE, 0x1F, 0xE0, 0x00, 0xB0, 0x01, 0x18, 0x03, 0x0C, 0x06, 0x06, 0x0C, 0x02, 0x18, 
    0x00, 0x10, 0xFE, 0x1F, 0xFE, 0x1F, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 
    0x00, 0x10, 0xFE, 0x1F, 0xFE, 0x1F, 0x78, 0x00, 0xE0, 0x01, 0x80, 0x07, 0x80, 0x07, 0xE0, 0x01, 
    0x78, 0x00, 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x1F, 0x3C, 0x00, 0xF0, 0x00, 0xC0, 0x03, 
    0x00, 0x0F, 0xFE, 0x1F, 0xFE, 0x1F, 0xF0, 0x03, 0xFC, 0x0F, 0x0C, 0x0C, 0x06, 0x18, 0x02, 0x10, 
    0x02, 0x10, 0x02, 0x10, 0x06, 0x18, 0x0C, 0x0C, 0xFC, 0x0F, 0xF0, 0x03, 0xFE, 0x1F, 0xFE, 0x1F, 
    0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0xC6, 0x00, 0x7C, 0x00, 0x38, 0x00, 0xF0, 0x03, 
    0xFC, 0x0F, 0x0C, 0x0C, 0x06, 0x18, 0x02, 0x10, 0x02, 0x12, 0x02, 0x16, 0x06, 0x1C, 0x0C, 0x1C, 
    0xFC, 0x3F, 0xF0, 0x23, 0xFE, 0x1F, 0xFE, 0x1F, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 
    0xC6, 0x01, 0x7C, 0x0F, 0x38, 0x1E, 0x00, 0x10, 0x18, 0x04, 0x3C, 0x0C, 0x66, 0x18, 0x42, 0x10, 
    0x42, 0x10, 0x42, 0x10, 0x42, 0x10, 0xC6, 0x18, 0x8C, 0x0F, 0x08, 0x07, 0x02, 0x00, 0x02, 0x00, 
    0x02, 0x00, 0x02, 0x00, 0xFE, 0x1F, 0xFE, 0x1F, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 
    0xFE, 0x07, 0xFE, 0x0F, 0x00, 0x18, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x18, 0xFE, 0x0F, 
    0xFE, 0x07, 0x06, 0x00, 0x1E, 0x00, 0x78, 0x00, 0xE0, 0x01, 0x80, 0x07, 0x00, 0x1E, 0x00, 0x1E, 
    0x80, 0x07, 0xE0, 0x01, 0x78, 0x00, 0x1E, 0x00, 0x06, 0x00, 0xFE, 0x00, 0xFE, 0x03, 0x00, 0x1F, 
    0x00, 0x1F, 0xE0, 0x03, 0xFC, 0x00, 0xFC, 0x00, 0xE0, 0x03, 0x00, 0x1F, 0x00, 0x1F, 0xFE, 0x03, 
    0xFE, 0x00, 0x02, 0x10, 0x06, 0x18, 0x0C, 0x0C, 0x18, 0x06, 0x30, 0x03, 0xE0, 0x01, 0xE0, 0x01, 
    0x30, 0x03, 0x18, 0x06, 0x0C, 0x0C, 0x06, 0x18, 0x02, 0x10, 0x02, 0x00, 0x06, 0x00, 0x0C, 0x00, 
    0x18, 0x00, 0x30, 0x00, 0xE0, 0x1F, 0xE0, 0x1F, 0x30, 0x00, 0x18, 0x00, 0x0C, 0x00, 0x06, 0x00, 
    0x02, 0x00, 0x00, 0x18, 0x02, 0x1C, 0x02, 0x16, 0x02, 0x13, 0x82, 0x11, 0xC2, 0x10, 0x62, 0x10, 
    0x32, 0x10, 0x1A, 0x10, 0x0E, 0x10, 0x06, 0x00, 0xFE, 0xFF, 0xFE, 0xFF, 0x02, 0x80, 0x1E, 0x00, 
    0xFE, 0x01, 0xE0, 0x1F, 0x00, 0x3E, 0x00, 0x20, 0x02, 0x80, 0xFE, 0xFF, 0xFE, 0xFF, 0x04, 0x00, 
    0x06, 0x00, 0x03, 0x00, 0x03, 0x00, 0x06, 0x00, 0x04, 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 
    0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x01, 0x00, 
    0x03, 0x00, 0x06, 0x00, 0x04, 0x00, 0x20, 0x0E, 0x30, 0x1F, 0x10, 0x11, 0x10, 0x11, 0x10, 0x11, 
    0x10, 0x11, 0xF0, 0x1F, 0xE0, 0x1F, 0x00, 0x10, 0xFE, 0x1F, 0xFE, 0x1F, 0x30, 0x18, 0x10, 0x10, 
    0x10, 0x10, 0x30, 0x18, 0xE0, 0x0F, 0xC0, 0x07, 0xC0, 0x07, 0xE0, 0x0F, 0x30, 0x18, 0x10, 0x10, 
    0x10, 0x10, 0x30, 0x18, 0x60, 0x0C, 0x40, 0x04, 0xC0, 0x07, 0xE0, 0x0F, 0x30, 0x18, 0x10, 0x10, 
    0x10, 0x10, 0x30, 0x18, 0xFE, 0x1F, 0xFE, 0x1F, 0xC0, 0x07, 0xE0, 0x0F, 0x30, 0x19, 0x10, 0x11, 
    0x10, 0x11, 0x30, 0x19, 0xE0, 0x0D, 0xC0, 0x05, 0x10, 0x00, 0x10, 0x00, 0xFC, 0x1F, 0xFE, 0x1F, 
    0x12, 0x00, 0x12, 0x00, 0xC0, 0x07, 0xE0, 0x8F, 0x30, 0x98, 0x10, 0x90, 0x10, 0x90, 0x30, 0xD8, 
    0xF0, 0xFF, 0xF0, 0x7F, 0xFE, 0x1F, 0xFE, 0x1F, 0x30, 0x00, 0x10, 0x00, 0x10, 0x00, 0x30, 0x00, 
    0xE0, 0x1F, 0xC0, 0x1F, 0xF2, 0x1F, 0xF2, 0x1F, 0x00, 0x80, 0xF2, 0xFF, 0xF2, 0x7F, 0xFE, 0x1F, 
    0xFE, 0x1F, 0x80, 0x01, 0xC0, 0x03, 0x60, 0x06, 0x30, 0x0C, 0x10, 0x18, 0x00, 0x10, 0xFE, 0x1F, 
    0xFE, 0x1F, 0xF0, 0x1F, 0xF0, 0x1F, 0x30, 0x00, 0x10, 0x00, 0x30, 0x00, 0xE0, 0x1F, 0xE0, 0x1F, 
    0x30, 0x00, 0x10, 0x00, 0x30, 0x00, 0xE0, 0x1F, 0xC0, 0x1F, 0xF0, 0x1F, 0xF0, 0x1F, 0x30, 0x00, 
    0x10, 0x00, 0x10, 0x00, 0x30, 0x00, 0xE0, 0x1F, 0xC0, 0x1F, 0xC0, 0x07, 0xE0, 0x0F, 0x30, 0x18, 
    0x10, 0x10, 0x10, 0x10, 0x30, 0x18, 0xE0, 0x0F, 0xC0, 0x07, 0xF0, 0xFF, 0xF0, 0xFF, 0x30, 0x18, 
    0x10, 0x10, 0x10, 0x10, 0x30, 0x18, 0xE0, 0x0F, 0xC0, 0x07, 0xC0, 0x07, 0xE0, 0x0F, 0x30, 0x18, 
    0x10, 0x10, 0x10, 0x10, 0x30, 0x18, 0xF0, 0xFF, 0xF0, 0xFF, 0xF0, 0x1F, 0xF0, 0x1F, 0x30, 0x00, 
    0x10, 0x00, 0x10, 0x00, 0xE0, 0x08, 0xF0, 0x19, 0x10, 0x11, 0x10, 0x11, 0x10, 0x11, 0x30, 0x1F, 
    0x20, 0x0E, 0x10, 0x00, 0x10, 0x00, 0xFE, 0x0F, 0xFE, 0x1F, 0x10, 0x10, 0x10, 0x00, 0xF0, 0x07, 
    0xF0, 0x0F, 0x00, 0x18, 0x00, 0x10, 0x00, 0x10, 0x00, 0x18, 0xF0, 0x1F, 0xF0, 0x1F, 0x30, 0x00, 
    0xF0, 0x00, 0xC0, 0x03, 0x00, 0x1F, 0x00, 0x1F, 0xC0, 0x03, 0xF0, 0x00, 0x30, 0x00, 0x30, 0x00, 
    0xF0, 0x00, 0xC0, 0x03, 0x00, 0x1F, 0x00, 0x1F, 0xE0, 0x03, 0xE0, 0x03, 0x00, 0x1F, 0x00, 0x1F, 
    0xC0, 0x03, 0xF0, 0x00, 0x30, 0x00, 0x10, 0x10, 0x70, 0x1C, 0xE0, 0x0E, 0x80, 0x03, 0x80, 0x03, 
    0xE0, 0x0E, 0x70, 0x1C, 0x10, 0x10, 0x30, 0x00, 0xF0, 0xC0, 0xC0, 0xF3, 0x00, 0x3F, 0x00, 0x0F, 
    0xC0, 0x03, 0xF0, 0x00, 0x30, 0x00, 0x10, 0x18, 0x10, 0x1C, 0x10, 0x17, 0x90, 0x13, 0xD0, 0x10, 
    0x70, 0x10, 0x30, 0x10, 0x00, 0x01, 0xFC, 0x7F, 0xFE, 0xFE, 0x02, 0x80, 0xFE, 0x3F, 0xFE, 0x3F, 
    0x02, 0x80, 0xFE, 0xFE, 0xFC, 0x7F, 0x00, 0x01, 0x06, 0x00, 0x07, 0x00, 0x01, 0x00, 0x03, 0x00, 
    0x06, 0x00, 0x04, 0x00, 0x07, 0x00, 0x03, 0x00
};

#endif

