/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : f8x8.h
    Date                : 30.03.2004
    Font size in bytes  : 0x0176, 374
    Font width          : 8
    Font height         : 8
    Font first char     : 0x20
    Font last char      : 0x7A
    Font bits per pixel : 1
    Font is compressed  : false

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef f8x8_H
#define f8x8_H

#define f8x8_WIDTH 8
#define f8x8_HEIGHT 8

static uint8_t __attribute__ ((progmem)) f8x8[] = {
    0x01, 0x76, 0x08, 0x08, 0x01, 0x20, 0x7A,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 
    0x04, 0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x04, 
    0x00, 0x06, 0x06, 0x06, 0x06, 0x05, 0x05, 0x06, 0x06, 0x01, 0x04, 0x05, 0x04, 0x07, 0x06, 0x06, 
    0x06, 0x06, 0x06, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x04, 0x04, 0x01, 0x01, 0x04, 0x01, 0x07, 0x04, 0x05, 
    0x04, 0x04, 0x02, 0x04, 0x02, 0x04, 0x04, 0x05, 0x03, 0x03, 0x03, 
    0x00, 0xC0, 0x40, 0x3E, 0x41, 0x41, 0x3E, 0x02, 0x7F, 0x62, 0x51, 0x49, 0x46, 0x22, 0x41, 0x49, 
    0x36, 0x18, 0x16, 0x7F, 0x10, 0x2F, 0x45, 0x45, 0x39, 0x3E, 0x49, 0x49, 0x32, 0x01, 0x71, 0x0D, 
    0x03, 0x36, 0x49, 0x49, 0x36, 0x26, 0x49, 0x49, 0x3E, 0x48, 0x02, 0x51, 0x09, 0x06, 0x60, 0x1C, 
    0x13, 0x13, 0x1C, 0x60, 0x7F, 0x49, 0x49, 0x49, 0x49, 0x36, 0x3E, 0x41, 0x41, 0x41, 0x41, 0x22, 
    0x7F, 0x41, 0x41, 0x41, 0x41, 0x3E, 0x7F, 0x49, 0x49, 0x49, 0x41, 0x7F, 0x09, 0x09, 0x09, 0x01, 
    0x3E, 0x41, 0x41, 0x49, 0x29, 0x7A, 0x7F, 0x08, 0x08, 0x08, 0x08, 0x7F, 0x7F, 0x30, 0x40, 0x40, 
    0x3F, 0x7F, 0x08, 0x14, 0x22, 0x41, 0x7F, 0x40, 0x40, 0x40, 0x7F, 0x03, 0x0C, 0x30, 0x0C, 0x03, 
    0x7F, 0x7F, 0x03, 0x0C, 0x30, 0x40, 0x7F, 0x3E, 0x41, 0x41, 0x41, 0x41, 0x3E, 0x7F, 0x09, 0x09, 
    0x09, 0x09, 0x06, 0x3E, 0x41, 0x41, 0x51, 0x61, 0xBE, 0x7F, 0x09, 0x09, 0x09, 0x09, 0x76, 0x26, 
    0x49, 0x49, 0x49, 0x32, 0x01, 0x01, 0x7F, 0x01, 0x01, 0x3F, 0x40, 0x40, 0x40, 0x3F, 0x03, 0x1C, 
    0x60, 0x1C, 0x03, 0x03, 0x1C, 0x60, 0x18, 0x60, 0x1C, 0x03, 0x63, 0x14, 0x08, 0x14, 0x63, 0x03, 
    0x04, 0x78, 0x04, 0x03, 0x61, 0x51, 0x49, 0x45, 0x43, 0x20, 0x54, 0x54, 0x78, 0x7F, 0x44, 0x44, 
    0x38, 0x38, 0x44, 0x44, 0x28, 0x38, 0x44, 0x44, 0x7F, 0x38, 0x54, 0x54, 0x18, 0x7E, 0x09, 0x98, 
    0xA4, 0xA4, 0x7C, 0x7F, 0x08, 0x04, 0x78, 0x7D, 0xFD, 0x7F, 0x18, 0x24, 0x40, 0x7F, 0x7C, 0x04, 
    0x04, 0x7C, 0x04, 0x04, 0x78, 0x7C, 0x04, 0x04, 0x78, 0x38, 0x44, 0x44, 0x44, 0x38, 0xFC, 0x24, 
    0x24, 0x18, 0x18, 0x24, 0x24, 0xFC, 0x7C, 0x04, 0x48, 0x54, 0x54, 0x24, 0x3E, 0x44, 0x3C, 0x40, 
    0x40, 0x7C, 0x1C, 0x60, 0x60, 0x1C, 0x1C, 0x60, 0x18, 0x60, 0x1C, 0x6C, 0x10, 0x6C, 0x9C, 0xA0, 
    0x7C, 0x64, 0x54, 0x4C
};

#endif

