/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : f9x14.h
    Date                : 30.03.2004
    Font size in bytes  : 0x05FE, 1534
    Font width          : 9
    Font height         : 14
    Font first char     : 0x20
    Font last char      : 0xFC
    Font bits per pixel : 1
    Font is compressed  : false

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef f9x14_H
#define f9x14_H

#define f9x14_WIDTH 9
#define f9x14_HEIGHT 14

static uint8_t __attribute__ ((progmem)) f9x14[] = {
    0x05, 0xFE, 0x09, 0x0E, 0x01, 0x20, 0xFC,
    0x04, 0x02, 0x05, 0x08, 0x07, 0x07, 0x07, 0x02, 0x04, 0x04, 0x05, 0x05, 0x02, 0x05, 0x02, 0x06, 
    0x07, 0x06, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x02, 0x02, 0x06, 0x06, 0x06, 0x05, 
    0x08, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x08, 0x08, 0x04, 0x06, 0x07, 0x07, 0x08, 0x08, 0x08, 
    0x07, 0x08, 0x08, 0x07, 0x08, 0x08, 0x07, 0x08, 0x07, 0x08, 0x06, 0x03, 0x06, 0x03, 0x08, 0x08, 
    0x03, 0x06, 0x06, 0x06, 0x06, 0x06, 0x05, 0x06, 0x06, 0x02, 0x04, 0x07, 0x02, 0x08, 0x06, 0x06, 
    0x06, 0x06, 0x05, 0x05, 0x05, 0x06, 0x06, 0x07, 0x06, 0x06, 0x05, 0x05, 0x02, 0x05, 0x08, 0x00, 
    0x08, 0x00, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x03, 0x03, 0x05, 0x05, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x06, 0x06, 0x06, 0x00, 0x07, 0x08, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 
    0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x00, 0x00, 0x00, 0x07, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x0D, 0x7E, 0xC3, 0x01, 0x70, 0x00, 0x00, 0x00, 
    0x07, 0xC0, 0x01, 0x00, 0x0C, 0x60, 0x0F, 0xF8, 0x80, 0x37, 0x80, 0x3D, 0xE0, 0x03, 0xDE, 0x00, 
    0x06, 0x80, 0x13, 0xF0, 0x09, 0x64, 0xC2, 0xFF, 0x43, 0x26, 0x90, 0x0F, 0xC8, 0xF1, 0xC0, 0x24, 
    0x3C, 0xCF, 0x03, 0x3C, 0xC0, 0xF3, 0x3C, 0x24, 0x03, 0x0F, 0xDC, 0x81, 0xFF, 0x20, 0x22, 0xF8, 
    0x09, 0xDC, 0x02, 0x60, 0x00, 0x34, 0x1C, 0x00, 0x07, 0x00, 0x7E, 0xE0, 0x7F, 0x1C, 0x38, 0x01, 
    0x48, 0x00, 0x72, 0xE0, 0xF8, 0x1F, 0xF8, 0x01, 0x12, 0x00, 0x03, 0xF0, 0x03, 0x30, 0x00, 0x12, 
    0x00, 0x02, 0x80, 0x00, 0xF8, 0x00, 0x08, 0x00, 0x02, 0x00, 0x3C, 0x00, 0x07, 0x08, 0x00, 0x02, 
    0x80, 0x00, 0x20, 0x00, 0x08, 0x00, 0x30, 0x00, 0x0C, 0x00, 0x0C, 0xE0, 0x03, 0x3E, 0xF0, 0x01, 
    0x1F, 0xC0, 0x00, 0xC0, 0x1F, 0xF8, 0x0F, 0x82, 0x82, 0x9C, 0xA0, 0x20, 0xF8, 0x0F, 0xFC, 0x01, 
    0x81, 0x40, 0x20, 0xF8, 0x0F, 0xFE, 0x03, 0x80, 0x00, 0x20, 0x10, 0x08, 0x06, 0x83, 0xE0, 0x20, 
    0x2C, 0x88, 0x09, 0x3E, 0x02, 0x87, 0x40, 0x10, 0x18, 0x0C, 0x22, 0x82, 0x88, 0x20, 0x22, 0xF8, 
    0x0F, 0xDC, 0x01, 0x30, 0x00, 0x0A, 0x60, 0x02, 0x84, 0x80, 0xFF, 0xE0, 0x3F, 0x00, 0x02, 0x00, 
    0x81, 0xC7, 0xE0, 0x21, 0x48, 0x08, 0x12, 0x82, 0xFC, 0x20, 0x1E, 0xE0, 0x07, 0xFC, 0x83, 0x85, 
    0x20, 0x21, 0x48, 0x08, 0xF2, 0x03, 0x78, 0x20, 0x00, 0x08, 0x08, 0x82, 0x83, 0x78, 0xA0, 0x07, 
    0x78, 0x00, 0x06, 0x00, 0x77, 0xE0, 0x3F, 0x88, 0x08, 0x22, 0x82, 0x88, 0xE0, 0x3F, 0x70, 0x07, 
    0x3C, 0x80, 0x9F, 0x20, 0x24, 0x08, 0x09, 0x42, 0x83, 0x7F, 0xC0, 0x0F, 0x60, 0x0C, 0x18, 0x03, 
    0xC6, 0x83, 0x71, 0x80, 0x01, 0x60, 0x00, 0x24, 0x00, 0x09, 0x20, 0x04, 0x08, 0x01, 0x24, 0x00, 
    0x09, 0x40, 0x02, 0x90, 0x00, 0x24, 0x00, 0x09, 0x20, 0x04, 0x08, 0x01, 0x24, 0x00, 0x09, 0x80, 
    0x01, 0x60, 0x00, 0x01, 0x20, 0x36, 0xC8, 0x0D, 0x1E, 0x00, 0x03, 0x00, 0x1F, 0x20, 0x08, 0xE4, 
    0x04, 0x45, 0x41, 0x51, 0x90, 0x13, 0x08, 0x01, 0x3C, 0x00, 0x38, 0xE0, 0x0F, 0xFE, 0x80, 0x21, 
    0xE0, 0x0F, 0xE0, 0x0F, 0x80, 0x83, 0xFF, 0xE0, 0x3F, 0x88, 0x08, 0x22, 0x82, 0x8F, 0xC0, 0x3F, 
    0x00, 0x07, 0xF8, 0x00, 0x7F, 0x60, 0x30, 0x08, 0x08, 0x02, 0x82, 0x80, 0x40, 0x10, 0xF8, 0x0F, 
    0xFE, 0x83, 0x80, 0x20, 0x20, 0x18, 0x0C, 0xFC, 0x01, 0x3E, 0xE0, 0x3F, 0xF8, 0x0F, 0x22, 0x82, 
    0x88, 0x20, 0x22, 0x08, 0x08, 0x02, 0x82, 0xFF, 0xE0, 0x3F, 0x88, 0x00, 0x22, 0x80, 0x08, 0x20, 
    0x00, 0x08, 0x00, 0xF8, 0x00, 0x7F, 0x60, 0x30, 0x08, 0x08, 0x42, 0x82, 0x90, 0x20, 0x3C, 0x10, 
    0x0F, 0xFE, 0x83, 0xFF, 0x00, 0x02, 0x80, 0x00, 0x20, 0x00, 0x08, 0xE0, 0x3F, 0xF8, 0x0F, 0x02, 
    0x82, 0xFF, 0xE0, 0x3F, 0x08, 0x08, 0x00, 0x82, 0x80, 0x20, 0x20, 0x08, 0x08, 0xFE, 0x83, 0x7F, 
    0xE0, 0x3F, 0xF8, 0x0F, 0x70, 0x00, 0x36, 0xC0, 0x18, 0x18, 0x0C, 0x02, 0x82, 0xFF, 0xE0, 0x3F, 
    0x00, 0x08, 0x00, 0x02, 0x80, 0x00, 0x20, 0x00, 0x08, 0xFE, 0x83, 0xFF, 0xC0, 0x03, 0xE0, 0x03, 
    0xF8, 0x00, 0x0F, 0xE0, 0x3F, 0xF8, 0x0F, 0xFE, 0x83, 0xFF, 0xC0, 0x01, 0xE0, 0x01, 0xF0, 0x00, 
    0x70, 0xE0, 0x3F, 0xF8, 0x0F, 0xF8, 0x00, 0x7F, 0x60, 0x30, 0x08, 0x08, 0x02, 0x82, 0xC1, 0xC0, 
    0x1F, 0xE0, 0x03, 0xFE, 0x83, 0xFF, 0x20, 0x04, 0x08, 0x01, 0x42, 0x80, 0x1F, 0xC0, 0x03, 0xE0, 
    0x03, 0xFC, 0x81, 0xC1, 0x20, 0x20, 0x08, 0x0E, 0x86, 0x07, 0xFF, 0x81, 0x4F, 0xF8, 0x0F, 0xFE, 
    0x83, 0x08, 0x20, 0x06, 0x88, 0x03, 0xBE, 0x01, 0xC7, 0x00, 0x20, 0x70, 0x04, 0x3E, 0x82, 0x8C, 
    0x20, 0x22, 0x88, 0x09, 0xE2, 0x03, 0x71, 0x20, 0x00, 0x08, 0x00, 0x02, 0x80, 0xFF, 0xE0, 0x3F, 
    0x08, 0x00, 0x02, 0x80, 0x00, 0xE0, 0x1F, 0xF8, 0x0F, 0x00, 0x02, 0x80, 0x00, 0x20, 0x00, 0x08, 
    0xFE, 0x83, 0x7F, 0xE0, 0x00, 0xF8, 0x01, 0xF0, 0x03, 0xE0, 0x00, 0x3F, 0xF8, 0x01, 0x0E, 0x80, 
    0xFF, 0xE0, 0x3F, 0x80, 0x03, 0x3E, 0x80, 0x0F, 0x00, 0x0E, 0xF8, 0x0F, 0xFE, 0x83, 0xC1, 0xE0, 
    0x38, 0xE0, 0x03, 0x70, 0x00, 0x3E, 0xE0, 0x38, 0x18, 0x0C, 0x06, 0x80, 0x03, 0x80, 0x01, 0xC0, 
    0x0F, 0xF0, 0x03, 0x06, 0xE0, 0x00, 0x18, 0x00, 0x02, 0x83, 0xF0, 0x20, 0x2F, 0xF8, 0x08, 0x0E, 
    0x82, 0x80, 0xF0, 0xFF, 0xFC, 0x3F, 0x01, 0xC8, 0x00, 0xF0, 0x01, 0xF0, 0x01, 0xE0, 0x03, 0xE0, 
    0x03, 0xC0, 0x04, 0x20, 0xFF, 0xCF, 0xFF, 0x03, 0x01, 0x60, 0x00, 0x0C, 0x80, 0x01, 0x60, 0x00, 
    0x30, 0x00, 0x18, 0x00, 0x04, 0x00, 0x80, 0x00, 0x20, 0x00, 0x08, 0x00, 0x02, 0x80, 0x00, 0x20, 
    0x00, 0x08, 0x00, 0x12, 0x00, 0x0C, 0x00, 0x02, 0x00, 0x70, 0x80, 0x3E, 0xA0, 0x08, 0x28, 0x02, 
    0xFE, 0x00, 0x3F, 0xFC, 0x0F, 0xFF, 0x03, 0x82, 0x80, 0x20, 0xE0, 0x0F, 0xF0, 0x01, 0x7C, 0x80, 
    0x3F, 0x20, 0x08, 0x08, 0x02, 0x82, 0x00, 0x11, 0xC0, 0x07, 0xF8, 0x03, 0x82, 0x80, 0x20, 0xFC, 
    0x0F, 0xFF, 0x03, 0x7C, 0x80, 0x3F, 0x20, 0x09, 0x48, 0x02, 0x9E, 0x00, 0x17, 0x20, 0x00, 0xFE, 
    0xC3, 0xFF, 0x90, 0x00, 0x24, 0x00, 0xF0, 0x01, 0xFE, 0x82, 0xA0, 0x20, 0x28, 0xF8, 0x0F, 0xFE, 
    0xF1, 0x3F, 0xFC, 0x0F, 0x08, 0x00, 0x02, 0x80, 0x3F, 0xC0, 0x0F, 0xFB, 0xC3, 0xFE, 0x00, 0x80, 
    0x20, 0x20, 0xFB, 0xCF, 0xFE, 0xF1, 0x3F, 0xFC, 0x0F, 0x60, 0x00, 0x3C, 0x80, 0x19, 0x20, 0x0C, 
    0x00, 0xC2, 0xFF, 0xF0, 0x3F, 0xE0, 0x0F, 0xF0, 0x03, 0x02, 0x80, 0x3F, 0xC0, 0x0F, 0x08, 0x00, 
    0xFE, 0x00, 0x3F, 0xE0, 0x0F, 0xF8, 0x03, 0x02, 0x80, 0x00, 0xE0, 0x0F, 0xF0, 0x03, 0x7C, 0x80, 
    0x3F, 0x20, 0x08, 0x08, 0x02, 0xFE, 0x00, 0x1F, 0xE0, 0x3F, 0xF8, 0x0F, 0x82, 0x80, 0x20, 0xE0, 
    0x0F, 0xF0, 0x01, 0x7C, 0x80, 0x3F, 0x20, 0x08, 0x08, 0x02, 0xFE, 0x83, 0xFF, 0xE0, 0x0F, 0xF8, 
    0x03, 0x04, 0x80, 0x01, 0x60, 0x00, 0x30, 0x02, 0x9E, 0x80, 0x24, 0x20, 0x0F, 0x88, 0x01, 0x02, 
    0xE0, 0x1F, 0xF8, 0x0F, 0x08, 0x02, 0x82, 0x80, 0x1F, 0xE0, 0x0F, 0x00, 0x02, 0x80, 0x80, 0x3F, 
    0xE0, 0x0F, 0x38, 0x00, 0x7E, 0x00, 0x3C, 0x00, 0x0F, 0xF8, 0x01, 0x0E, 0x80, 0x3F, 0xE0, 0x07, 
    0xC0, 0x00, 0x1E, 0x00, 0x0C, 0xE0, 0x07, 0xF8, 0x03, 0xC6, 0x80, 0x3B, 0x80, 0x03, 0xE0, 0x00, 
    0xEE, 0x80, 0x31, 0xE0, 0x00, 0xF8, 0x09, 0xF0, 0x03, 0x7C, 0xE0, 0x07, 0x38, 0x00, 0xC2, 0x80, 
    0x3C, 0xA0, 0x0B, 0x78, 0x02, 0x86, 0x00, 0x02, 0xF8, 0x1F, 0xDF, 0x4F, 0x00, 0x12, 0x80, 0xFC, 
    0x3F, 0xFF, 0x4F, 0x00, 0x12, 0x80, 0x7C, 0x3F, 0xFE, 0x07, 0x08, 0x00, 0x0E, 0x40, 0x00, 0x10, 
    0x00, 0x08, 0x00, 0x04, 0x00, 0x02, 0x80, 0x00, 0x1C, 0x00, 0x05, 0xE0, 0x03, 0xFC, 0x81, 0xD5, 
    0x20, 0x21, 0x08, 0x08, 0x04, 0x01, 0x00, 0x00, 0x70, 0x00, 0x0C, 0x00, 0x00, 0xC0, 0x01, 0x30, 
    0x00, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x08, 0x00, 0x03, 0x60, 0x00, 0x30, 0x00, 0x08, 0x00, 
    0x00, 0x60, 0x00, 0x38, 0x00, 0x00, 0x80, 0x03, 0x60, 0x00, 0x00, 0x00, 0x06, 0x80, 0x03, 0x00, 
    0x00, 0x18, 0x00, 0x0E, 0x80, 0x03, 0x60, 0x00, 0x00, 0x00, 0x0E, 0x80, 0x01, 0x00, 0x1E, 0xC0, 
    0x0F, 0xF0, 0x03, 0xFC, 0x00, 0x3F, 0x80, 0x07, 0x00, 0x00, 0x01, 0x20, 0x00, 0x10, 0x00, 0x02, 
    0x00, 0x01, 0x20, 0x00, 0xF0, 0xF9, 0x7C, 0x3E, 0x00, 0x80, 0x9D, 0xF0, 0x4F, 0x24, 0x12, 0x89, 
    0x44, 0x22, 0x91, 0x7F, 0xC8, 0x0D, 0x00, 0x00, 0x88, 0x00, 0x22, 0xE0, 0x0B, 0x20, 0x02, 0x88, 
    0x00, 0x00, 0x00, 0x00, 0x31, 0x40, 0x0E, 0xF0, 0x02, 0x98, 0x00, 0x00, 0x00, 0x00, 0x10, 0x02, 
    0x94, 0x00, 0x3F, 0x80, 0x06, 0x00, 0x00, 0xE0, 0x3F, 0xF8, 0x0F, 0x80, 0x00, 0x20, 0xE0, 0x0F, 
    0xF8, 0x03, 0x00, 0xC0, 0x01, 0xF8, 0x00, 0x3E, 0x80, 0x0F, 0xE0, 0xFF, 0x08, 0x00, 0xFE, 0x0F, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xC0, 0x0F, 0xF0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0xE0, 
    0x01, 0xFC, 0x00, 0x21, 0xC0, 0x0F, 0xE0, 0x01, 0x00, 0x00, 0x80, 0x33, 0xFE, 0xE0, 0x0F, 0x18, 
    0x02, 0xFE, 0x30, 0xFE, 0x00, 0x38, 0x00, 0x00, 0xF8, 0x00, 0x7F, 0x6C, 0x30, 0x08, 0xC8, 0x06, 
    0x03, 0x7F, 0x80, 0x0F, 0x00, 0x00, 0x88, 0x00, 0x14, 0x00, 0x02, 0x40, 0x01, 0x88, 0x00, 0x00, 
    0xE0, 0x1F, 0xF8, 0xCF, 0x00, 0x02, 0x80, 0x0C, 0x20, 0xF8, 0x0F, 0xFE, 0x01, 0x00, 0xE0, 0x3F, 
    0xFC, 0x0F, 0x01, 0x40, 0x84, 0xF0, 0x23, 0xB8, 0x0F, 0xC0, 0x01, 0x00, 0x00, 0x1C, 0xAC, 0x0F, 
    0x28, 0x02, 0x8A, 0xB0, 0x3F, 0xC0, 0x0F, 0x00, 0x00, 0x7C, 0xB0, 0x3F, 0x20, 0x08, 0x08, 0xC2, 
    0xFE, 0x00, 0x1F, 0x00, 0x00, 0x20, 0x00, 0x08, 0xC0, 0x1A, 0xB0, 0x06, 0x20, 0x00, 0x08, 0x00, 
    0x00, 0xC0, 0x17, 0xF8, 0x03, 0xA2, 0x80, 0x26, 0xE0, 0x0F, 0xF4, 0x01, 0x00, 0x80, 0x1F, 0xEC, 
    0x0F, 0x00, 0x02, 0x80, 0xB0, 0x3F, 0xE0, 0x0F, 0x00, 0x00
};

#endif

