/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : nums.h
    Date                : 30.03.2004
    Font size in bytes  : 0x0420, 1056
    Font width          : 26
    Font height         : 25
    Font first char     : 0x20
    Font last char      : 0x2A
    Font bits per pixel : 2
    Font is compressed  : true

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef nums_H
#define nums_H

#define nums_WIDTH 26
#define nums_HEIGHT 25

static uint8_t __attribute__ ((progmem)) nums[] = {
    0x04, 0x20, 0x1A, 0x19, 0x82, 0x20, 0x2A,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
    0x01, 0x02, 0x03, 0x07, 
    0x5C, 0x52, 0x5E, 0x60, 0x58, 0x60, 0x61, 0x5D, 0x5F, 0x61, 0x5C, 
    0x13, 0x37, 0x03, 0x67, 0x36, 0x02, 0x46, 0x6B, 0x34, 0x61, 0xAB, 0x68, 0x63, 0xAB, 0x6A, 0x12, 
    0xB6, 0x8B, 0x26, 0xB6, 0xAB, 0x16, 0xA5, 0xFA, 0xAA, 0x15, 0xA5, 0xEF, 0xAE, 0x05, 0xA5, 0xCE, 
    0xEB, 0xAC, 0x46, 0xE9, 0xAB, 0xE8, 0x69, 0x94, 0xBD, 0xAA, 0x9D, 0x46, 0xD9, 0xAB, 0xDA, 0x69, 
    0x94, 0xBD, 0xAA, 0x9D, 0x46, 0xE9, 0xAB, 0xE8, 0x69, 0xA4, 0xCE, 0xEB, 0xAC, 0x05, 0xA5, 0xEF, 
    0xAE, 0x15, 0xA5, 0xFA, 0xAA, 0x15, 0xB6, 0xAB, 0x26, 0xB6, 0x8B, 0x26, 0x61, 0xAB, 0x6A, 0x63, 
    0xAB, 0x68, 0x13, 0x46, 0x6B, 0x34, 0x02, 0x67, 0x36, 0x03, 0x37, 0x01, 0x13, 0x37, 0x03, 0x67, 
    0x36, 0x02, 0x46, 0x6B, 0x34, 0x61, 0xAB, 0x68, 0x63, 0xAB, 0x6A, 0x12, 0xB6, 0x8B, 0x26, 0xB6, 
    0xAB, 0x16, 0xB5, 0xAB, 0x59, 0x51, 0xBB, 0x9A, 0x05, 0xA5, 0xC8, 0xBB, 0x69, 0xA4, 0xC8, 0xBB, 
    0x69, 0xA4, 0xBD, 0x9B, 0x46, 0xFA, 0xCF, 0x6A, 0xA4, 0xFF, 0xAC, 0x46, 0xBB, 0x6B, 0xB4, 0xBB, 
    0x05, 0xB5, 0xAB, 0x59, 0x51, 0xBB, 0x9A, 0x15, 0xB6, 0xAB, 0x26, 0xB6, 0x8B, 0x26, 0x61, 0xAB, 
    0x6A, 0x63, 0xAB, 0x68, 0x13, 0x46, 0x6B, 0x34, 0x02, 0x67, 0x36, 0x03, 0x37, 0x01, 0x13, 0x37, 
    0x03, 0x67, 0x36, 0x02, 0x46, 0x6B, 0x34, 0x61, 0xAB, 0x68, 0x63, 0xAB, 0x6A, 0x12, 0xB6, 0x8B, 
    0x26, 0xB6, 0xAB, 0x16, 0xB5, 0xAB, 0x59, 0x51, 0xD9, 0xAB, 0x9E, 0x05, 0x95, 0xBD, 0xEA, 0xAC, 
    0x46, 0xD9, 0x9B, 0xDE, 0x6A, 0x94, 0xBD, 0xD8, 0xD9, 0x6A, 0x94, 0xBD, 0xAD, 0xAD, 0x46, 0xD9, 
    0xAA, 0xAD, 0xD8, 0x6A, 0x94, 0xAE, 0xD8, 0x9A, 0xAD, 0x46, 0xFA, 0xAA, 0xAD, 0x05, 0xA5, 0xCE, 
    0x8B, 0x9D, 0x15, 0xB5, 0xAB, 0x59, 0x61, 0xBB, 0x6A, 0x62, 0xBB, 0x68, 0x12, 0xB6, 0xAA, 0x36, 
    0xB6, 0x8A, 0x36, 0x61, 0xB4, 0x46, 0x23, 0x70, 0x66, 0x33, 0x70, 0x13, 0x13, 0x37, 0x03, 0x67, 
    0x36, 0x02, 0x46, 0x6B, 0x34, 0x61, 0xAB, 0x68, 0x63, 0xAB, 0x6A, 0x12, 0xB6, 0x8B, 0x26, 0xB6, 
    0xAB, 0x16, 0xB5, 0xAB, 0x59, 0x51, 0xBB, 0x9A, 0x05, 0xA5, 0xBD, 0x8A, 0xAD, 0x46, 0xD9, 0xAB, 
    0xDA, 0x69, 0x94, 0xAD, 0xD9, 0xAA, 0x9D, 0x46, 0xD9, 0x9A, 0xAD, 0xDA, 0x69, 0x94, 0xAD, 0xD9, 
    0xAA, 0x9D, 0x46, 0xE9, 0xCA, 0xD8, 0x8A, 0x9E, 0x46, 0xEA, 0x9E, 0xAF, 0x05, 0xA5, 0xCE, 0x8A, 
    0xDE, 0x5A, 0x51, 0xBB, 0x9A, 0x15, 0xB6, 0xAB, 0x26, 0xB6, 0x8B, 0x26, 0x61, 0xAB, 0x6A, 0x63, 
    0xAB, 0x68, 0x13, 0x46, 0x6B, 0x34, 0x02, 0x67, 0x36, 0x03, 0x37, 0x01, 0x13, 0x37, 0x03, 0x67, 
    0x36, 0x02, 0x46, 0x6B, 0x34, 0x61, 0xAB, 0x68, 0x63, 0xAB, 0x6A, 0x12, 0xB6, 0x8B, 0x26, 0xB6, 
    0xE9, 0x9A, 0x16, 0xB5, 0xE9, 0xAC, 0x5A, 0x51, 0x8B, 0x8D, 0xAD, 0x5A, 0x50, 0x8B, 0x9D, 0xBD, 
    0x46, 0xAA, 0xAE, 0xBD, 0x46, 0x9A, 0xAE, 0xD8, 0x6B, 0xA4, 0xF8, 0xAF, 0x46, 0xFA, 0xCF, 0x6A, 
    0xB4, 0x9A, 0xBD, 0x46, 0xAB, 0xD9, 0x5B, 0x50, 0xBB, 0x9A, 0x15, 0xB5, 0xAB, 0x59, 0x61, 0xBB, 
    0x6A, 0x62, 0xBB, 0x68, 0x12, 0xB6, 0xAA, 0x36, 0xB6, 0x8A, 0x36, 0x61, 0xB4, 0x46, 0x23, 0x70, 
    0x66, 0x33, 0x70, 0x13, 0x13, 0x37, 0x03, 0x67, 0x36, 0x02, 0x46, 0x6B, 0x34, 0x61, 0xAB, 0x68, 
    0x63, 0xAB, 0x6A, 0x12, 0xB6, 0x8B, 0x26, 0xB6, 0xAB, 0x16, 0xB5, 0xAB, 0x59, 0x51, 0xBB, 0x9A, 
    0x05, 0x95, 0xCF, 0xAA, 0xAD, 0x46, 0xF9, 0xAC, 0xDA, 0x6A, 0x94, 0xAD, 0xD8, 0xAA, 0xAD, 0x46, 
    0xD9, 0x8A, 0xAD, 0xDA, 0x6A, 0x94, 0xAD, 0xE8, 0x9A, 0xAD, 0x46, 0xD9, 0x9A, 0xAD, 0xD8, 0x8A, 
    0x46, 0xD9, 0x9A, 0xCF, 0x8A, 0x05, 0x85, 0xBD, 0xDE, 0x8A, 0x15, 0xB5, 0xAB, 0x59, 0x61, 0xBB, 
    0x6A, 0x62, 0xBB, 0x68, 0x12, 0xB6, 0xAA, 0x36, 0xB6, 0x8A, 0x36, 0x61, 0xB4, 0x46, 0x23, 0x70, 
    0x66, 0x33, 0x70, 0x13, 0x13, 0x37, 0x03, 0x67, 0x36, 0x02, 0x46, 0x6B, 0x34, 0x61, 0xAB, 0x68, 
    0x63, 0xAB, 0x6A, 0x12, 0xB6, 0x8B, 0x26, 0xB6, 0xAB, 0x16, 0xA5, 0xFA, 0xAC, 0x59, 0x51, 0xFA, 
    0xEE, 0x5A, 0x50, 0xEA, 0xAC, 0x9D, 0xCE, 0x6A, 0xA4, 0xAD, 0xD8, 0x9A, 0x9E, 0x46, 0xD9, 0x8A, 
    0xBD, 0x9D, 0x46, 0xD9, 0x8A, 0xBD, 0x9D, 0x46, 0xD9, 0x8A, 0xBD, 0x9D, 0x46, 0xD9, 0x8A, 0xAE, 
    0xD9, 0x6A, 0xA4, 0xAD, 0xF8, 0xAC, 0x58, 0x50, 0xAB, 0xDE, 0x8A, 0x15, 0xB5, 0xAB, 0x59, 0x61, 
    0xBB, 0x6A, 0x62, 0xBB, 0x68, 0x12, 0xB6, 0xAA, 0x36, 0xB6, 0x8A, 0x36, 0x61, 0xB4, 0x46, 0x23, 
    0x70, 0x66, 0x33, 0x70, 0x13, 0x13, 0x37, 0x03, 0x67, 0x36, 0x02, 0x46, 0x6B, 0x34, 0x61, 0xAB, 
    0x68, 0x63, 0xAB, 0x6A, 0x12, 0xB6, 0x8B, 0x26, 0xB6, 0xAB, 0x16, 0xB5, 0xAB, 0x59, 0x51, 0xDA, 
    0xBB, 0x05, 0xA5, 0xD8, 0xAB, 0xD8, 0x69, 0xA4, 0xD8, 0x8B, 0xDE, 0x69, 0xA4, 0xD8, 0xAA, 0xDE, 
    0x8A, 0x46, 0x8A, 0xAD, 0xE9, 0x6B, 0xA4, 0xD8, 0xEA, 0x9B, 0x46, 0x8A, 0x8D, 0xBE, 0x8A, 0x46, 
    0x8A, 0xCE, 0xAB, 0x5A, 0x50, 0xEA, 0xAB, 0x5A, 0x51, 0xBB, 0x9A, 0x15, 0xB6, 0xAB, 0x26, 0xB6, 
    0x8B, 0x26, 0x61, 0xAB, 0x6A, 0x63, 0xAB, 0x68, 0x13, 0x46, 0x6B, 0x34, 0x02, 0x67, 0x36, 0x03, 
    0x37, 0x01, 0x13, 0x37, 0x03, 0x67, 0x36, 0x02, 0x46, 0x6B, 0x34, 0x61, 0xAB, 0x68, 0x63, 0xAB, 
    0x6A, 0x12, 0xB6, 0x8B, 0x26, 0xB6, 0xAB, 0x16, 0xB5, 0xAB, 0x59, 0x51, 0xAB, 0xE8, 0xAD, 0x05, 
    0xA5, 0xE8, 0xAC, 0xAF, 0x46, 0xFA, 0xAD, 0xE8, 0x69, 0x94, 0xAD, 0xE8, 0xAA, 0x9D, 0x46, 0xD9, 
    0x9A, 0xAD, 0xDA, 0x69, 0x94, 0xAD, 0xE8, 0xAC, 0xD9, 0x69, 0x94, 0x8F, 0xAE, 0x9E, 0x46, 0x8A, 
    0xCE, 0xFA, 0x5A, 0x50, 0xAB, 0xE8, 0xAD, 0x15, 0xB5, 0xAB, 0x59, 0x61, 0xBB, 0x6A, 0x62, 0xBB, 
    0x68, 0x12, 0xB6, 0xAA, 0x36, 0xB6, 0x8A, 0x36, 0x61, 0xB4, 0x46, 0x23, 0x70, 0x66, 0x33, 0x70, 
    0x13, 0x13, 0x37, 0x03, 0x67, 0x36, 0x02, 0x46, 0x6B, 0x34, 0x61, 0xAB, 0x68, 0x63, 0xAB, 0x6A, 
    0x12, 0xB6, 0x8B, 0x26, 0xB6, 0xAB, 0x16, 0xB5, 0xAB, 0x59, 0x51, 0x8A, 0xDE, 0xAB, 0x05, 0xA5, 
    0xDF, 0x8A, 0xAD, 0x46, 0xDA, 0x9A, 0xAE, 0xD8, 0x69, 0x94, 0xBD, 0xAD, 0xD8, 0x69, 0x94, 0xBD, 
    0xAD, 0xD8, 0x69, 0x94, 0xBD, 0xAD, 0xD8, 0x69, 0x94, 0xAE, 0xD9, 0x8A, 0xAD, 0x46, 0xEA, 0x9C, 
    0x9D, 0xDE, 0x5A, 0x50, 0xFA, 0xDE, 0x8A, 0x15, 0xA5, 0xF9, 0xAC, 0x5A, 0x61, 0xBB, 0x6A, 0x62, 
    0xBB, 0x68, 0x12, 0xB6, 0xAA, 0x36, 0xB6, 0x8A, 0x36, 0x61, 0xB4, 0x46, 0x23, 0x70, 0x66, 0x33, 
    0x70, 0x13, 0x13, 0x37, 0x03, 0x67, 0x36, 0x02, 0x46, 0x6B, 0x34, 0x61, 0xAB, 0x68, 0x63, 0xAB, 
    0x6A, 0x12, 0xB6, 0x8B, 0x26, 0x86, 0xBC, 0x8B, 0x16, 0x95, 0xBC, 0x9B, 0x15, 0x85, 0xFF, 0x9D, 
    0x05, 0x95, 0xFF, 0xAD, 0x46, 0xBB, 0x6B, 0xA4, 0xFA, 0xAD, 0x6A, 0xA4, 0xF8, 0xEE, 0x8A, 0x46, 
    0xEA, 0x9B, 0xAE, 0x46, 0xD9, 0xAB, 0xDA, 0x69, 0x94, 0xBD, 0xAA, 0x9D, 0x05, 0x85, 0xBD, 0xAA, 
    0x8D, 0x15, 0x95, 0xBE, 0xE9, 0x59, 0x61, 0xF9, 0xEE, 0x69, 0x62, 0xFA, 0xAD, 0x26, 0x61, 0xAB, 
    0x6A, 0x63, 0xAB, 0x68, 0x13, 0x46, 0x6B, 0x34, 0x02, 0x67, 0x36, 0x03, 0x37, 0x01, 0x00
};

#endif

