#include    <avr/io.h>

#if defined (__AVR_ATmega8__)
  #define   LCD_PORT                _SFR_IO_ADDR(PORTB)
  #define   LCD_PIN                 _SFR_IO_ADDR(PINB)
  #define   LCD_DDR                 _SFR_IO_ADDR(DDRB)
  #define   LCD_CS                  PB2   // SS
  #define   LCD_SDA                 PB3   // MOSI
  #define   LCD_RESET               PB4   // MISO
  #define   LCD_SCL                 PB5   // SCK
#elif defined (__AVR_ATmega32__)
  #define   LCD_PORT                _SFR_IO_ADDR(PORTB)
  #define   LCD_PIN                 _SFR_IO_ADDR(PINB)
  #define   LCD_DDR                 _SFR_IO_ADDR(DDRB)
  #define   LCD_CS                  PB4   // SS
  #define   LCD_SDA                 PB5   // MOSI
  #define   LCD_RESET               PB6   // MISO
  #define   LCD_SCL                 PB7   // SCK
#elif defined (__AVR_ATmega128__)
  #define   LCD_PORT                _SFR_IO_ADDR(PORTB)
  #define   LCD_PIN                 _SFR_IO_ADDR(PINB)
  #define   LCD_DDR                 _SFR_IO_ADDR(DDRB)
  #define   LCD_CS                  0     // SS
  #define   LCD_SDA                 2     // MOSI
  #define   LCD_RESET               3     // MISO
  #define   LCD_SCL                 1     // SCK
#else
  #error Please define in glcd.inc the hardware pins for your device !
#endif

#ifndef SIG_SPI
  #error Selected device do not support SPI !
#endif

#define LCD_SPCR                    _SFR_IO_ADDR(SPCR)
#define LCD_SPDR                    _SFR_IO_ADDR(SPDR)
#define LCD_SPSR                    _SFR_IO_ADDR(SPSR)

#ifndef XTAL
#define XTAL                        16000000                // must be changed
#endif

#define DELAY_ONE_MILLISECOND       (XTAL / 4 / 1000)       // must > 8

#define USE_CLIPPING                                        // support clipping
// #define USE_HIGHCOLOR                                       // 65535 color mode
// #define USE_ORGINALCOLORS                                   // in 256 color mode use original color table



#ifdef USE_HIGHCOLOR
  #define RGB(r,g,b)                (((r & 0xF8) << 8) | ((g & 0xFC) << 3) | ((b & 0xF8) >> 3))
  #define NONE                      RGB(0x00, 0x40, 0x00)  // == tansparent, one green color reduced !!
#else
  #define RGB(r,g,b)                ((r & 0xE0) | ((g & 0xE0) >> 3) | (b >> 6))
  #define NONE                      RGB(0x00, 0x20, 0x00)  // == tansparent, one green color reduced !!
#endif

#define BLACK                       RGB(0x00, 0x00, 0x00)  // for  8 bit colors R,G,B  3,3,2 Bits
#define WHITE                       RGB(0xFF, 0xFF, 0xFF)  // for 16 bit colors R,G,B  5,6,5 bits
#define RED                         RGB(0xFF, 0x00, 0x00)
#define GREEN                       RGB(0x00, 0xFF, 0x00)
#define BLUE                        RGB(0x00, 0x00, 0xFF)
#define YELLOW                      RGB(0xFF, 0xFF, 0x00)
#define MAGENTA                     RGB(0xFF, 0x00, 0xFF)
#define CYAN                        RGB(0x00, 0xFF, 0xFF)
#define GRAY                        RGB(0x80, 0x80, 0x40)
#define SILVER                      RGB(0xA0, 0xA0, 0x80)
#define GOLD                        RGB(0xA0, 0xA0, 0x40)

#ifndef COLOR_TABLE_BITS
#define COLOR_TABLE_BITS            2                 // 2^2 = 4 colors in color table (minimum)
#endif

#ifdef USE_HIGHCOLOR
#define COLOR_TABLE_SIZE  2 << COLOR_TABLE_BITS       // sizeof glcd_Colors[]
#else
#define COLOR_TABLE_SIZE  1 << COLOR_TABLE_BITS
#endif

#define COLOR_INDEX_BK              0                 // index into glcd_Colors[] color table
#define COLOR_INDEX_FG              1
#define COLOR_INDEX_FR              2
#define COLOR_INDEX_SH              3


#ifndef SCREEN_COLOR0                         // default SCREEN_COLOR background
#define SCREEN_COLOR0               WHITE
#endif
#ifndef SCREEN_COLOR1                         // default foreground color
#define SCREEN_COLOR1               BLACK
#endif
#ifndef SCREEN_COLOR2                         // default frame color
#define SCREEN_COLOR2               GRAY
#endif
#ifndef SCREEN_COLOR3                         // default shadow color
#define SCREEN_COLOR3               SILVER
#endif

#define SCREEN_COLOR                SCREEN_COLOR0
#ifndef SCREEN_WIDTH
#define SCREEN_WIDTH                132   // Nokia 6100, only (1,1,130,130) are visible, but we need full access
#endif
#ifndef SCREEN_HEIGHT
#define SCREEN_HEIGHT               132   // to (0,0,131,131) to support hardware scrolling and splitting of display
#endif
#ifndef SCREEN_LEFT
#define SCREEN_LEFT                 1
#endif
#ifndef SCREEN_TOP
#define SCREEN_TOP                  1
#endif
#ifndef SCREEN_RIGHT
#define SCREEN_RIGHT                (SCREEN_WIDTH -2)
#endif
#ifndef SCREEN_BOTTOM
#define SCREEN_BOTTOM               (SCREEN_HEIGHT -2)
#endif

// glcd_MemCtrl initialization state change default orientation of display
#define ORIENTATION_0               (1 << MEM_RGB) | (1 << MEM_MX)
#define ORIENTATION_90              (1 << MEM_RGB) | (1 << MEM_VW) | (1 << MEM_90)
#define ORIENTATION_180             (1 << MEM_RGB) | (1 << MEM_MY) | (1 << MEM_180)
#define ORIENTATION_270             (1 << MEM_RGB) | (1 << MEM_MX) | (1 << MEM_MY) | (1 << MEM_VW) | (1 << MEM_90) | (1 << MEM_180)

#define ORIENTATION_DEFAULT         ORIENTATION_0


#define FONT_HEADER_SIZE            7     // header size of fonts

// display commands

#define     NO_OPERATION            0x00
#define     SOFT_RESET              0x01
#define     BOOSTER_OFF             0x02
#define     BOOSTER_ON              0x03
#define     DISPLAY_INFO            0x04
#define     DISPLAY_STATUS          0x09
#define     SLEEP_IN                0x10
#define     SLEEP_OUT               0x11
#define     PARTIAL_MODE_ON         0x12
#define     NORMAL_MODE_ON          0x13
#define     INVERSION_OFF           0x20
#define     INVERSION_ON            0x21
#define     PIXELS_OFF              0x22
#define     PIXELS_ON               0x23
#define     SET_CONTRAST            0x25
#define     DISPLAY_OFF             0x28
#define     DISPLAY_ON              0x29
#define     SET_X_ADDR              0x2A
#define     SET_Y_ADDR              0x2B
#define     MEM_WRITE               0x2C
#define     COLOR_SET               0x2D
#define     PARTIAL_AREA            0x30
#define     SCROLL_DEFINITON        0x33
#define     SET_SCROLL              0x37
#define     MEM_CONTROL             0x36
  #define   MEM_90                  0               // virtual flag for orientation, does not exist in PCF8833
  #define   MEM_180                 1               // virtual flag for orientation
  #define   MEM_RGB                 3
  #define   MEM_LAO                 4
  #define   MEM_VW                  5
  #define   MEM_MX                  6
  #define   MEM_MY                  7
#define     IDLE_OFF                0x38
#define     IDLE_ON                 0x39
#define     COLOR_INTERFACE         0x3A
  #define   COLOR_8_BIT             0x02
  #define   COLOR_12_BIT            0x03
  #define   COLOR_16_BIT            0x05
#define     SET_VOP                 0xB0
#define     BOTTOM_ROW_SWAP_OFF     0xB4
#define     BOTTOM_ROW_SWAP_ON      0xB5
#define     TOP_ROW_SWAP_OFF        0xB6
#define     TOP_ROW_SWAP_ON         0xB7
#define     SUPER_FRAME_INV_OFF     0xB8
#define     SUPER_FRAME_INV_ON      0xB9
#define     DATA_ORDER_MSB          0xBA
#define     DATA_ORDER_LSB          0xBB
#define     TEMP_READ               0xC8



