.nolist
#include "glcd.inc"
#include "regs.inc"
.list

// grafic library main part
        .section .data
        .global glcd_MemCtrl
        .global glcd_Flags
        .global glcd_Colors
#ifdef USE_CLIPPING
        .global glcd_Clip
#endif

glcd_MemCtrl: .byte   ORIENTATION_DEFAULT
glcd_Flags:   .byte   0x05;

#ifdef USE_HIGHCOLOR
glcd_Colors:  .word   SCREEN_COLOR, SCREEN_COLOR1, SCREEN_COLOR2, SCREEN_COLOR3
  #if COLOR_TABLE_SIZE > 8
              .space  (COLOR_TABLE_SIZE - 8)
  #endif
#else
glcd_Colors:  .byte   SCREEN_COLOR, SCREEN_COLOR1, SCREEN_COLOR2, SCREEN_COLOR3
  #if COLOR_TABLE_SIZE > 4
              .space  (COLOR_TABLE_SIZE - 4)
  #endif
#endif
#ifdef USE_CLIPPING
glcd_Clip:    .byte   SCREEN_LEFT, SCREEN_TOP, SCREEN_RIGHT, SCREEN_BOTTOM
#endif


// initialization procedure of glcd lib
        .section .init7

glcdInitializeDisplay:
        xcall   glcdDisplayInit


// glcd library
        .section .text

// SPI Interrupt to reset CS of LCD and deactivate SPI

#if defined (SIG_SPI)
        .global  SIG_SPI
SIG_SPI:
#else
#error "This chip has no SPI interrupts defined"
#endif
        sbi     LCD_PORT, LCD_CS
        cbi     LCD_SPCR, SPE
        reti


        .global  glcdDisplayCommand     // used T1 stack 0
glcdDisplayCommand:
        mov     T1, P0                  // don't touch D0,D1,__tmp_reg__,__zero_reg__
        .global glcdDispCommand
glcdDispCommand:
        set
        rjmp    glcdDispSend

        .global glcdDisplayData         // used T1 stack 0
glcdDisplayData:
        mov     T1, P0                  // don't touch D0,D1,__tmp_reg__,__zero_reg__
        .global glcdDispData
glcdDispData:
        clt

        .global glcdDispSend
glcdDispSend:                           // used T1 as SPI transmission data, T flag indicate 9'th MSB
        sbic    LCD_SPCR, SPE           // don't touch D0,D1,__tmp_reg__,__zero_reg__
        rjmp    glcdDispSend
        cbi     LCD_PORT, LCD_CS
        cbi     LCD_PORT, LCD_SCL
        cbi     LCD_PORT, LCD_SDA
        brts    glcdDispSend1
        sbi     LCD_PORT, LCD_SDA
glcdDispSend1:
        sbi     LCD_PORT, LCD_SCL
        sbi     LCD_SPCR, SPE
        out     LCD_SPDR, T1
        ret


        .global glcdDisplayRead         // used T0 stack 0 return P0H:P0L:P1H:P1L
glcdDisplayRead:
        mov     T0, P0

        .global glcdDispRead
glcdDispRead:
        clr     P1L
        clr     P1H
        clr     P0L
        clr     P0H
glcdDispRead1:
        sbic    LCD_SPCR, SPE           // wait for SPI finished
        rjmp    glcdDispRead1
        cbi     LCD_DDR, LCD_SDA
        cbi     LCD_PORT, LCD_CS
glcdDispRead2:
        cbi     LCD_PORT, LCD_SCL
        add     P1L, P1L
        adc     P1H, P1H
        adc     P0L, P0L
        adc     P0H, P0H                // 4
        sbi     LCD_PORT, LCD_SCL
        sbic    LCD_PIN, LCD_SDA
        inc     P1L
        dec     T0
        brne    glcdDispRead2           // 5
        sbi     LCD_PORT, LCD_CS
        sbi     LCD_DDR, LCD_SDA
        ret


        .global glcdDisplayBuffer       // used T0,T1,D0,D1,__temp_reg__ r0 if not enhanced AVR  stack 1
glcdDisplayBuffer:
        _movw   ZL, P0
        mov     T0, P1
glcdDispBuffer:
        tst     P2
        brne    glcdDispBuffer2
glcdDispBuffer1:
        ld      T1, Z+
        rcall   glcdDispData
        dec     T0
        brne    glcdDispBuffer1
        ret
glcdDispBuffer2:
        rpm     T1
        rcall   glcdDispData
        dec     T0
        brne    glcdDispBuffer2
        ret


        .global glcdWait                // used T0,T1 stack 0
glcdWait:
        sbiw    P0, 1                                   // 2
        brcc    glcdWait1                               // 2
        ret                                             // 2 -2 = 0 for no branch in both loops
glcdWait1:
        nop
        ldi     T0, lo8(DELAY_ONE_MILLISECOND -4)       // 1
        ldi     T1, hi8(DELAY_ONE_MILLISECOND -4)       // 1
glcdWait2:
        sbiw    T0, 1                                       // 2
        brne    glcdWait2                                   // 2 = 4, = 3 for last loop
        rjmp    glcdWait                                // 2 = 8


#ifndef USE_HIGHCOLOR
  #ifdef USE_ORGINALCOLORS
COLOR_RED:                                              // original color table
        .byte   0x00, 0x02, 0x04, 0x06, 0x09, 0x0B, 0x0D, 0x0F
COLOR_BLUE:
        .byte   0x00, 0x04, 0x0B, 0x0F
  #else
COLOR_RED:                                              // modified color table
        .byte   0x00, 0x03, 0x05, 0x07, 0x09, 0x0B, 0x0D, 0x0F
COLOR_BLUE:
        .byte   0x00, 0x08, 0x0B, 0x0F
  #endif
#endif

        .global glcdDisplayInit         // used D0,D1,T0,T1,__tmp_reg__,__zero_reg__ stack 4
glcdDisplayInit:

// now initialize ports
        in      T0, LCD_PORT
        andi    T0, ~(1 << LCD_RESET)
        ori     T0, (1 << LCD_CS) | (1 << LCD_SCL) | (1 << LCD_SDA)
        out     LCD_PORT, T0
        in      T0, LCD_DDR
        ori     T0, (1 << LCD_CS) | (1 << LCD_SCL) | (1 << LCD_SDA) | (1 << LCD_RESET)
        out     LCD_DDR, T0
#ifdef SPI2X
        sbi     LCD_SPSR, SPI2X
#endif
        ldi     T0, (1 << MSTR) | (1 << CPOL) | (1 << CPHA) | (1 << SPIE)
        out     LCD_SPCR, T0

        cbi     LCD_PORT, LCD_RESET     // do harware reset of PCF8833
        ldi     P0L, 5                  // wait 5 ms
        ldi     P0H, 0
        rcall   glcdWait
        sbi     LCD_PORT, LCD_RESET
        cbi     LCD_PORT, LCD_CS
        sei

        ldi     T1, SOFT_RESET          // software reset, is realy need !!
        rcall   glcdDispCommand

        ldi     T1, COLOR_INTERFACE     // initialize color format and color mapping
        rcall   glcdDispSend
#ifdef USE_HIGHCOLOR
        ldi     T1, COLOR_16_BIT
        rcall   glcdDispData
#else
        ldi     T1, COLOR_8_BIT
        rcall   glcdDispData
        ldi     P0L, lo8(COLOR_RED)      // red
        ldi     P0H, hi8(COLOR_RED)
        ldi     P1L, lo8(COLOR_RED)      // green
        ldi     P1H, hi8(COLOR_RED)
        ldi     P2L, lo8(COLOR_BLUE)     // blue
        ldi     P2H, hi8(COLOR_BLUE)
        rcall   glcdDisplaySetColors
#endif
        ldi     T1, MEM_CONTROL         // initialize display RAM access
        rcall   glcdDispCommand
        lds     T1, glcd_MemCtrl
        rjmp    glcdDispData


        .global glcdDisplaySetColors
glcdDisplaySetColors:
#ifndef USE_HIGHCOLOR
        ldi     T1, COLOR_SET
        rcall   glcdDispCommand
        _movw   D0, P2           // P2 = P3, P3 = P2
        mov     P2, P3
        _movw   P3, D0
        _movw   D0, P0
        ldi     T0, 8
        rcall   glcdDispBuffer
        _movw   D0, P1
        ldi     T0, 8
        rcall   glcdDispBuffer
        _movw   D0, P3
        ldi     T0, 4
        rjmp    glcdDispBuffer
#else
        ret
#endif
.end














