.nolist
#include "glcd.inc"
#include "regs.inc"
.list

        .text
        .global glcdClearScreen        // used D0,D1,T0,T1,__tmp_reg__,__zero_reg__ stack 2
glcdClearScreen:
#ifdef USE_CLIPPING
        mov     T0, P0
#endif
        ldi     D0, lo8(SCREEN_COLOR)
#ifdef USE_HIGHCOLOR
        ldi     D1, hi8(SCREEN_COLOR)
#endif
        ldi     X1, lo8(SCREEN_LEFT)
        ldi     Y1, lo8(SCREEN_TOP)
        ldi     X2, lo8(SCREEN_RIGHT)
        ldi     Y2, lo8(SCREEN_BOTTOM)
#ifdef USE_CLIPPING
        tst     T0
        brne    glcdDoFillRect4
#endif
        rjmp    glcdDoFillRect          // or should it glcdDoFillRect4 to ignore clipping always ??


        .global glcdFillRect            // used D0,D1,T0,T1,__tmp_reg__,__zero_reg__ stack 2
glcdFillRect:
        _movw   D0, P4                  // save color to D1:D0=ZH:ZL


        .global glcdDoFillRectCheck
glcdDoFillRectCheck:                    // glcdFillRect() where color stored in D1:D0
        rcall   glcdDoCheckCoord


        .global glcdDoFillRect
glcdDoFillRect:                         // void glcdDoFillRect(uint8_t x1,y1,x2,y2, glcdColor_t color)
                                        // glcdFillRect() without coord swapping and color in D1:D0
                                        // don't overwrite X1H, Y1H, X2H, Y2H
#ifdef USE_CLIPPING
        lds     T0, glcd_Flags          // check if we must clip
        sbrs    T0, flagClipping
        rjmp    glcdDoFillRect4

        lds     T0, glcd_Clip_X1
        cp      X2, T0                  // x2 < glcd_Clip.X1 then exit
        brlo    glcdDoFillRect8
        cp      T0, X1                  // x1 > glcd_Clip.X1 then goto check X1,X2
        brlo    glcdDoFillRect1
        mov     X1, T0
glcdDoFillRect1:
        lds     T0, glcd_Clip_X2
        cp      T0, X1                  // x1 > glcd_Clip.X2 then exit
        brlo    glcdDoFillRect8
        cp      X2, T0                  // x2 < glcd_Clip.X2 then goto check Y2,Y1
        brlo    glcdDoFillRect2
        mov     X2, T0
glcdDoFillRect2:
        lds     T0, glcd_Clip_Y1
        cp      Y2, T0                  // y2 < glcd_Clip.Y1 then exit
        brlo    glcdDoFillRect8
        cp      T0, Y1                  // y1 > glcd_Clip.Y1 then goto check Y1,Y2
        brlo    glcdDoFillRect3
        mov     Y1, T0
glcdDoFillRect3:
        lds     T0, glcd_Clip_Y2
        cp      T0, Y1                  // y1 > glcd_Clip.Y2 then exit
        brlo    glcdDoFillRect8
        cp      Y2, T0                  // y2 < glcd_Clip.Y2 then goto paint
        brlo    glcdDoFillRect4
        mov     Y2, T0
#endif

glcdDoFillRect4:
        mov     __tmp_reg__, X2
        sub     __tmp_reg__, X1
        brcs    glcdDoFillRect8         // x1 > x2 then exit
        mov     __zero_reg__, Y2
        sub     __zero_reg__, Y1
        brcs    glcdDoFillRect7         // y1 > y2 then exit
        fcall   glcdSetAddr             // glcdSetAddr(x1, y1, x2, y2)
        inc     __tmp_reg__
        inc     __zero_reg__
                                        // loop (x2 - x1 +1) * (y2 - y1 +1) times
#ifdef USE_HIGHCOLOR
glcdDoFillRect5:                        // high color loops for easyness separated
        mov     P0, __zero_reg__
glcdDoFillRect6:
        movw    T0, D0                  // same codesize for 8 and 16 bit colors
        fcall   glcdPutPixelT
        dec     P0
        brne    glcdDoFillRect6
        dec     __tmp_reg__
        brne    glcdDoFillRect5
#else                                   // 256 color loops
        mov     T1, D0                  // save color for glcdDispSend()
        clt                             // glcdDispSend must send data
glcdDoFillRect5:                        // loop (x2 - x1 +1) * (y2 - y1 +1) times
        mov     P0, __zero_reg__
glcdDoFillRect6:
        fcall   glcdDispSend
        dec     P0
        brne    glcdDoFillRect6
        dec     __tmp_reg__
        brne    glcdDoFillRect5
#endif

glcdDoFillRect7:
        clr     __zero_reg__
glcdDoFillRect8:
        ret


        .global glcdDoCheckCoord
glcdDoCheckCoord:                       // used none stack 0
        cp      X1, X2                  // check coord (x1, y1, x2, y2) such that x1 <= x2, y1 <= y2
        brlo    glcdDoCheckCoord1       // don't touch any register
        eor     X1, X2
        eor     X2, X1
        eor     X1, X2
glcdDoCheckCoord1:
        cp      Y1, Y2
        brlo    glcdDoCheckCoord2
        eor     Y1, Y2
        eor     Y2, Y1
        eor     Y1, Y2
glcdDoCheckCoord2:
        ret

.end
