.nolist
#include "glcd.inc"
#include "regs.inc"
.list

// routine
//   void glcdLine(glcdCoord_t x1, glcdCoord_t y1, glcdCoord_t x2, glcdCoord_t y2);


#define     STX        X2H              // step X axis -1 or +1
#define     STY        Y2H              // step Y axis -1 or +1

#define     DXL        r12              // Abs(X2 - X1) * 2
#define     DXH        r13
#define     DYL        r14              // Abs(Y2 - Y1) * 2
#define     DYH        r15
#define     EEL        r16              // bresenham error propagation
#define     EEH        r17
#define     MEM        r28              // saved glcd_MemCtrl
#define     CNT        r29              // Min(DX, DY)

        .text
        .global glcdLine                // used T0,T1,D0,D1,__temp_reg__,__zero_reg__  stack 3 +8 = 11
glcdLine:
        ldi     D0, COLOR_INDEX_FG
        fcall   glcdDoGetColor
        brne    glcdLine0
        ret                             // not nice but requiered
glcdLine0:
        cp      X1, X2                  // X1 == X2 or Y1 == Y2 ??
        breq    glcdLine1               // test could be removed upto glcdLine2 to save 10 bytes
        cp      Y1, Y2
        brne    glcdLine2
glcdLine1:
        fjmp    glcdDoFillRectCheck     // horz. or vert. line faster drawing
glcdLine2:

        ENTER   10, 0

        ldi     D0, COLOR_INDEX_FG
        fcall   glcdDoGetColor

        lds     MEM, glcd_MemCtrl

        ldi     STX, 1                  // DX == X2 == Abs(X2 - X1), STX == sign(X2 - X1)
        sub     X2, X1
        brcc    glcdLine3
        com     X2
        inc     X2
        subi    STX, 2
glcdLine3:
        ldi     STY, 1                 // DY == Y2 == Abs(Y2 - Y1), STY == sign(Y2 - Y1)
        sub     Y2, Y1
        brcc    glcdLine4
        com     Y2
        inc     Y2
        subi    STY, 2
glcdLine4:
        cp      X2, Y2
        brsh    glcdLine5
        eor     X1, Y1                  // swap(X1, Y1), swap(X2, Y2), swap(STX, STY), and
        eor     Y1, X1                  // finally rotate display 90
        eor     X1, Y1
        eor     X2, Y2
        eor     Y2, X2
        eor     X2, Y2
        eor     STX, STY
        eor     STY, STX
        eor     STX, STY

        ldi     T0, 1 << MEM_90
        eor     T0, MEM
        sts     glcd_MemCtrl, T0
        ori     MEM, 4                  // free bit in glcd_MemCtrl, store here status of swapping
#ifdef USE_CLIPPING
        rcall   glcdSwapClipRect
#endif

glcdLine5:
        mov     DXL, X2
        clr     DXH
        mov     DYL, Y2
        clr     DYH
        add     DYL, DYL                // DY = 2 * DY
        adc     DYH, DYH
        mov     EEL, DYL                // EE = 2 * DY - DX
        mov     EEH, DYH
        sub     EEL, DXL
        sbci    EEH, 0
        add     DXL, DXL                // DX = 2 * DX
        adc     DXH, DXH
        mov     CNT, X2L                // loop counter
        mov     X1H, X1L
        mov     Y1H, Y1L

glcdLine6:
        mov     X2L, X1H                // save actual point in current bottomright point
        mov     Y2L, Y1H
        subi    CNT, 1
        brcs    glcdLine9
        add     X1H, STX                // X  += -+ stepX
        sbrc    EEH, 7                  // EE > 0 ??
        rjmp    glcdLine8
glcdLine7:
        add     Y1H, STY                // Y  += -+stepY
        sub     EEL, DXL                // EE -= 2 * DX
        sbc     EEH, DXH
        brcc    glcdLine7               // loop until EE < 0
        fcall   glcdDoFillRectCheck     // paint rect from last points X1L, Y1L to X2L, Y2L
        mov     X1L, X1H                // save actual point in last point
        mov     Y1L, Y1H
glcdLine8:
        add     EEL, DYL                // EE += 2 * DY
        adc     EEH, DYH
        rjmp    glcdLine6

glcdLine9:
        fcall   glcdDoFillRectCheck

        sbrs    MEM, 2
        rjmp    glcdLine10              // virtual orientation changed ??
        andi    MEM, ~4                 // restore orientation and clipping
        sts     glcd_MemCtrl, MEM
#ifdef USE_CLIPPING
        fcall   glcdSwapClipRect
#endif

glcdLine10:
        LEAVE   10, 0, 1


#undef      STX
#undef      STY
#undef      EEL
#undef      EEH
#undef      DXL
#undef      DXH
#undef      DYL
#undef      DYH
#undef      MEM
#undef      CNT

.end



