.nolist
#include "glcd.inc"
#include "regs.inc"
.list

// routines
//   void glcdCircle(glcdCoord_t x, glcdCoord_t y, glcdCoord_t r);
//   void glcdEllipse(glcdCoord_t x, glcdCoord_t y, glcdCoord_t a, glcdCoord_t b);


#define     RA      P2         // radius a         X2L
#define     RB      P3         // radius b         Y2L

#define     XC      X1H        // center X,Y
#define     YC      Y1H
#define     XO      X2H        // offset X,Y
#define     YO      Y2H

#define     AS0     r4         // AS = RA * RA, 16bit unsigned
#define     AS1     r5
#define     BS0     r6         // BS = RB * RB, 16bit unsigned
#define     BS1     r7
#define     DX0     r8         // DX, 24 bit signed
#define     DX1     r9
#define     DX2     r10
#define     TMP     r11        // temporary
#define     DY0     r12        // DY, 24 bit signed
#define     DY1     r13
#define     DY2     r14
#define     EE0     r3         // EE propagation error, 32bit signed
#define     EE1     r15
#define     EE2     r16
#define     EE3     r17

#define     T00     D0         // temp 0, 24 bit signed
#define     T01     D1
#define     T02     X2L
#define     T10     T0         // temp 1, 24 bit signed
#define     T11     T1
#define     T12     X1L


        .text

glcdDo1Line:                           // ellipse/circle have A or B or A and B == 0
        mov     T0, RA
        mov     T1, RB
        mov     X2, X1
        add     X2, T0
        brcc    glcdDo1Line2
glcdDo1Line1:
        ldi     X2, SCREEN_WIDTH
glcdDo1Line2:
        cpi     X2, SCREEN_WIDTH +1
        brsh    glcdDo1Line1
        sub     X1, T0
        brcc    glcdDo1Line3
        clr     X1
glcdDo1Line3:
        mov     Y2, Y1
        add     Y2, T1
        brcc    glcdDo1Line5
glcdDo1Line4:
        ldi     Y2, SCREEN_HEIGHT
glcdDo1Line5:
        cpi     Y2, SCREEN_HEIGHT +1
        brsh    glcdDo1Line4
        sub     Y1, T1
        brcc    glcdDo1Line6
        clr     Y1
glcdDo1Line6:
        rjmp    glcdRectangle


        .global glcdCircle
glcdCircle:
        mov     RB, RA


        .global glcdEllipse             // used D0,D1,T0,T1,__temp_reg_,__zero_reg__  stack 4 + 17 = 21
glcdEllipse:
        and     RA, RA
        breq    glcdDo1Line
        and     RB, RB
        breq    glcdDo1Line

        ENTER   1, 0

        mov     XC, X1
        mov     YC, Y1
        eor     XO, XO
        mov     YO, RB

#if __AVR_ENHANCED__
        mul     RB, RB
        _movw   BS0, r0

        mul     RA, RA
        _movw   AS0, r0

        clr     DY2
        mul     AS0, RB
        _movw   DY0, r0
        mul     AS1, RB
        add     DY1, r0
        adc     DY2, r1

        clr     __zero_reg__
#else
        mov     D1, RB
        mov     D0, RB
        MUL8x8  BS1, BS0, D1, D0, T0

        mov     D0, RA
        MUL8x8  AS1, AS0, D0, RA, T0

        mov     T1, RB
        _movw   D0, AS0
        MUL8x8  DY1, DY0, D0, T1, T0
        MUL8x8  DY2, D0,  D1, RB, T0
        add     DY1, D0
        adc     DY2, __zero_reg__
#endif

        clr     DX2
        _movw   DX0, AS0
        lsr     DX1
        ror     DX0
        lsr     DX1
        ror     DX0

        clr     EE2
        clr     EE3
        mov     EE0, BS0
        mov     EE1, BS1

        add     EE0, DX0
        adc     EE1, DX1
        adc     EE2, DX2
        adc     EE3, __zero_reg__

        sub     EE0, DY0
        sbc     EE1, DY1
        sbc     EE2, DY2
        sbc     EE3, __zero_reg__

        clr     DX0
        clr     DX1

        add     DY0, DY0
        adc     DY1, DY1
        adc     DY2, DY2

glcdEllipse1:
        cp      DX0, DY0
        cpc     DX1, DY1
        cpc     DX2, DY2
        brge    glcdEllipse3

        rcall   glcdDo4Pixel
        inc     XO

        sbrc    EE3, 7
        rjmp    glcdEllipse2

        dec     YO
        sub     DY0, AS0
        sbc     DY1, AS1
        sbc     DY2, __zero_reg__

        sub     DY0, AS0
        sbc     DY1, AS1
        sbc     DY2, __zero_reg__

        sub     EE0, DY0
        sbc     EE1, DY1
        sbc     EE2, DY2
        sbc     EE3, __zero_reg__
        sbrc    DY2, 7
        inc     EE3

        rcall   glcdDo2Line

glcdEllipse2:
        add     DX0, BS0
        adc     DX1, BS1
        adc     DX2, __zero_reg__

        add     DX0, BS0
        adc     DX1, BS1
        adc     DX2, __zero_reg__

        add     EE0, BS0
        adc     EE1, BS1
        adc     EE2, __zero_reg__
        adc     EE3, __zero_reg__

        add     EE0, DX0
        adc     EE1, DX1
        adc     EE2, DX2
        adc     EE3, __zero_reg__
        sbrc    DX2, 7
        dec     EE3

        rjmp    glcdEllipse1

glcdEllipse3:

        _movw   T00, AS0
        clr     T02

        sub     T00, BS0
        sbc     T01, BS1
        sbc     T02, __zero_reg__

        _movw   T10, T00
        mov     T12, T02

        add     T00, T00
        adc     T01, T01
        adc     T02, T02

        add     T00, T10
        adc     T01, T11
        adc     T02, T12

        asr     T02
        ror     T01
        ror     T00

        sub     T00, DX0
        sbc     T01, DX1
        sbc     T02, DX2

        sub     T00, DY0
        sbc     T01, DY1
        sbc     T02, DY2

        asr     T02
        ror     T01
        ror     T00

        add     EE0, T00
        adc     EE1, T01
        adc     EE2, T02
        adc     EE3, __zero_reg__
        sbrc    T02, 7
        dec     EE3

glcdEllipse4:
        rcall   glcdDo2Line
        rcall   glcdDo4Pixel
        subi    YO, 1
        brcs    glcdEllipse6

        sbrs    EE3, 7
        rjmp    glcdEllipse5

        inc     XO

        add     DX0, BS0
        adc     DX1, BS1
        adc     DX2, __zero_reg__

        add     DX0, BS0
        adc     DX1, BS1
        adc     DX2, __zero_reg__

        add     EE0, DX0
        adc     EE1, DX1
        adc     EE2, DX2
        adc     EE3, __zero_reg__
        sbrc    DX2, 7
        dec     EE3

glcdEllipse5:

        sub     DY0, AS0
        sbc     DY1, AS1
        sbc     DY2, __zero_reg__

        sub     DY0, AS0
        sbc     DY1, AS1
        sbc     DY2, __zero_reg__

        add     EE0, AS0
        adc     EE1, AS1
        adc     EE2, __zero_reg__
        adc     EE3, __zero_reg__

        sub     EE0, DY0
        sbc     EE1, DY1
        sbc     EE2, DY2
        sbc     EE3, __zero_reg__
        sbrc    DY2, 7
        inc     EE3

        rjmp    glcdEllipse4

glcdEllipse6:
        LEAVE   1, 0, 0

doReturn:
        ret

glcdDo4Pixel:
        ldi     D0, COLOR_INDEX_FG
        fcall   glcdDoGetColor
        breq    doReturn
        mov     Y1, YC
        sub     Y1, YO
        brcs    glcdDo4Pixel1
        cpi     Y1, SCREEN_HEIGHT +1
        brsh    glcdDo4Pixel1
        rcall   glcdDo4Pixel2
glcdDo4Pixel1:
        mov     Y1, YC
        add     Y1, YO
        brcs    doReturn
        cpi     Y1, SCREEN_HEIGHT +1
        brsh    doReturn
glcdDo4Pixel2:
        mov     X1, XC
        sub     X1, XO
        brcs    glcdDo4Pixel3
        cpi     X1, SCREEN_WIDTH +1
        brsh    glcdDo4Pixel3
        mov     TMP, Y1
        fcall   glcdDoSetPixel
        mov     Y1, TMP
glcdDo4Pixel3:
        mov     X1, XC
        add     X1, XO
        brcs    doReturn
        cpi     X1, SCREEN_WIDTH +1
        brsh    doReturn
        fjmp    glcdDoSetPixel

glcdDo2Line:
        ldi     D0, COLOR_INDEX_BK
        fcall   glcdDoGetColor
        breq    doReturn
glcdDo2Line0:
        mov     Y1, YC
        sub     Y1, YO
        brcs    glcdDo2Line1
        cpi     Y1, SCREEN_HEIGHT +1
        brsh    glcdDo2Line1
        rcall   glcdDo2Line2
glcdDo2Line1:
        tst     YC
        breq    doReturn
        mov     Y1, YC
        add     Y1, YO
        brcs    doReturn
        cpi     Y1, SCREEN_HEIGHT +1
        brsh    doReturn
glcdDo2Line2:
        mov     X1, XC
        sub     X1, XO
        brcc    glcdDo2Line3
        clr     X1
glcdDo2Line3:
        cpi     X1, SCREEN_WIDTH
        brlo    glcdDo2Line4
        ldi     X1, SCREEN_WIDTH
glcdDo2Line4:
        mov     X2, XC
        add     X2, XO
        brcc    glcdDo2Line5
        ldi     X2, SCREEN_WIDTH
glcdDo2Line5:
        cp      X1, X2
        brsh    doReturn
        mov     Y2, Y1
        fjmp    glcdDoFillRectCheck


#undef      RA
#undef      RB
#undef      XC
#undef      YC
#undef      XO
#undef      YO
#undef      AS0
#undef      AS1
#undef      BS0
#undef      BS1
#undef      DX0
#undef      DX1
#undef      DX2
#undef      TMP
#undef      DY0
#undef      DY1
#undef      DY2
#undef      EE0
#undef      EE1
#undef      EE2
#undef      EE3
#undef      T00
#undef      T01
#undef      T02
#undef      T10
#undef      T11
#undef      T12

.end

/*

void Do2Pixel(glcdCoord_t XC, glcdCoord_t XO, glcdCoord_t Y) {

    glcdSetPixel(XC - XO, Y, glcdFgColor);
    glcdSetPixel(XC + XO, Y, glcdFgColor);
}

void Do4Pixels(glcdCoord_t XC, glcdCoord_t YC, glcdCoord_t XO, glcdCoord_t YO) {

    if (glcdFgColor != NONE) {
      Do2Pixel(XC, XO, YC - YO);
      Do2Pixel(XC, XO, YC + YO);
    }
}

void Do2Line(glcdCoord_t XC, glcdCoord_t YC, glcdCoord_t XO, glcdCoord_t YO) {

    if (glcdBkColor != NONE) {
      glcdFillRect(XC - XO, YC - YO, XC + XO, YC - YO, glcdBkColor);
      glcdFillRect(XC - XO, YC + YO, XC + XO, YC + YO, glcdBkColor);
    }
}

void Ellipse(glcdCoord_t X1, glcdCoord_t Y1, glcdCoord_t RA, glcdCoord_t RB) {

    glcdCoord_t XO = 0;
    glcdCoord_t YO = RB;

    uint16_t AS, BS;
    int32_t EE, DX, DY, T0, T1;

    AS = RA;
    AS = AS * RA;
    BS = RB;
    BS = BS * RB;


    T0 = AS;
    T0 = T0 >> 1;
    T0 = T0 >> 1;
    DY = AS;
    DY = DY * RB;
    EE = BS;
    EE = EE + T0;
    EE = EE - DY;

    DX = 0;
    DY = DY + DY;

    while (DX < DY) {
      Do4Pixels(X1, Y1, XO, YO);
      XO++;
      if (EE >= 0) {
        YO--;
        DY = DY - AS;
        DY = DY - AS;
        EE = EE - DY;
        Do2Line(X1, Y1, XO, YO);
      }
      DX = DX + BS;
      DX = DX + BS;
      EE = EE + BS;
      EE = EE + DX;
	}

    T0 = AS;
    T0 = T0 - BS;
    T1 = T0;
    T0 = T0 + T0;
    T0 = T0 + T1;
    T0 = T0 >> 1;
    T0 = T0 - DX;
    T0 = T0 - DY;
    T0 = T0 >> 1;
    EE = EE + T0;

    while (1) {
      Do2Line(X1, Y1, XO, YO);
      Do4Pixels(X1, Y1, XO, YO);
      if (YO == 0) {break;}
      YO--;
      if (EE < 0) {
        XO++;
        DX = DX + BS;
        DX = DX + BS;
        EE = EE + DX;
      }
      DY = DY - AS;
      DY = DY - AS;
      EE = EE + AS;
      EE = EE - DY;
    }
}
*/

