.nolist
#include "glcd.inc"
#include "regs.inc"
.list

        .section .bss
        .global glcd_FontFirstChar
        .global glcd_FontLastChar
        .global glcd_FontWidth
        .global glcd_FontHeight
        .global glcd_FontBitsPixel
        .global glcd_FontRead
        .global glcd_FontData

glcd_FontFirstChar: .space 1
glcd_FontLastChar:  .space 1
glcd_FontWidth:     .space 1
glcd_FontHeight:    .space 1
glcd_FontBitsPixel: .space 1
glcd_FontRead:      .space 2
glcd_FontData:      .space 2


// font library main part
        .section .text

glcdDoClearFont:                        // clear globals for font lib
        ldi     P0, 9
        ldi     XL, lo8(glcd_FontFirstChar)
        ldi     XH, hi8(glcd_FontFirstChar)
glcdDoClearFont1:
        st      X+, __zero_reg__
        dec     P0
        brne    glcdDoClearFont1
        ret

glcdDoReadFontRPM:                      // default font read callback for flash stored fonts
        _movw   ZL, P0
#if defined  (__AVR_ENHANCED__)
        lpm     P0, Z
#else
        lpm
        mov     P0, r0
#endif
        ret
        

#define     FR          r16    // font read callback
#define     FRL         r16
#define     FRH         r17
#define     FD          r28    // font data, normaly the stack frame pointer
#define     FDL         r28
#define     FDH         r29

glcdDoReadFont:                         // invoke font read callback  -> FontRead(FontData);
        _movw   P0, FD
        adiw    FD, 1
        _movw   ZL, FR
        ijmp

        .global glcdSelectFont          // used FD,FR stack 5 minimum depend of font read callback
glcdSelectFont:
        cp      P1L, __zero_reg__
        cpc     P1H, __zero_reg__
        brne    glcdSelectFont1         // callback != NULL
        cp      P0L, __zero_reg__
        cpc     P0H, __zero_reg__
        breq    glcdDoClearFont         // callback == NULL and fontdata == NULL goto glcdDoClearFont
        ldi     P1H, hi8(glcdDoReadFontRPM)
        ldi     P1L, lo8(glcdDoReadFontRPM)
        lsr     P1H
        ror     P1L
glcdSelectFont1:
        sts     glcd_FontRead +0, P1L
        sts     glcd_FontRead +1, P1H
        sts     glcd_FontData +0, P0L
        sts     glcd_FontData +1, P0H
        rcall   glcdDoSaveFontPtr
        _movw   FR, P1
        _movw   FD, P0
        adiw    FD, 2
        rcall   glcdDoReadFont
        sts     glcd_FontWidth, P0
        rcall   glcdDoReadFont
        sts     glcd_FontHeight, P0
        rcall   glcdDoReadFont
        sts     glcd_FontBitsPixel, P0
        rcall   glcdDoReadFont
        sts     glcd_FontFirstChar, P0
        rcall   glcdDoReadFont
        sts     glcd_FontLastChar, P0

glcdDoRestoreFontPtr:
        pop     FDH
        pop     FDL
        pop     FRH
        pop     FRL
        ret

glcdDoSaveFontPtr:
        pop     ZH
        pop     ZL
        push    FRL
        push    FRH
        push    FDL
        push    FDH
        ijmp


        .global glcdCharWidth
glcdCharWidth:                          // used T0,T1 stack 6 +x in font read callback
        lds     T0, glcd_FontHeight
        tst     T0
        breq    glcdDoClearResult       // glcd_FontHeight == 0 ?? no Font selected ??
        lds     T0, glcd_FontFirstChar
        cp      P0, T0
        brlo    glcdDoClearResult       // input < glcd_FontFirstChar ??
        lds     T1, glcd_FontLastChar
        cp      T1, P0
        brlo    glcdDoClearResult       // input > glcd_FontLastChar ??
        rcall   glcdDoSaveFontPtr
        lds     FDL, glcd_FontData +0
        lds     FDH, glcd_FontData +1
        lds     FRL, glcd_FontRead +0
        lds     FRH, glcd_FontRead +1
        adiw    FD, FONT_HEADER_SIZE
        push    P0                      // save input
        sub     P0, T0
        add     FDL, P0
        adc     FDH, __zero_reg__
        rcall   glcdDoReadFont          // width = glcd_FontRead(glcd_FontData + FONT_HEADER_SIZE + input - glcd_FontFirstChar)
        pop     T0                      // restore input
        mov     P0H, P0L
        tst     P0L
        breq    glcdCharWidth2          // if width = 0 return(width)
        cpi     T0, 128                 // if input < 128 width++
        brsh    glcdCharWidth1
        inc     P0L
glcdCharWidth1:
        lds     T0, glcd_FontWidth
        cp      P0L, T0                 // if width >= glcd_FontWidth return(width)
        brsh    glcdCharWidth2
        lds     T1, glcd_Flags
        sbrs    T1, flagFixedFont
        rjmp    glcdCharWidth2          // if glcd_Flags.FixedFont == 0 return(width)
        mov     P0L, T0
glcdCharWidth2:
        rjmp    glcdDoRestoreFontPtr


        .global glcdNewLine
glcdNewLine:                            // used D0,D1 stack 0
        lds     P0L, glcd_Window_X1     // glcd_Cursor.X = glcd_Window.X1
        sts     glcd_Cursor_X, P0L
        lds     P0L, glcd_Cursor_Y
        lds     D0, glcd_FontHeight
        lds     D1, glcd_Window_Y2
        add     P0L, D0                 // glcd_Cursor.Y += glcd_FontHeight
        add     D0, P0L
        cp      D1, D0
        brsh    glcdNewLine1            // glcd_Cursor.Y + glcd_FontHeight <= glcd_Window.Y2 ??
        lds     P0L, glcd_Window_Y1
glcdNewLine1:
        sts     glcd_Cursor_Y, P0L
glcdDoClearResult:
        clr     P0L
        clr     P0H
glcdDoClearResult1:
        ret


        .global glcdDrawChar
glcdDrawChar:

// first stage some checks, does not use expensive stack frame
#define     X               X1H
#define     Y               Y1L
#define     Width           X2H
#define     CharWidth       Y2H
#define     Input           Y1H
#define     ColorIsNone     T0
#define     i               X2L

        cpi     P0, 13                  // if input = #13 goto glcdNewLine
        breq    glcdNewLine
        cpi     P0, 10
        breq    glcdNewLine             // if input = #10 goto glcdNewLine
        push    P0                      // save input
        rcall   glcdCharWidth
        pop     Input                   // restore input
        tst     P0                      // P0 = width
        breq    glcdDoClearResult1      // if CharWidth(input) == 0 return
        mov     Width, P0L
        mov     CharWidth, P0H

        lds     D0, glcd_Flags          // if (glcd_Flags.AutoLineFeed == 1)
        sbrs    D0, flagLineFeed
        rjmp    glcdDrawChar1
        lds     D0, glcd_Cursor_X       // and if  (glcd_Cursor.X + width > glcd_Window.X2)
        lds     D1, glcd_Window_X2
        add     D0, Width
        cp      D1, D0
        brsh    glcdDrawChar1
        rcall   glcdNewLine             // then glcdNewLine()
glcdDrawChar1:

        lds     X, glcd_Cursor_X
        lds     Y, glcd_Cursor_Y

        mov     D0, X                   // glcd_Cursor.X += width
        add     D0, Width
        sts     glcd_Cursor_X, D0

#ifdef USE_CLIPPING
        lds     D0, glcd_Flags          // clipping active ??
        sbrs    D0, flagClipping
        rjmp    glcdDrawChar2

        lds     D0, glcd_Clip_X2
        cp      D0, X
        brlo    glcdDoClearResult       // if X > glcd_Clip.X2
        lds     D0, glcd_Clip_Y2
        cp      D0, Y
        brlo    glcdDoClearResult       // if glcd_Cursor.Y > glcd_Clip.Y2
        lds     D0, glcd_FontHeight
        add     D0, Y
        lds     D1, glcd_Clip_Y1
        cp      D0, D1
        brlo    glcdDoClearResult       // if y + glcd_FontHeight < glcd_Clip.Y1
glcdDrawChar2:
#endif

// center character and fill possible left and right spaces with BkColor
        ldi     D0, COLOR_INDEX_BK
        fcall   glcdDoGetColor
        ldi     ColorIsNone, 0
        brne    glcdDrawChar3
        inc     ColorIsNone
glcdDrawChar3:
        cp      CharWidth, Width
        brsh    glcdDrawChar6           // if charwidth >= width
        clr     i
        lds     __tmp_reg__, glcd_Flags
        sbrs    __tmp_reg__, flagFixedFont
        rjmp    glcdDrawChar5           // if glcd_Flags.FixedFont == 0
        mov     i, Width                // i = (width - charwidth) / 2
        sub     i, CharWidth
        lsr     i
        breq    glcdDrawChar5
        tst     ColorIsNone
        brne    glcdDrawChar5           // glcd_Colors[COLOR_INDEX_BK] == NONE
        mov     X1L, X                  // fill left space of char
        lds     Y2L, glcd_FontHeight
        add     Y2L, Y1L
        dec     Y2L
        push    i
        add     X2L, X                  // X2L = x + i -1, but X2L == i
        dec     X2L
        push    ColorIsNone
        fcall   glcdDoFillRect          //  glcdDoFillRect(x, y, x + i -1, y + glcd_FontHeight -1, glcdBkColor);
        pop     ColorIsNone
        pop     i
glcdDrawChar4:
        add     X, i                    // x += i
glcdDrawChar5:
        tst     ColorIsNone
        brne    glcdDrawChar6
        add     i, CharWidth
        cp      i, Width
        brsh    glcdDrawChar6
        mov     X1L, X                  // fill right space of char
        add     X1L, CharWidth
        lds     Y1L, glcd_Cursor_Y
        com     X2L                     // X2L == i
        add     X2L, Width
        add     X2L, X1L
        lds     Y2L, glcd_FontHeight
        add     Y2L, Y1L
        dec     Y2L
        fcall   glcdDoFillRect          // glcdDoFillRect(x + charwidth, y, x + charwidth + i -1, y + glcd_FontHeight -1, glcdBkColor)
glcdDrawChar6:

#ifdef USE_CLIPPING
        lds     D0, glcd_Flags          // clipping active ??
        sbrs    D0, flagClipping
        rjmp    glcdDrawChar8
        lds     D0, glcd_Clip_X2
        cp      D0, X
        brlo    glcdDrawChar7           // x > glcd_Clip.X2
        lds     D0, glcd_Clip_X1
        mov     D1, X
        add     D1, CharWidth
        cp      D0, D1
        brlo    glcdDrawChar8           // x + charwidth < glcd_Clip.X1 */
glcdDrawChar7:
        mov     P0L, Width
        mov     P0H, CharWidth
        ret
glcdDrawChar8:
#endif

// second stage, load headers and seed to pixel data
        ENTER   0, 0
                                        // new locations on safe place
        mov     r9, X                   // XC
        mov     r10, Input
        mov     r11, Width
        mov     r12, CharWidth

#undef      X
#undef      Y
#undef      ColorIsNone
#undef      i
#undef      tmp
#undef      Input
#undef      Width
#undef      CharWidth


#define     Table0          r2
#define     Table1          r3
#define     Table2          r4
#define     Padding         r5
#define     SaveBitsCount   r5
#define     Index0          r6
#define     Index1          r7
#define     Index2          r8

#define     XC              r9
#define     Input           r10
#define     Width           r11
#define     CharWidth       r12

#define     BitsL           r13
#define     BitsH           r14
#define     BitsPixel       r15
#define     BitsCount       X1H         // in font read callback save in Temp

#define     FirstChar       T0

// calculate index into character data and initialize some variables
        lds     FRL, glcd_FontRead + 0
        lds     FRH, glcd_FontRead + 1
        lds     FDL, glcd_FontData + 0
        lds     FDH, glcd_FontData + 1
        adiw    FD, FONT_HEADER_SIZE
        lds     FirstChar, glcd_FontFirstChar
        clr     Index0
        clr     Index1
        clr     BitsH
        lds     BitsPixel, glcd_FontBitsPixel
        tst     BitsPixel
        brge    glcdDrawChar13          // uncompressed ??

// font is compressed read Bytepadding and RLE Table[3] from
// glcd_FontData + FONT_HEADER_SIZE + glcd_FontLastChar - glcd_FontFirst +1
        lds     __tmp_reg__, glcd_FontLastChar
        sub     __tmp_reg__, FirstChar
        inc     __tmp_reg__
        add     FDL, __tmp_reg__
        adc     FDH, __zero_reg__
        rcall   glcdDoReadFont
        mov     Padding, P0
        rcall   glcdDoReadFont
        mov     Table0, P0
        rcall   glcdDoReadFont
        mov     Table1, P0
        rcall   glcdDoReadFont
        mov     Table2, P0
// positionate FD to character data
        sub     Input, FirstChar
        breq    glcdDrawChar10
glcdDrawChar9:
        rcall   glcdDoReadFont
        add     Index0, P0
        adc     Index1, __zero_reg__
        dec     Input
        brne    glcdDrawChar9
glcdDrawChar10:
        _movw   T0, Index0
glcdDrawChar11:
        dec     Padding
        breq    glcdDrawChar12
        add     Index0, T0
        adc     Index1, T1
        rjmp    glcdDrawChar11
glcdDrawChar12:
        lds     FDL, glcd_FontData +0
        lds     FDH, glcd_FontData +1
        add     FDL, Index0
        adc     FDH, Index1
        lds     T0, glcd_FontLastChar
        lds     T1, glcd_FontFirstChar
        sub     T0, T1
        clr     T1
        subi    T0, lo8(-3)
        sbci    T1, hi8(-3)
        add     T0, T0
        adc     T1, T1
        subi    T0, lo8(-FONT_HEADER_SIZE)
        sbci    T1, hi8(-FONT_HEADER_SIZE)
        add     FDL, T0
        adc     FDH, T1
        rcall   glcdDoReadFont
        mov     BitsL, P0
        ldi     BitsCount, 8
        rjmp    glcdDrawChar20

glcdDrawChar13:
// font is un-compressed
        clr     Index2
        sub     Input, FirstChar
        breq    glcdDrawChar15
glcdDrawChar14:
        rcall   glcdDoReadFont
        add     Index0, P0
        adc     Index1, __zero_reg__
        dec     Input
        brne    glcdDrawChar14
glcdDrawChar15:
// actualize left clipping, on compressed font not possible
#ifdef USE_CLIPPING
        lds     D0, glcd_Flags             // clipping active ??
        sbrs    D0, flagClipping
        rjmp    glcdDrawChar16
        lds     T0, glcd_Clip_X1
        cp      XC, T0
        brsh    glcdDrawChar16
        sub     T0, XC
        add     Index0, T0
        adc     Index1, __zero_reg__
        adc     Index2, __zero_reg__
        sub     CharWidth, T0
        lds     XC, glcd_Clip_X1
glcdDrawChar16:                             // now we have in index the computed charwidths in pixeln of glcd_FontFirstChar upto Input -1
#endif
        lds     T0, glcd_FontHeight         // index = index * (glcd_FontHeight * BitsPixel)
        mul     T0, BitsPixel
        mov     T0, r0                      // truncated 2^24 * 2^16 mod 2^24 bit multiplication
        mov     T1, r1                      // to ensure 256 characters * 8Bit Pixelwidth per character * 8bit glcd_FontHeight * 8bit BitsPixel
                                            // but only final 24bit result / 8 can be valid for 64Kb memory spaces
        mul     Index0, T0
        _movw   Table0, r0
        clr     Table2
        mul     Index1, T0
        add     Table1, r0
        adc     Table2, r1
        mul     Index2, T0
        add     Table2, r0
        mul     Index0, T1
        add     Table1, r0
        adc     Table2, r1
        mul     Index1, T1
        add     Table2, r0
        clr     __zero_reg__
        mov     SaveBitsCount, Table0
        ldi     T0, 3                       // index = index / 8
glcdDrawChar17:
        lsr     Table2
        ror     Table1
        ror     Table0
        dec     T0
        brne    glcdDrawChar17

        lds     T0, glcd_FontLastChar
        lds     T1, glcd_FontFirstChar
        sub     T0, T1
        lds     FDL, glcd_FontData +0
        lds     FDH, glcd_FontData +1
        add     FDL, T0
        adc     FDH, __zero_reg__
        subi    FDL, lo8(-(FONT_HEADER_SIZE +1))
        sbci    FDH, hi8(-(FONT_HEADER_SIZE +1))
        add     FDL, Table0
        adc     FDH, Table1             // data = glcd_FontData + glcd_FontLastChar - glcd_FontFirstChar + FONT_HEADER_Size +1 + byteindex
        rcall   glcdDoReadFont
        mov     BitsL, P0
        mov     BitsCount, SaveBitsCount
        andi    BitsCount, 7            // bitscount = index % 8
        breq    glcdDrawChar19
        mov     T0, BitsCount
glcdDrawChar18:
        lsr     BitsL
        dec     T0
        brne    glcdDrawChar18
glcdDrawChar19:
        com     BitsCount               // bitscount = 8 - bitscount
        subi    BitsCount, lo8(-9)

#undef      Padding
#undef      Input
#undef      Index0
#undef      Index1
#undef      Index2
#undef      FirstChar
#undef      CharWidth

glcdDrawChar20:
// third stage, paint the character

        rcall   glcdToggleVW
        push    Width

#undef      Width

#define     Table0          r2
#define     Table1          r3
#define     Table2          r4
#define     CursorY         r5
#define     Flags           r6
#define     ClipY           r7
#define     YC              r8
#define     XC              r9
#define     StopY           r10         // stopY
#define     BitsMask        r11         // same as width
#define     StopX           r12         // eg. CharWidth
#define     BitsL           r13
#define     BitsH           r14
#define     BitsPixel       r15

#define     BitsCount       X1H         // in font read callback save in Temp
#define     PixelCount      X2H
#define     Clip_Y1         Y1H
#define     Clip_Y2         Y2H
#define     Clip_X1         X1L
#define     PixelColorL     ZL          // D0
#define     PixelColorH     ZH          // D1

#define     flagAddrInvalid     0
#define     flagNoColorTable    1
#define     flagUseClip         2
#define     flagCompressed      7

        clr     Flags
        lsl     BitsPixel
        ror     Flags
        inc     Flags
        lsr     BitsPixel

        clr     BitsMask
        mov     T0, BitsPixel
glcdDrawChar21:
        lsl     BitsMask
        inc     BitsMask
        dec     T0
        brne    glcdDrawChar21

        add     StopX, XC               // StopX = CharWidth + XC -1
        dec     StopX

#ifdef USE_CLIPPING
        lds     D0, glcd_Flags          // clipping active ??
        sbrs    D0, flagClipping
        rjmp    glcdDrawChar22
        ldi     T0, 1 << flagUseClip
        or      Flags, T0
        lds     Clip_X1, glcd_Clip_X1
        lds     Clip_Y1, glcd_Clip_Y1
        lds     Clip_Y2, glcd_Clip_Y2
        lds     T0, glcd_Clip_X2
        cp      T0, StopX
        brsh    glcdDrawChar22
        mov     StopX, T0
glcdDrawChar22:
#endif

        lds     CursorY, glcd_Cursor_Y
        lds     StopY, glcd_FontHeight
        add     StopY, CursorY
        dec     StopY

        clr     PixelCount

        ldi     T0, COLOR_TABLE_BITS
        cp      T0, BitsPixel
        brsh    glcdDrawChar23
        ldi     T0, 1 << flagNoColorTable
        or      Flags, T0

glcdDrawChar23:
        lds     T0, glcd_Cursor_Y
        sbrc    Flags, flagAddrInvalid
        rjmp    glcdDrawChar24
        cpse    ClipY, CursorY
        inc     Flags
glcdDrawChar24:
        mov     YC, CursorY
glcdDrawChar25:
        tst     PixelCount
        brne    glcdDrawChar31
        cpi     BitsCount, 9
        brsh    glcdDrawChar28
        push    BitsCount
        rcall   glcdDoReadFont
        pop     BitsCount
        clr     T0
        mov     T1, BitsCount
        tst     T1
        breq    glcdDrawChar27
glcdDrawChar26:
        lsl     P0
        rol     T0
        dec     T1
        brne    glcdDrawChar26
glcdDrawChar27:
        or      BitsL, P0
        or      BitsH, T0
        subi    BitsCount, lo8(-8)

#ifdef USE_CLIPPING
        lds     Clip_X1, glcd_Clip_X1
        lds     Clip_Y1, glcd_Clip_Y1
        lds     Clip_Y2, glcd_Clip_Y2
#endif

glcdDrawChar28:
        ldi     PixelCount, 1
        sbrs    Flags, flagCompressed
        rjmp    glcdDrawChar29         // if not compressed font

        mov     ZL, BitsL
        lsr     BitsH                  // Bits = Bits >> 2
        ror     BitsL
        lsr     BitsH
        ror     BitsL
        subi    BitsCount, 2           // BitsCount = BitsCount - 2
        andi    ZL, 3
        breq    glcdDrawChar29         // if Bits and 3 == 0 then PixelCount = 1
        clr     ZH
        inc     ZL                     // table is r2,r3,r4
        ld      PixelCount, Z          // pixelcount = Table[Bits and 3];
glcdDrawChar29:
        mov     ZL, BitsL              // BitsL & (1 << BitsPixel -1)
        and     ZL, BitsMask
        sub     BitsCount, BitsPixel
        mov     T1, BitsPixel
glcdDrawChar30:                        // Bits = Bits >> BitsPixel
        lsr     BitsH
        ror     BitsL
        dec     T1
        brne    glcdDrawChar30

        sbrc    Flags, flagNoColorTable
        rjmp    glcdDrawChar31          // if BitsPixel > COLOR_TABLE_BITS

#ifdef USE_HIGHCOLOR
        lsl     ZL
        rol     T1                      // T1 was zero
#endif
        ldi     T0, lo8(glcd_Colors)
        ldi     ZH, hi8(glcd_Colors)
        add     ZL, T0
        adc     ZH, T1
#ifdef USE_HIGHCOLOR                    // PixelColor = glcd_Colors[bits & bitsmask];
        ld      T0, Z+
        ld      ZH, Z
        mov     ZL, T0
#else
        ld      ZL, Z
#endif

glcdDrawChar31:
        dec     PixelCount

        cpi     PixelColorL, lo8(NONE)
#ifdef USE_HIGHCOLOR
        ldi     T0, hi8(NONE)
        cpc     PixelColorH, T0
#endif
        breq    glcdDrawChar34          // PixelColor == NONE goto RAM address invalid

#ifdef USE_CLIPPING
        sbrs    Flags, flagUseClip      // Clipping active ??
        rjmp    glcdDrawChar32
        cp      YC, Clip_Y1             // if YC < glcd_Clip.Y1 goto RAM address invalid
        brlo    glcdDrawChar34
        cp      Clip_Y2, YC             // if YC > glcd_Clip.Y2 goto RAM address invalid
        brlo    glcdDrawChar34
        cp      XC, Clip_X1             // if XC < glcd_Clip.X1 goto RAM address invalid
        brlo    glcdDrawChar34
glcdDrawChar32:
#endif

        sbrs    Flags, flagAddrInvalid  // RAM address invalid ??
        rjmp    glcdDrawChar33
        dec     Flags
        mov     X1L, XC
        mov     Y1L, YC
        lds     X2L, glcd_Cursor_X
        mov     Y2L, StopY
        fcall   glcdSetAddr             // glcdSetAddr(XC, YC, glcd_Cursor.X, StopY)
        mov     ClipY, YC
#ifdef USE_CLIPPING
        lds     Clip_X1, glcd_Clip_X1
#endif
glcdDrawChar33:

#ifdef USE_HIGHCOLOR                    // put pixel
        mov     T1, ZH
        fcall   glcdDispData
#endif
        mov     T1, ZL
        fcall   glcdDispData

        rjmp    glcdDrawChar35
glcdDrawChar34:
        sbrs    Flags, flagAddrInvalid  // RAM address is invalid
        inc     Flags
glcdDrawChar35:
        inc     YC                      // YC++ until YC > StopY
        cp      StopY, YC
        brlo    glcdDrawChar36
        rjmp    glcdDrawChar25
glcdDrawChar36:
        inc     XC                      // XC++ until XC > StopX
        cp      StopX, XC
        brlo    glcdDrawChar37
        rjmp    glcdDrawChar23
glcdDrawChar37:

        pop     P0                      // Width as result
        rcall   glcdToggleVW            // finish
        LEAVE   0, 0, 1

glcdToggleVW:
        ldi     T1, MEM_CONTROL
        fcall   glcdDispCommand
        lds     T1, glcd_MemCtrl
        ldi     T0, 1 << MEM_VW
        eor     T1, T0
        fjmp    glcdDispData

#undef      Table0
#undef      Table1
#undef      Table2
#undef      CursorY
#undef      Flags
#undef      ClipY
#undef      YC
#undef      XC
#undef      StopY
#undef      BitsMask
#undef      Width
#undef      StopX
#undef      BitsL
#undef      BitsH
#undef      BitsPixel
#undef      BitsCount
#undef      PixelCount
#undef      Clip_Y1
#undef      Clip_Y2
#undef      Clip_X1
#undef      PixelColorL
#undef      PixelColorH
#undef      CursorX
#undef      flagAddrInvalid
#undef      flagNoColorTable
#undef      flagUseClip
#undef      flagCompressed




#undef      FR
#undef      FRL
#undef      FRH
#undef      FD
#undef      FDL
#undef      FDH

.end
