#include "lfsr.inc"

        .data
        .global lfsr_S
        .global lfsr_A
lfsr_S: .long lfsrinit_S
lfsr_A: .long lfsrinit_A
#ifdef LSFR_VARIABLE_POLYNOM
        .global lfsr_Poly_S
        .global lfsr_Poly_A
lfsr_Poly_S: .long Polynom_S
lfsr_Poly_A: .long Polynom_A
#endif

        .text
        .global  lfsr
        .type    lfsr, @function

#define rS0  r2          // register S
#define rS1  r3
#define rS2  r4
#define rS3  r5

#define rA0  r6          // register A
#define rA1  r7
#define rA2  r8
#define rA3  r9

#define pS0  r18         // polynom S
#define pS1  r19
#define pS2  r20
#define pS3  r21

#define pA0  r26         // polynom A
#define pA1  r27
#define pA2  r30
#define pA3  r31

#define rR0  r22         // result
#define rR1  r23
#define rR2  r24
#define rR3  r25

#define cnt  r0          // bit counter

lfsr:
        push    rS0
        push    rS1
        push    rS2
        push    rS3
        push    rA0
        push    rA1
        push    rA2
        push    rA3

        mov     cnt, r24    // bitcount

        clr     rR0         // result = 0
        clr     rR1
        clr     rR2
        clr     rR3

#ifdef LSFR_VARIABLE_POLYNOM
        lds     pS3, lfsr_Poly_S +3
        lds     pS2, lfsr_Poly_S +2
        lds     pS1, lfsr_Poly_S +1
        lds     pS0, lfsr_Poly_S +0
        lds     pA3, lfsr_Poly_A +3
        lds     pA2, lfsr_Poly_A +2
        lds     pA1, lfsr_Poly_A +1
        lds     pA0, lfsr_Poly_A +0
#else
        ldi     pS3, lo8(Polynom_S >> 24)
        ldi     pS2, lo8(Polynom_S >> 16)
        ldi     pS1, lo8(Polynom_S >> 8)
        ldi     pS0, lo8(Polynom_S)
        ldi     pA3, lo8(Polynom_A >> 24)
        ldi     pA2, lo8(Polynom_A >> 16)
        ldi     pA1, lo8(Polynom_A >> 8)
        ldi     pA0, lo8(Polynom_A)
#endif

        lds     rS0, lfsr_S +0
        lds     rS1, lfsr_S +1
        lds     rS2, lfsr_S +2
        lds     rS3, lfsr_S +3
        lds     rA0, lfsr_A +0
        lds     rA1, lfsr_A +1
        lds     rA2, lfsr_A +2
        lds     rA3, lfsr_A +3

lfsr0:  bst     rS0, 0       // t = odd(register s)
        lsr     rS3          // register s = register s >> 1
        ror     rS2
        ror     rS1
        ror     rS0

        lsr     rA3          // register a = register a >> 1
        ror     rA2
        ror     rA1
        ror     rA0
        brcc    lfsr1        // register a was even ??

        eor     rA3, pA3     // register a = register a xor polynom a
        eor     rA2, pA2
        eor     rA1, pA1
        eor     rA0, pA0
        sec

lfsr1:  brtc    lfsr0        // if register s was even

        rol     rR0          // result = result << 1 + odd(register a) before right shift
        rol     rR1
        rol     rR2
        rol     rR3

        eor     rS3, pS3     // register s = register s xor polynom s
        eor     rS2, pS2
        eor     rS1, pS1
        eor     rS0, pS0

        dec     cnt
        brne    lfsr0

        sts     lfsr_S +0, rS0
        sts     lfsr_S +1, rS1
        sts     lfsr_S +2, rS2
        sts     lfsr_S +3, rS3
        sts     lfsr_A +0, rA0
        sts     lfsr_A +1, rA1
        sts     lfsr_A +2, rA2
        sts     lfsr_A +3, rA3

        pop     rA3
        pop     rA2
        pop     rA1
        pop     rA0
        pop     rS3
        pop     rS2
        pop     rS1
        pop     rS0
        ret

#undef Polynom_S
#undef Polynom_A

#undef rS0
#undef rS1
#undef rS2
#undef rS3

#undef rA0
#undef rA1
#undef rA2
#undef rA3

#undef pS0
#undef pS1
#undef pS2
#undef pS3

#undef pA0
#undef pA1
#undef pA2
#undef pA3

#undef rR0
#undef rR1
#undef rR2
#undef rR3

#undef cnt

.end

