// LFSR-SG Polynom declaration

#ifndef Polynom_S
#define Polynom_S  0xC7D5621F
#endif
#ifndef Polynom_A
#define Polynom_A  0x5703CF4C
#endif
#ifndef lfsrinit_S
#define lfsrinit_S 0xE38A4737
#endif
#ifndef lfsrinit_A
#define lfsrinit_A 0x1F065B11
#endif

// #define LSFR_VARIABLE_POLYNOM       // activate this to use variable Polynoms for LFSR,
                                    // eg. for cryptography to change dynamicaly on runtime the polynoms
                                    // as keys.
                                        

/*
any combination of follow polynomials can be used. Select one of table S and another of table A.

1000 random generated irreducible polynomials of degree 32 for Polynom_S.

    0x802D4134, 0x80888492, 0x80A44E12, 0x80A60F4F, 0x80DD35CE, 0x80F16F96, 0x8140C9D5, 0x814C86AA, 0x815D9D50, 0x816804BD,
    0x816C6DE5, 0x8174B80F, 0x819E51E2, 0x81B46F71, 0x81D64B3B, 0x81F474DA, 0x82108542, 0x8214736D, 0x821A4D9D, 0x823DF6B9,
    0x82A86D56, 0x82B7696A, 0x830BF96A, 0x8317BB01, 0x831CCD83, 0x832E2B3B, 0x834AD35B, 0x837A2C7C, 0x838AA2CD, 0x83997F18,
    0x83BE4289, 0x83E38255, 0x8407BAE7, 0x84300E13, 0x843FA1EF, 0x8443402B, 0x8456B42D, 0x8471FFE4, 0x84753540, 0x8476799F,
    0x84D30340, 0x851337B9, 0x8521AE5F, 0x8536789D, 0x854A0C36, 0x8580A669, 0x8581B67E, 0x85D3A52B, 0x8623A4FE, 0x8657BE90,
    0x8664A0F5, 0x86664146, 0x86670530, 0x86C5D6B4, 0x86EB2D2F, 0x871164E9, 0x8739C8B0, 0x875AE9BF, 0x8767BEE3, 0x87685C79,
    0x8769A0CF, 0x877574F4, 0x87A42CC9, 0x87AE9E0F, 0x87BDB357, 0x87CB3F76, 0x87EABE61, 0x87ED8477, 0x87F52B36, 0x88136FFD,
    0x8832671D, 0x88481AA7, 0x8878B975, 0x88AE3199, 0x88DF97B2, 0x89472B0B, 0x894AC9BE, 0x8970DD87, 0x8972A625, 0x89A80780,
    0x89CB7BE1, 0x8A0AAEB8, 0x8A1CF09F, 0x8A7E1A9C, 0x8A863DFB, 0x8B1D0C7D, 0x8B28BD06, 0x8B2D2910, 0x8B76D8E0, 0x8B9A8DB1,
    0x8BBA9E8D, 0x8BBBA4C1, 0x8BC76F98, 0x8BDACF6B, 0x8C220822, 0x8C40408A, 0x8C5C6F98, 0x8C74A4F0, 0x8C8A1C2F, 0x8CB2FA32,
    0x8D173EA7, 0x8D20D621, 0x8D2203FA, 0x8D24B519, 0x8D54A853, 0x8D5B1164, 0x8D8DCADD, 0x8DBC870B, 0x8E14E106, 0x8E26D79D,
    0x8E676D6C, 0x8E6C43FD, 0x8E765717, 0x8F45E272, 0x8F63D480, 0x8FA590D5, 0x8FC11025, 0x8FC77961, 0x904F3C86, 0x9061261B,
    0x906935BB, 0x907EDCBA, 0x90A6CBA4, 0x90AB6EF3, 0x90B2FCB4, 0x90C613E0, 0x90CFC011, 0x90D0AE74, 0x90D70347, 0x90FC3EF1, 
    0x910A0AE0, 0x913712BB, 0x91439ACF, 0x917106FB, 0x9171616A, 0x91857513, 0x91A2A219, 0x91C65561, 0x91C9295F, 0x91D4DB26, 
    0x91D530F3, 0x920923A5, 0x9212D738, 0x9260C568, 0x9288E7FE, 0x92B461D7, 0x92CDBD33, 0x93030B89, 0x931B0914, 0x93308F10, 
    0x933851AA, 0x933D75FC, 0x934AF282, 0x936CB0AB, 0x937BD6A7, 0x94069DB1, 0x941F2692, 0x9425341C, 0x942F99F0, 0x945C5788, 
    0x945E2741, 0x9469FA20, 0x949C69E6, 0x94A4A365, 0x94A965B9, 0x94AC239A, 0x95020351, 0x950558BC, 0x95062472, 0x9506BC83, 
    0x950DFF7F, 0x952CE6CC, 0x958BD391, 0x95A9E597, 0x9637D71A, 0x96416285, 0x966F7818, 0x96709DF0, 0x969AC099, 0x969AF249, 
    0x969D93FE, 0x969DC247, 0x96B169CC, 0x96DB6953, 0x96F39365, 0x971CB631, 0x975501ED, 0x976C786D, 0x9774E89B, 0x978B3D11, 
    0x97914844, 0x9798C1F4, 0x97B913CE, 0x97D03E64, 0x97D5665C, 0x97DB02C3, 0x9824CFD6, 0x98298860, 0x983C1DAE, 0x984037BF, 
    0x984B9EF5, 0x98647D3F, 0x986FF2A9, 0x98A03477, 0x98C5DEBA, 0x98CE01EF, 0x99232831, 0x9940466F, 0x9963E8E7, 0x9966D0A4, 
    0x9994BC0A, 0x99A390A3, 0x99B3B47F, 0x99E9F8B4, 0x99F93ADB, 0x9A377628, 0x9A6C7BC0, 0x9AF2EF84, 0x9B889784, 0x9BD10700, 
    0x9BD5744B, 0x9BED67F5, 0x9BF3C7B7, 0x9C0FA243, 0x9C547928, 0x9CAF1BB4, 0x9CC1DBEF, 0x9CD263B1, 0x9CEED89A, 0x9D476105, 
    0x9D6B5B10, 0x9D9BCDFB, 0x9DA670AA, 0x9DB218C8, 0x9DDB4EEA, 0x9DF05109, 0x9E027169, 0x9E60B24F, 0x9E73C57B, 0x9E8A803D, 
    0x9E8FF83B, 0x9EA8E27E, 0x9EAB9A18, 0x9EDCE98C, 0x9F32E64D, 0x9F6D8D31, 0x9FC0AC24, 0x9FCA6F3A, 0xA011117E, 0xA02479B0, 
    0xA0490DD1, 0xA05A7DA0, 0xA06CD34F, 0xA0874FDF, 0xA0A8F1F9, 0xA0B16F09, 0xA0CD0562, 0xA0CD3B30, 0xA0EBA050, 0xA1024E9C, 
    0xA11F41BE, 0xA15BC11F, 0xA1681080, 0xA19BAA05, 0xA1EE5607, 0xA2A2E1AC, 0xA2B6957D, 0xA2D21F82, 0xA2E215B4, 0xA3044987, 
    0xA31A25D4, 0xA328E094, 0xA38523A5, 0xA38A55DA, 0xA393EE3C, 0xA39F1B2B, 0xA3E08219, 0xA3F4BC22, 0xA41D891D, 0xA43A5D39, 
    0xA43FAA61, 0xA444D116, 0xA4524957, 0xA454A6B4, 0xA45BBD8B, 0xA4645EC4, 0xA48C0612, 0xA4AD1A0E, 0xA4BD1C21, 0xA52CC7E4,
    0xA547E3F7, 0xA548A37D, 0xA575797E, 0xA57AE044, 0xA5804318, 0xA5D03694, 0xA5D97AE4, 0xA62AB969, 0xA62D0D46, 0xA6445395, 
    0xA666BDC5, 0xA679E8CE, 0xA67FD197, 0xA6B4879A, 0xA6B673FF, 0xA6B6A24B, 0xA6F02BE8, 0xA6F1BB92, 0xA70FF29A, 0xA710F238, 
    0xA71CFE98, 0xA778EE73, 0xA77FB5BA, 0xA783FA7B, 0xA78DE285, 0xA7E31B6A, 0xA7E972A9, 0xA80F9BCC, 0xA82E35E6, 0xA8463AC3, 
    0xA86FDB6E, 0xA8D708E1, 0xA91A22A7, 0xA92A2FDE, 0xA939C4EC, 0xA948488D, 0xA94A1BE3, 0xA958F57A, 0xA9789CD8, 0xA97D6A93, 
    0xA99005D8, 0xA9B7E1CC, 0xA9C4B415, 0xA9D65BEB, 0xAA201258, 0xAA243ECD, 0xAA872C19, 0xAA89F772, 0xAAC5BF46, 0xAAD7806D, 
    0xAB09AB6C, 0xAB0C2C27, 0xAB6AD7E5, 0xABAFB947, 0xABC20264, 0xABE3C186, 0xABF142E8, 0xAC2C9A6D, 0xAC94FE55, 0xACE93AB3, 
    0xAD35A675, 0xAD5AE944, 0xAD72A00E, 0xAD90EDEC, 0xADAE8D3C, 0xADD45052, 0xADD9C017, 0xADECB295, 0xADF23660, 0xAE2F0A1D, 
    0xAE33412F, 0xAE5CFC4A, 0xAE89B135, 0xAE97CBC1, 0xAEAE9617, 0xAEC3BA12, 0xAEE051C1, 0xAEEC0C59, 0xAF04FD17, 0xAF40672B, 
    0xAF4FBF88, 0xAF56FD67, 0xAFA74AE8, 0xAFB8F1B5, 0xAFC0A294, 0xAFCBAD0F, 0xAFF192EB, 0xB0643C87, 0xB08E8F17, 0xB0BCD504, 
    0xB0C27F51, 0xB0C63667, 0xB0CA36EF, 0xB0CE8DC3, 0xB0DBB071, 0xB0FB7ED4, 0xB10C0FDB, 0xB130BABF, 0xB1362D77, 0xB16F8031,
    0xB174B0BC, 0xB17D8BC0, 0xB1808FA9, 0xB185C6E5, 0xB1B391AF, 0xB1E4467F, 0xB1F5ED3A, 0xB211FC05, 0xB2575287, 0xB25AB755, 
    0xB26E75A0, 0xB281B691, 0xB28612D9, 0xB2A69388, 0xB2DF4B8F, 0xB3009BE8, 0xB307EC32, 0xB30E220F, 0xB31060C0, 0xB31945F1, 
    0xB3221A6C, 0xB3302B8A, 0xB34F87F3, 0xB37BFBA9, 0xB3B0E28E, 0xB40F2CFB, 0xB41D2508, 0xB485DCDD, 0xB49DC6A8, 0xB4A7EDD3, 
    0xB4CD5405, 0xB4EC1578, 0xB509D0C3, 0xB51755CB, 0xB5351BB3, 0xB581F375, 0xB5D3E57C, 0xB5D8BD57, 0xB5FFA391, 0xB6107C97, 
    0xB6118614, 0xB6262418, 0xB6837FF7, 0xB689518C, 0xB6B75643, 0xB6C57E80, 0xB6CA5441, 0xB6CB0BBC, 0xB6D86352, 0xB6FD2127, 
    0xB72CB005, 0xB7893155, 0xB7924279, 0xB7C8EFAC, 0xB7F17BD5, 0xB7FD2C87, 0xB823A8A6, 0xB82B9467, 0xB87D769E, 0xB8A4F05B, 
    0xB8BABAD1, 0xB8D0381D, 0xB8E54D34, 0xB90B7444, 0xB9383CCC, 0xB95004A6, 0xB9861139, 0xB9B7883E, 0xB9C467E9, 0xB9CDA84C, 
    0xB9DD1175, 0xB9E5F21C, 0xBA4CADEF, 0xBB0252F5, 0xBB2EF4D3, 0xBB4167AD, 0xBB7AE0FA, 0xBBAFDFCD, 0xBBBB4B14, 0xBC1F449F, 
    0xBC6EB368, 0xBC84FEDD, 0xBC96C763, 0xBC9AC85C, 0xBCA8C318, 0xBCF4EBCF, 0xBD0B2333, 0xBD172E09, 0xBD54FBAA, 0xBDBBC660, 
    0xBDD0CD53, 0xBE7A089F, 0xBEA433CD, 0xBEB7B091, 0xBEF25F2A, 0xBEF73FFE, 0xBF0B7E63, 0xBF1314DE, 0xBF209A0A, 0xBF2CBFC2, 
    0xBF3B72C3, 0xBF470755, 0xBF4FFA0A, 0xBF7B4D2C, 0xBF861E7D, 0xBFB1747A, 0xBFE59464, 0xBFF89A1B, 0xC0334B12, 0xC0ECAB33, 
    0xC154F4B3, 0xC1656A83, 0xC18064F1, 0xC18FDBFF, 0xC1ADD9EC, 0xC1E2BA39, 0xC1F97252, 0xC232E5AE, 0xC247AFF8, 0xC24FD20F, 
    0xC257BCC7, 0xC2827F9C, 0xC2A2F941, 0xC300F088, 0xC3061735, 0xC3A4D688, 0xC3A8AD09, 0xC3C3C82A, 0xC3ED7D8E, 0xC43A70E4, 
    0xC4824A4E, 0xC496443E, 0xC4AF3BD4, 0xC525DE7C, 0xC52A88D0, 0xC573F016, 0xC578197C, 0xC5C9BB2B, 0xC5D1E5AD, 0xC5D61C41, 
    0xC5DDE551, 0xC5E9D677, 0xC5FB9031, 0xC645EB10, 0xC6498492, 0xC65E237D, 0xC66CF5F9, 0xC6753842, 0xC6822698, 0xC69952CB,
    0xC6A76651, 0xC6E83042, 0xC7123373, 0xC717EA24, 0xC71A3581, 0xC71B6FA1, 0xC7D23BF0, 0xC7E3C90F, 0xC7EC4A61, 0xC8072FAE, 
    0xC831C390, 0xC8336C1C, 0xC85D540D, 0xC873F249, 0xC88F1C98, 0xC89AAE22, 0xC91FBEC4, 0xC94A0B0F, 0xC9522D85, 0xC95A14DE, 
    0xC973487C, 0xC98B99A0, 0xC99064DF, 0xC9993C65, 0xC9C3A67B, 0xC9CD6364, 0xCA16911E, 0xCA1A5D8E, 0xCA5C8316, 0xCA5ED794, 
    0xCA6B5142, 0xCA801A22, 0xCA9072BB, 0xCA993D94, 0xCB2AD637, 0xCB52294C, 0xCB8420E7, 0xCB8F6547, 0xCBC9C08F, 0xCBCBBF2F, 
    0xCBE71245, 0xCBFC9097, 0xCC0143AF, 0xCC1F80ED, 0xCC30676E, 0xCC373064, 0xCC5011F5, 0xCC545BB4, 0xCC6AC000, 0xCC800AA8, 
    0xCC8BF5F3, 0xCCDCE78A, 0xCCF1872C, 0xCD151679, 0xCD42202E, 0xCD5B8551, 0xCD8250DC, 0xCD84619C, 0xCD893996, 0xCDA9AE1B, 
    0xCDEC4037, 0xCE19CCE8, 0xCE1A5B7C, 0xCE2EAE63, 0xCE59ED13, 0xCE88D42F, 0xCE8D4B49, 0xCEA05BC0, 0xCEA75521, 0xCF0CD6AB, 
    0xCF2A3592, 0xCF2B92CD, 0xCF31A29C, 0xCF3C0D9D, 0xCF401F09, 0xCF43C652, 0xCF43F76A, 0xCF4FBFDE, 0xCFA3B2B7, 0xCFB3C4E4, 
    0xCFE9C94F, 0xD01FC451, 0xD057A5C6, 0xD0B1149E, 0xD0EC6AEE, 0xD1135531, 0xD1272FC8, 0xD13ABB96, 0xD165CDF2, 0xD17EF2A4, 
    0xD19607E0, 0xD1AE646A, 0xD1BA9CE0, 0xD1D211E1, 0xD1EE036F, 0xD2257003, 0xD255B224, 0xD256C5E8, 0xD2BBD109, 0xD2BC7656, 
    0xD2C7502A, 0xD2D470D3, 0xD2DC0766, 0xD2DFB81C, 0xD2E52AD7, 0xD314F901, 0xD32C1EE1, 0xD342AB2D, 0xD34776DE, 0xD349AF63, 
    0xD3586633, 0xD38088ED, 0xD383C83B, 0xD39A46B1, 0xD3B4DEFD, 0xD3C7124B, 0xD43D4581, 0xD442D01A, 0xD458EA7D, 0xD473239C,
    0xD4736C20, 0xD4E918BF, 0xD57A4AB0, 0xD5B7206C, 0xD6231B3A, 0xD6496F21, 0xD66EB9A2, 0xD677D752, 0xD683ABD0, 0xD687A23C, 
    0xD69E0245, 0xD6A330F2, 0xD6B8FE24, 0xD6C38A4E, 0xD712439B, 0xD71244DE, 0xD72E433B, 0xD7358247, 0xD754C9B5, 0xD77D338B, 
    0xD7A481A8, 0xD7C291E1, 0xD7DD6151, 0xD7EF3724, 0xD7FD2BEC, 0xD82B4CB6, 0xD8350F3C, 0xD8895B05, 0xD89FB054, 0xD8A05231, 
    0xD8A0E4BB, 0xD8BCD732, 0xD8C9D460, 0xD93456CF, 0xD93B5F77, 0xD93D202C, 0xD95914AE, 0xD9627E39, 0xD97B4151, 0xD97C7D4D, 
    0xD9878F87, 0xD9A22896, 0xD9D10128, 0xD9DB2C39, 0xD9DB90C2, 0xD9ECB90E, 0xDA095E99, 0xDA12966B, 0xDA547F15, 0xDAA0E60C, 
    0xDACA3AA7, 0xDB1AEC47, 0xDB22FE1A, 0xDB31470B, 0xDBC8FA6D, 0xDBD5E371, 0xDC7167BD, 0xDCB4E4E6, 0xDCD3984A, 0xDCE0E943, 
    0xDD0AEAB5, 0xDD0F0EC4, 0xDD0F8230, 0xDD378492, 0xDD4B663F, 0xDD82E2C9, 0xDD8C96FD, 0xDDC05F56, 0xDDDCE1D3, 0xDDECE2C4, 
    0xDDFB1B94, 0xDE124BED, 0xDE298A28, 0xDE49F90D, 0xDE4AB939, 0xDE8ABCB1, 0xDE921CD8, 0xDE993DDA, 0xDEA02A89, 0xDEAD50EC, 
    0xDF12B225, 0xDF387625, 0xDF3A84D6, 0xDF496DBC, 0xDF4E5133, 0xDF63B53C, 0xDF8D6E33, 0xDF918EE2, 0xDF925CD4, 0xDFAB3237, 
    0xDFC4B7BE, 0xDFCAC55B, 0xDFCE1212, 0xDFD4D1AD, 0xE02A9944, 0xE04BD099, 0xE05B0132, 0xE07ABA40, 0xE0B1DE34, 0xE0CFF5B9, 
    0xE10F05ED, 0xE11A3640, 0xE1570AE9, 0xE1685902, 0xE18BF90F, 0xE1E3B98B, 0xE25C87BE, 0xE2B56332, 0xE2BCD94E, 0xE2BD3D98, 
    0xE2C112FB, 0xE2E10C9F, 0xE2EA3CCB, 0xE2FF11CA, 0xE31ABCB9, 0xE3B2BACA, 0xE3C30787, 0xE3DAD6EC, 0xE3E0BD87, 0xE3EB7CB7, 
    0xE4402A90, 0xE45D5BD4, 0xE46EDA2D, 0xE47BB171, 0xE4A287B0, 0xE4BA2384, 0xE55E14B4, 0xE56E3276, 0xE57415F0, 0xE58F200D,
    0xE5AEBC98, 0xE5BD76AC, 0xE5D48FED, 0xE5F3FE5A, 0xE65C53EA, 0xE660FD48, 0xE67D0F92, 0xE68AA08D, 0xE69030E5, 0xE6924F73, 
    0xE6C69712, 0xE6E504BA, 0xE70EB5E8, 0xE7283A05, 0xE72ED8A6, 0xE76302FE, 0xE770D330, 0xE77F92E2, 0xE7BA6195, 0xE7C29C2F, 
    0xE7CB7C4B, 0xE7EB48C9, 0xE7FEFDF5, 0xE8C6F0C0, 0xE8CDF7D8, 0xE8E82833, 0xE90D3321, 0xE90FF926, 0xE91A43DA, 0xE9543494, 
    0xE96761DF, 0xE9820A97, 0xE9C409D4, 0xE9C61B98, 0xEA1F8FB3, 0xEA679022, 0xEA749C67, 0xEA89D06E, 0xEACDA8EC, 0xEB158C24, 
    0xEB503F60, 0xEB829C96, 0xEB8D4975, 0xEBCA166D, 0xEBD0F799, 0xEC0F240E, 0xEC1D4FFA, 0xEC408C58, 0xEC6680B1, 0xEC8DE99C, 
    0xEC90567C, 0xECA69DC6, 0xECD07A26, 0xECE23F9D, 0xECF9C662, 0xED05EBF3, 0xED2010C6, 0xED353CC3, 0xED4D938B, 0xED53A286, 
    0xED5FFEAE, 0xED6D1825, 0xED957064, 0xEDD01036, 0xEDD6694A, 0xEDF2DA3F, 0xEE28A8B5, 0xEE39F2C8, 0xEE76FB09, 0xEE979BB4, 
    0xEEB22645, 0xEEBD6E3B, 0xEEC32C52, 0xEF1C3A41, 0xEF554A60, 0xEFBF696A, 0xEFD41D91, 0xF002524B, 0xF0221651, 0xF0229F63, 
    0xF0396E64, 0xF05A3EBC, 0xF05C0C55, 0xF05E401E, 0xF096C7C1, 0xF0D912AD, 0xF0E0E857, 0xF0F498B8, 0xF116D421, 0xF145EDA0, 
    0xF16F68B1, 0xF196016F, 0xF1B854E7, 0xF1D8B32B, 0xF210E337, 0xF2605970, 0xF26AFACB, 0xF27ABF25, 0xF2A50915, 0xF2C33BDB, 
    0xF2DB2EBF, 0xF2DE27BC, 0xF2F12B33, 0xF30432FC, 0xF3193763, 0xF33A7D8E, 0xF35BFC89, 0xF3653AF9, 0xF3ACDC3D, 0xF3D345E2, 
    0xF3EBE58F, 0xF42C36E4, 0xF4AC85A0, 0xF4B27AD8, 0xF4BAD504, 0xF4F7B4F0, 0xF501F4D2, 0xF5049899, 0xF50FE765, 0xF51A197D, 
    0xF5353E38, 0xF55D0771, 0xF563416F, 0xF57F01A9, 0xF5D69FD3, 0xF5E490C0, 0xF6312E46, 0xF6397CCD, 0xF64403D4, 0xF6447B4E, 
    0xF67CDCF6, 0xF69609D1, 0xF6A0E4F9, 0xF6AA87E7, 0xF6B5C6FD, 0xF6C84365, 0xF6D8AF63, 0xF6E8463B, 0xF7096F25, 0xF73CBB2C,
    0xF77021A3, 0xF78E97E1, 0xF7A803D7, 0xF7B65CDB, 0xF7E001D6, 0xF7F94D89, 0xF819D6D9, 0xF83495C9, 0xF83D601B, 0xF86FA0EA, 
    0xF893C61A, 0xF8BE759C, 0xF8C191A4, 0xF8C6834E, 0xF8F867F4, 0xF9078396, 0xF93B3054, 0xF947F990, 0xF95EE7B6, 0xF969EA73, 
    0xF9710764, 0xF97F5BD2, 0xF9A0B3C2, 0xF9A7CCD3, 0xF9AFAEDC, 0xF9FD81CD, 0xFA227575, 0xFA48B9D0, 0xFA5F4D06, 0xFA684275, 
    0xFA69BD53, 0xFA8A8C9A, 0xFA980086, 0xFA9C6355, 0xFAA02BD8, 0xFAA98DF3, 0xFAC24D54, 0xFB7F06ED, 0xFBBF4B93, 0xFC274F73, 
    0xFC329C5B, 0xFC61200F, 0xFC920F31, 0xFCC62747, 0xFCD2AFF5, 0xFCE1D403, 0xFCE41EF0, 0xFCE7472E, 0xFCF0A713, 0xFCF7C181, 
    0xFCFC4A2A, 0xFD2CEF2A, 0xFD4F8A10, 0xFD5CC692, 0xFD5E78F6, 0xFD8E503E, 0xFDF25720, 0xFDF6377B, 0xFDFE3AE4, 0xFE063FD0, 
    0xFE0C61AA, 0xFED33C84, 0xFEF2EB93, 0xFF15834E, 0xFF2E62DF, 0xFF6441B9, 0xFF73D941, 0xFF906CA3, 0xFF9A112D, 0xFFFCF059, 

1000 random generated irreducible polynomials of degree 31 for Polynom_A.

    0x40080813, 0x4040307B, 0x4046EDEB, 0x4070B515, 0x407F077C, 0x4090F31F, 0x409C4D0B, 0x409C52C0, 0x40A3972E, 0x40AA6058,
    0x40B08711, 0x40BFFDD6, 0x40D230EA, 0x40E13926, 0x40EB9B5C, 0x4101766F, 0x4112CDFB, 0x411A84CE, 0x411C33F2, 0x41226933, 
    0x4131FE50, 0x41494C60, 0x41665F99, 0x4168EEFB, 0x4169C26B, 0x418784CF, 0x418DDC07, 0x4195FC0C, 0x41D02F72, 0x41DB2B6C, 
    0x41E199F9, 0x41E29137, 0x41EE552E, 0x41F5C5A9, 0x41FC9559, 0x42004CCE, 0x42033EE6, 0x4232DDDC, 0x424DC3F3, 0x427B166B, 
    0x429C7F29, 0x42B13858, 0x42B3EBDC, 0x42C3A2E3, 0x43245D87, 0x432FF9AF, 0x433CAD5A, 0x43400A53, 0x434DB0AC, 0x43534093, 
    0x435DFA4E, 0x435E98FB, 0x439CC884, 0x43DBF398, 0x44295856, 0x44302414, 0x4432F2CC, 0x443B8FAF, 0x4448D3E6, 0x444B7904, 
    0x44515493, 0x44686EE2, 0x4477391D, 0x449A9192, 0x449BDAA6, 0x44A643B0, 0x44A7352F, 0x44B574A4, 0x44BB8DA3, 0x44C529D6, 
    0x44C81D5E, 0x4511BFE8, 0x452F6DC7, 0x453140C4, 0x455886D5, 0x4559DFDD, 0x455AD311, 0x4572CE36, 0x45783850, 0x457E5A89, 
    0x457FD04A, 0x45B4EA18, 0x45B589BC, 0x45BF0D75, 0x45CAF0C4, 0x45CE0458, 0x45DFE87E, 0x45EA3955, 0x45EDD953, 0x460255AA, 
    0x46102E03, 0x461F6E4A, 0x46347EE4, 0x464ADFDA, 0x466D6483, 0x46890BF1, 0x46926371, 0x4692C3D7, 0x469736B8, 0x46A0C1DE, 
    0x46A15044, 0x46A91C95, 0x46B090D8, 0x46B36B01, 0x46F3F11D, 0x46FA37BD, 0x4702E1F8, 0x47081CC5, 0x47238D4C, 0x4732788F, 
    0x474A1CCA, 0x475BE593, 0x476889F3, 0x47860B8D, 0x47B62A3A, 0x47D2613B, 0x47E2C451, 0x47F0031D, 0x47F1E571, 0x48044E73, 
    0x4808DC96, 0x483BEF7D, 0x48786EF7, 0x487D62DC, 0x488050E0, 0x4885749D, 0x48C1A1A9, 0x48C567DA, 0x48D33058, 0x48E82038, 
    0x48EB0AB4, 0x48EBA76B, 0x48EC4B40, 0x491C2FAD, 0x493E5E9E, 0x49574A79, 0x497F93BD, 0x49AD2CB9, 0x49B14A2E, 0x49ED6C89, 
    0x4A056235, 0x4A091E92, 0x4A0EA963, 0x4A2B9943, 0x4A44B922, 0x4A57EB1B, 0x4A58EEDE, 0x4A5E38A4, 0x4A5F6E77, 0x4A71DA59, 
    0x4A86A9B2, 0x4AA778D4, 0x4AB768BB, 0x4AC6D41A, 0x4ACF2CC9, 0x4AD86D2B, 0x4ADBBFBD, 0x4B1E7822, 0x4B3206AB, 0x4B4BEB27, 
    0x4B4C1B2A, 0x4B4D1E84, 0x4BA11C9C, 0x4BAE1A5F, 0x4BB31862, 0x4BB87545, 0x4BD9065D, 0x4BE32779, 0x4BECB2D5, 0x4BF4E84A, 
    0x4BFE1624, 0x4BFE3CA4, 0x4C043F8B, 0x4C10F7D6, 0x4C4C6837, 0x4C5652ED, 0x4C607257, 0x4C6550CE, 0x4C666A40, 0x4C7663E2, 
    0x4C79B8ED, 0x4C91C77C, 0x4CAE7B60, 0x4CC7281D, 0x4CD80A94, 0x4CEECDF9, 0x4CF222AF, 0x4CF7AB29, 0x4D1A88B6, 0x4D1E752A,
    0x4D231314, 0x4D26658F, 0x4D334CF8, 0x4D3E38F0, 0x4D3F61C1, 0x4D824B12, 0x4D88E7F3, 0x4D8ADA12, 0x4D971773, 0x4DAF3C5A, 
    0x4DBF8415, 0x4DC22804, 0x4DCD4CDD, 0x4DED18F3, 0x4E10020C, 0x4E2FCB6A, 0x4E2FF5BF, 0x4E45C36B, 0x4E7322B6, 0x4E746FED, 
    0x4E7C4D02, 0x4EA36D83, 0x4EBF5380, 0x4EDBA7C1, 0x4EED8CA7, 0x4EEEE5DA, 0x4EF299AB, 0x4EFA0B8F, 0x4F166B31, 0x4F197AFB, 
    0x4F20CFA3, 0x4F38E6B6, 0x4F5AC00B, 0x4F5F3805, 0x4F836E04, 0x4F8449C0, 0x4F90FC51, 0x4F952D89, 0x4FB32487, 0x4FE57F31, 
    0x4FEC31BF, 0x4FEC388F, 0x4FF96EC3, 0x4FFD65CA, 0x502487C9, 0x50300B80, 0x50395ABD, 0x507BFD3D, 0x50ABEF65, 0x50C5D8F5, 
    0x50C7E898, 0x50CCAB19, 0x50CE7237, 0x50E68EB5, 0x50F52805, 0x50FBAB00, 0x50FD623F, 0x5101C13E, 0x511BD868, 0x5133E7DC, 
    0x5139A488, 0x517AA655, 0x519E0AB8, 0x51A5196F, 0x51CBE0FE, 0x51D78690, 0x51F353FD, 0x52164679, 0x52282480, 0x5246BE47,
    0x527EAB35, 0x528CF990, 0x52E47F2E, 0x52F21DD4, 0x5312C1E0, 0x53278EA9, 0x5351E9A5, 0x535CAE1C, 0x5369EDFC, 0x536C16BA, 
    0x536FD623, 0x53762FC6, 0x537903AD, 0x53804FB2, 0x539E45CF, 0x53B608F0, 0x53BB8E0F, 0x53DF43A5, 0x53E824DD, 0x54142FBE, 
    0x5416C468, 0x54189A20, 0x5419253D, 0x5429134C, 0x543043B7, 0x5440DB60, 0x5445D6EA, 0x5450BDE9, 0x54592EF7, 0x547106BA, 
    0x5471730F, 0x5472BC1E, 0x547AC85D, 0x548CE9E6, 0x54994175, 0x54A69D09, 0x54AEFA0F, 0x54B9DDE1, 0x54C8A164, 0x54D7560B, 
    0x54DFF215, 0x551F8A4B, 0x555DE09A, 0x55620F80, 0x556AE39D, 0x556D7C60, 0x557EC223, 0x55826F22, 0x559F7B72, 0x55A23973, 
    0x55C42125, 0x55D675DE, 0x55D85BBF, 0x55EF37D4, 0x55FB1F27, 0x5603A6FA, 0x5604B3C9, 0x561A967F, 0x56457483, 0x564F459C, 
    0x5653894A, 0x567B404C, 0x5682D554, 0x56A2C3FD, 0x56BC55A2, 0x56C6B5AB, 0x56DC5FAD, 0x56E536D9, 0x56F61B5F, 0x5723F8A7, 
    0x572E84DF, 0x57357710, 0x573F48CB, 0x57430B08, 0x5746D8EB, 0x575A0CDA, 0x575F4350, 0x5776D51A, 0x577F2504, 0x5783150D, 
    0x57845D6A, 0x578E4A35, 0x5799278C, 0x57AD0FA5, 0x57AEE1ED, 0x57C1A476, 0x57CD57D9, 0x57DD97A0, 0x57FE9F2E, 0x5801AEF4, 
    0x5818A30E, 0x581A7997, 0x581B4335, 0x582211C1, 0x58240441, 0x582E2F7D, 0x584D5C31, 0x5864BC49, 0x58669AAB, 0x587A298A, 
    0x5893D0B1, 0x58984A91, 0x58A2C3F6, 0x58ACE3C9, 0x58C3BF7B, 0x58CAA169, 0x58D2014D, 0x58DC247B, 0x58F29E20, 0x59084CE1, 
    0x5920B94E, 0x5922666F, 0x592BD247, 0x593B30AB, 0x594A31FC, 0x59545A98, 0x595FCEB3, 0x596DC74D, 0x598C0607, 0x598CD89B, 
    0x5997BF82, 0x599CC3FA, 0x59B35A7F, 0x59C1A6D0, 0x59CD95A4, 0x59D5ABFA, 0x59DC4D7C, 0x59DDB383, 0x59DF76E1, 0x59FC5C14, 
    0x5A0A2141, 0x5A0A9E3B, 0x5A3A02FE, 0x5A538985, 0x5A612176, 0x5A763AD5, 0x5A7AC3CD, 0x5A8741F6, 0x5AA4C8FC, 0x5AA60F18, 
    0x5AC271C4, 0x5AF4132B, 0x5AFFDCB5, 0x5B110FB6, 0x5B131D3F, 0x5B326A33, 0x5B6FFE88, 0x5B7A8E6C, 0x5B7FA497, 0x5B991DE3, 
    0x5B9D2A4A, 0x5BA6049A, 0x5BC1343E, 0x5BDF8EFA, 0x5BE00E23, 0x5BECD2FC, 0x5BFA87FE, 0x5C2AA211, 0x5C3E1A56, 0x5C4889EF, 
    0x5C4991EE, 0x5CA588BE, 0x5CB0CB55, 0x5CCA234F, 0x5CCCC993, 0x5CD18BA9, 0x5D19526B, 0x5D406BD3, 0x5D63ACF7, 0x5D73AB9D, 
    0x5D806E5E, 0x5D8AC446, 0x5D99295F, 0x5DCA08F9, 0x5DD0A19D, 0x5DD96823, 0x5DE617E1, 0x5E082711, 0x5E1F0A5A, 0x5E39B9DB, 
    0x5E39CEC9, 0x5E4AFAAA, 0x5E564FF9, 0x5E5763B4, 0x5E6444CA, 0x5E6A26AA, 0x5E6C2699, 0x5E796AC5, 0x5E7EC913, 0x5E816742, 
    0x5E88704D, 0x5EB1A71D, 0x5EB1FFA1, 0x5ED84696, 0x5ED9E949, 0x5EEC140F, 0x5EEFAE04, 0x5F212F6E, 0x5F35BA80, 0x5F41F347,
    0x5F6C2474, 0x5F6CD295, 0x5F7220EA, 0x5F77AA63, 0x5F8DBE21, 0x5F8F3594, 0x5F9BF4E4, 0x5FB8FD0E, 0x5FF766C7, 0x5FFAA528, 
    0x6011C2E5, 0x602074B3, 0x60602233, 0x606BCAEC, 0x6074CBA7, 0x6080AB28, 0x608E2A15, 0x60A4B825, 0x60A977F0, 0x60AAC401, 
    0x60B41471, 0x60CFF056, 0x60E89EC2, 0x6119AFCF, 0x6123254A, 0x61402D59, 0x614C7874, 0x614F8923, 0x615893E4, 0x6163B3BB, 
    0x61666833, 0x616D16D5, 0x618F6633, 0x61900199, 0x61978C2C, 0x61A79764, 0x61BBA866, 0x61F1CCCA, 0x61F6F73C, 0x621A0A84, 
    0x6226587A, 0x62350A2C, 0x62425DA9, 0x62487C71, 0x626B7BE8, 0x627C9A2D, 0x628560ED, 0x62B3E62C, 0x62ED62C0, 0x62FBE2A9,
    0x62FFD283, 0x63004034, 0x6300D73A, 0x631A925F, 0x632DCD94, 0x6339F5F9, 0x6343EC9A, 0x63762A78, 0x6380FD63, 0x6385573A, 
    0x639B1D94, 0x63B0148F, 0x63D531BD, 0x63DA27BC, 0x63DF330E, 0x63F75806, 0x64078E82, 0x640F47BA, 0x643164AB, 0x6445DC6B, 
    0x644A4187, 0x64573883, 0x6461BB93, 0x64710895, 0x649AB837, 0x64BBDA36, 0x64D5080B, 0x64D96D02, 0x64DC2325, 0x64F50ED1, 
    0x652794F7, 0x653BCAC7, 0x654AA866, 0x65563E54, 0x6577337D, 0x65906B4A, 0x6592C04F, 0x659446B7, 0x65947035, 0x6598BD26, 
    0x65A0F528, 0x65A680D6, 0x65AA89E5, 0x65B2C237, 0x65C1CDBB, 0x65DB62DC, 0x65F4D9DE, 0x66031091, 0x66136E8B, 0x6619DD91, 
    0x662F7BE9, 0x663001DF, 0x663C928F, 0x663D856C, 0x664C1701, 0x66779413, 0x6681C0E7, 0x66891B97, 0x66A479D1, 0x66A67772, 
    0x66AC054E, 0x66AEF8C9, 0x66B5F74D, 0x66C1FB9F, 0x66D5B599, 0x66DDF02B, 0x66E6ACAD, 0x66EDC603, 0x66EEB8ED, 0x675F7B01, 
    0x676125E6, 0x67659B72, 0x676A580F, 0x6780D112, 0x679EA89D, 0x67DEEA00, 0x68003196, 0x68008371, 0x6811E13E, 0x681A38DF, 
    0x682A2B44, 0x68328D78, 0x68343438, 0x683BB610, 0x683D3A53, 0x685E7DC6, 0x6875AB9B, 0x687D4E16, 0x6881F5C7, 0x6887445E, 
    0x6895356B, 0x68A43C7E, 0x68BBC96E, 0x68BC143A, 0x68BCB295, 0x68C84391, 0x68D2E59C, 0x68D3C505, 0x68EE5F92, 0x68FE2171, 
    0x6910881F, 0x691EF82C, 0x692337C5, 0x69275ADE, 0x6941DED7, 0x6949C9A8, 0x694B67CE, 0x6963F7A7, 0x69687743, 0x6971AFF3, 
    0x697E3A5C, 0x6983A9EF, 0x69A4D146, 0x69BA9092, 0x69E34C0F, 0x69E4F1FD, 0x69FA1DD2, 0x6A0FFEA4, 0x6A125D13, 0x6A1CFDF5, 
    0x6A3B60F4, 0x6A3FB932, 0x6A4EC9CA, 0x6A623E5F, 0x6A7FE4D6, 0x6A8572DF, 0x6A9D8AA5, 0x6AAECD22, 0x6AB75FBD, 0x6AC734FC, 
    0x6ACB3E8D, 0x6AE1E586, 0x6AE730A5, 0x6B00F111, 0x6B0BE295, 0x6B0CBF33, 0x6B1132F6, 0x6B132504, 0x6B22F8B2, 0x6B31835B, 
    0x6B50E420, 0x6B5840C2, 0x6B6ABE31, 0x6B70CACC, 0x6B769EB6, 0x6B76E92F, 0x6B8B68D8, 0x6B909433, 0x6BAC9182, 0x6BEB5F16, 
    0x6BF42C31, 0x6C0AD141, 0x6C0B690B, 0x6C27413C, 0x6C566CE8, 0x6C57B088, 0x6C5B1F3F, 0x6C92E69F, 0x6C9811D9, 0x6CA6E6FD, 
    0x6CA8D175, 0x6CAE108D, 0x6CB63545, 0x6CBC55D6, 0x6CC95CEB, 0x6CEB9A9F, 0x6CEC4E31, 0x6D084FC7, 0x6D153A78, 0x6D1904D0, 
    0x6D1BF7D4, 0x6D20D84E, 0x6D28C2E8, 0x6D371352, 0x6D3B24D4, 0x6D47A608, 0x6D4B55F7, 0x6D5124BE, 0x6D546262, 0x6D5470E0, 
    0x6D581863, 0x6DA10451, 0x6DB2FAAE, 0x6DD512AA, 0x6E0B6028, 0x6E18A346, 0x6E291C2C, 0x6E31EFF2, 0x6E4D2752, 0x6E514079, 
    0x6E5458E6, 0x6E6D9F93, 0x6E7F3EA4, 0x6E846DF6, 0x6E8734AA, 0x6E8FBBCC, 0x6E94B45F, 0x6EA5620C, 0x6EB49E8E, 0x6EC4A2FB, 
    0x6EC4CF44, 0x6ED66682, 0x6EDB8CA3, 0x6EE4DCF5, 0x6F24BE1B, 0x6F302B2E, 0x6F3A3677, 0x6F413B1A, 0x6F4E665C, 0x6F67A93D, 
    0x6F6A24A9, 0x6F75C6E9, 0x6F78D526, 0x6F8CBF21, 0x6F99D338, 0x6F9C371A, 0x6FBA8DEF, 0x6FBBD422, 0x6FD31BBF, 0x6FD5642B,
    0x6FD62ECD, 0x6FDDB067, 0x6FDE9A8E, 0x6FED84F5, 0x6FEE3204, 0x6FF4F05D, 0x70097318, 0x701B2905, 0x7028F5E3, 0x702D0424, 
    0x703023CF, 0x7053975C, 0x70645522, 0x70871A96, 0x70AD16E9, 0x70BB84B9, 0x70C26BDC, 0x70CE25FE, 0x70D6259B, 0x70DFA587, 
    0x70EB3DB1, 0x70ECAF87, 0x70FFB9CF, 0x7103EC1C, 0x710735A4, 0x71123A9C, 0x711F725E, 0x713A097E, 0x71439727, 0x714C883B,
    0x715EB15B, 0x716B8D80, 0x7170161D, 0x71DA7CB8, 0x71EC3D1E, 0x71F6680D, 0x720A9624, 0x7219DF55, 0x722B30CC, 0x722B69D1, 
    0x722FD000, 0x723E5412, 0x7251F385, 0x72767737, 0x72A31D9C, 0x72B785B0, 0x72B86EEF, 0x72BB3EBF, 0x72C0EFE9, 0x72C27A12, 
    0x72D05C49, 0x72D99B65, 0x72DF324D, 0x72DF9934, 0x72E3BE8A, 0x72E93748, 0x72EBE4C6, 0x72F180C3, 0x72F1DA1B, 0x72F25075, 
    0x73008179, 0x7333B431, 0x7334E22D, 0x735C719B, 0x735E2E36, 0x73846156, 0x73BF2F46, 0x73EF62E0, 0x73EFD142, 0x7401AF8C, 
    0x74095650, 0x741BCF60, 0x741D9A69, 0x74349872, 0x743AD586, 0x743DCEB1, 0x74476C39, 0x7459A027, 0x7462D792, 0x746A2C68, 
    0x74A0C312, 0x74A18B04, 0x74A76320, 0x74AEB11A, 0x74BEE184, 0x74E90A2C, 0x7507F162, 0x75153948, 0x753617F4, 0x75374B9A, 
    0x754CAF5F, 0x755457B6, 0x755BFE6B, 0x75696DFC, 0x7571A3D5, 0x75770717, 0x75B2DA9A, 0x75C5395B, 0x75C6E794, 0x75D01B30, 
    0x75D47F90, 0x75F2D6B6, 0x75F86999, 0x761B0FC4, 0x76401430, 0x764DFBEE, 0x764E39A1, 0x764EECAA, 0x766F8B5D, 0x768877F7, 
    0x768D46F6, 0x7696D5C3, 0x769AE443, 0x76A35002, 0x76A61D58, 0x76B0C1F1, 0x76DB38CA, 0x76F49E43, 0x770EA735, 0x7742A647, 
    0x774DA518, 0x775DE0F3, 0x776BD761, 0x776C6179, 0x777018CD, 0x777CC8DD, 0x7785928B, 0x7787BECC, 0x778B2557, 0x778F23F3, 
    0x77952488, 0x77966D6D, 0x779AE6D3, 0x77AF570E, 0x7800A9B8, 0x7814504B, 0x7817A10E, 0x78317B49, 0x784A83A0, 0x7857611E, 
    0x785BD10B, 0x78615CE3, 0x78721538, 0x78787D5C, 0x78884E4E, 0x789AD442, 0x789BFC0D, 0x78A2D76D, 0x78BB5F48, 0x78BBBAFE, 
    0x78CCF2F8, 0x78D2140C, 0x78D9A6BF, 0x78F9744D, 0x793239E7, 0x7933F9A1, 0x7935D84F, 0x793818AA, 0x793A166F, 0x795A9B99, 
    0x796C0212, 0x7971C818, 0x79781DB9, 0x798F4B59, 0x79B5C072, 0x79E838CA, 0x79F0DC24, 0x79FE92CE, 0x7A06846E, 0x7A0AA057, 
    0x7A101654, 0x7A2E5472, 0x7A512150, 0x7A5262CD, 0x7A5AD1D3, 0x7A6326E7, 0x7A7D08E8, 0x7AA0A1F5, 0x7AA41E30, 0x7AA50D6A, 
    0x7AC34BB3, 0x7ACE312F, 0x7AD24252, 0x7AF99765, 0x7B165E81, 0x7B29985A, 0x7B32D801, 0x7B34FDC0, 0x7B3C7CAB, 0x7B3EB849,
    0x7B3F6AD7, 0x7B54D19B, 0x7B661E36, 0x7B833AC4, 0x7B95C9AA, 0x7B95D629, 0x7B99CB62, 0x7BB103AC, 0x7BBA0D21, 0x7BBC7AED,
    0x7C3AA652, 0x7C4E4B7A, 0x7C515189, 0x7C53AE2E, 0x7C616E8F, 0x7C8C1E56, 0x7C8D7F03, 0x7CB5BCDA, 0x7CC9AD41, 0x7CCE2A64,
    0x7CD0C55F, 0x7CDC4CE3, 0x7CDE62DD, 0x7D00C264, 0x7D12E658, 0x7D13F76A, 0x7D19587D, 0x7D1B9DC7, 0x7D5FEE1E, 0x7D60B2A0,
    0x7D7706E1, 0x7D77F286, 0x7D82D26F, 0x7DAE3BB8, 0x7DC1DDCE, 0x7DD66772, 0x7DE0F3BF, 0x7DE62702, 0x7E0D22FE, 0x7E0DDD26,
    0x7E1BD7E2, 0x7E2214EE, 0x7E2DFF48, 0x7E32BDA7, 0x7E44E2AF, 0x7E4D9655, 0x7E51BF3A, 0x7E6847C1, 0x7E7212F0, 0x7E7B3C24,
    0x7EB15517, 0x7EBB98D0, 0x7EC0D150, 0x7EDEE02F, 0x7EE66CE9, 0x7EED17CA, 0x7EF136D5, 0x7EF664A8, 0x7F05639D, 0x7F0C6BAC,
    0x7F2C3B83, 0x7F2CE3BC, 0x7F3F0351, 0x7F555C4F, 0x7F6762F8, 0x7F6A93DF, 0x7F7B3E1B, 0x7F82DEA2, 0x7F866374, 0x7F8D5554,
    0x7F973CEB, 0x7F996591, 0x7FAB0650, 0x7FAB6C5A, 0x7FACB9A5, 0x7FBA6D70, 0x7FC24361, 0x7FC7A911, 0x7FCD6CAF, 0x7FDCA927
*/
