#include    <avr/io.h>

// follow defines depends from typdef of glcdCoord_t
#define     glcd_Clip_X1    glcd_Clip +0
#define     glcd_Clip_Y1    glcd_Clip +1
#define     glcd_Clip_X2    glcd_Clip +2
#define     glcd_Clip_Y2    glcd_Clip +3

#define     glcd_Window_X1  glcd_Window +0
#define     glcd_Window_Y1  glcd_Window +1
#define     glcd_Window_X2  glcd_Window +2
#define     glcd_Window_Y2  glcd_Window +3

#define     glcd_Cursor_X   glcd_Cursor +0
#define     glcd_Cursor_Y   glcd_Cursor +1

#define     flagLineFeed    0  // glcd_Flags.AutoLineFeed
#define     flagFixedFont   1  // glcd_Flags.FixedFont
#define     flagClipping    2  // glcd_Flags.Clipping 

// register names, must be reassigned to support macros

#define     r0              0
#define     r1              1
#define     r2              2
#define     r3              3
#define     r4              4
#define     r5              5
#define     r6              6
#define     r7              7
#define     r8              8
#define     r9              9
#define     r10             10
#define     r11             11
#define     r12             12
#define     r13             13
#define     r14             14
#define     r15             15
#define     r16             16
#define     r17             17
#define     r18             18
#define     r19             19
#define     r20             20
#define     r21             21
#define     r22             22
#define     r23             23
#define     r24             24
#define     r25             25
#define     r26             26
#define     r27             27
#define     r28             28
#define     r29             29
#define     r30             30
#define     r31             31

#ifndef     __tmp_reg__
#define     __tmp_reg__     r0
#endif
#ifndef     __zero_reg__
#define     __zero_reg__    r1
#endif

#define     P0              r24    // parameters used by WinAVR, must not saved
#define     P0L             r24
#define     P0H             r25
#define     P1              r22
#define     P1L             r22
#define     P1H             r23
#define     P2              r20
#define     P2L             r20
#define     P2H             r21
#define     P3              r18
#define     P3L             r18
#define     P3H             r19

#define     P4              r16    // must be saved
#define     P4L             r16
#define     P4H             r17

#define     X1              P0
#define     X1L             P0L
#define     X1H             P0H
#define     Y1              P1
#define     Y1L             P1L
#define     Y1H             P1H
#define     X2              P2
#define     X2L             P2L
#define     X2H             P2H
#define     Y2              P3
#define     Y2L             P3L
#define     Y2H             P3H

#define     D0              r30    // r31:r30
#define     D1              r31
#define     T0              r26    // r27:r26  free, must not saved
#define     T1              r27

// assembler defines
// define USE_FAR_JUMP in makefile if gcc-linker can not reallocate

#ifdef USE_FAR_JUMP
  #if FLASHEND > 0x2000               /*  more as 8Kb*/
    #define     fjmp        jmp
    #define     fcall       call
  #else
    #define     fjmp        rjmp
    #define     fcall       rcall
  #endif
#else
    #define     fjmp        rjmp
    #define     fcall       rcall
#endif

#if __AVR_MEGA__
  #if FLASHEND > 0x2000               /*  more as 8Kb*/
    #define     xjmp        jmp
    #define     xcall       call
  #else
    #define     xjmp        rjmp
    #define     xcall       rcall
  #endif
#else
    #define     xjmp        rjmp
    #define     xcall       rcall
#endif


// macro to utilize lpm with inc

.macro  rpm     reg
#if defined  (__AVR_ENHANCED__)
        lpm     \reg, Z+
#else
        lpm
        mov     \reg, r0
        adiw    ZL, 1
#endif
.endm

// macro to enter a stack with gcc

.macro ENTER unused_regs stack_locals

ENTER:
        clr     XH
        ldi     XL, \stack_locals
        ldi     ZH, hi8(ENTRY)      // there is no way to rescale an address by 0.5
        ldi     ZL, lo8(ENTRY)      // thus we have to right shift the address with additional code
        lsr     ZH
        ror     ZL
        xjmp    (__prologue_saves__ + 2 * \unused_regs)
ENTRY:
.endm


// macro to leave a stack entered with ENTER

.macro LEAVE unused_regs stack_locals ptr_changed

LEAVE:
        ldi     ZL, 18 - \unused_regs
        .if (\ptr_changed)
           in      YL, _SFR_IO_ADDR(SPL)
           in      YH, _SFR_IO_ADDR(SPH)
        .endif
        .if (\stack_locals)
           adiw    YL, \stack_locals
        .endif
        xjmp    (__epilogue_restores__ + 2 * (\unused_regs))
.endm


// macro unsigned 8x8 multiplication

.macro  MUL8x8  resH resL A B temp
        clr	    \resH
        ldi     \temp, 8
        lsr	    \A
        brcc    .+2
        add     \resH, \B
        ror     \resH
        ror     \resL
        dec     \temp
        brne    .-14
.endm


// movw replacement, support words on odd addresses, overlapping, hardware dependend
// and avoid dummy moves on same registers, to get this macro working we have to reassign
// register defines, such as above

.macro  _movw dst src
    .if (\src - \dst)
        .if ((\src | \dst) & 0x01)
            .if ((\src - \dst) & 0x80)
                mov     \dst +1, \src +1
                mov     \dst   , \src
            .else
                mov     \dst   , \src
                mov     \dst +1, \src +1
            .endif
        .else
#if __AVR_ENHANCED__
                movw    \dst   , \src
#else
                mov     \dst   , \src
                mov     \dst +1, \src +1
#endif
        .endif
    .endif
.endm

