#include <inttypes.h>
#include <glcd.h>
#include <lfsr.h>
#include <..\font\nums.h>
#include <..\font\f9x14.h>


void testLines(uint8_t iteration) {

    for (uint8_t i = 0; i < iteration; i++) {
      glcdClearScreen(0);
      glcdSetColor(0, SCREEN_COLOR);
      glcdSetColor(1, BLACK);
      glcdSetColor(2, GOLD);
      glcdSetColor(3, RED);
      for (glcdCoord_t x = SCREEN_LEFT; x <= SCREEN_RIGHT; x++) {
        glcdSetFgColor(YELLOW);
        glcdLine(x, SCREEN_TOP, x, SCREEN_BOTTOM);
        glcdSetFgColor(GREEN);
        glcdLine(SCREEN_RIGHT - x, SCREEN_TOP, SCREEN_RIGHT - x, SCREEN_BOTTOM);
        glcdSetFgColor(BLUE);
        glcdLine(SCREEN_LEFT, SCREEN_TOP, x, SCREEN_BOTTOM);
        glcdSetFgColor(RED);
        glcdLine(SCREEN_RIGHT, SCREEN_BOTTOM, SCREEN_RIGHT - x + SCREEN_LEFT, SCREEN_TOP);
      }
    }
}


void testLines2(uint8_t iteration) {

    for (uint8_t i = 0; i < iteration; i++) {
      glcdClearScreen(0);
      for (uint8_t j = 0; j < 255; j++) {
        glcdSetFgColor(lfsr(16));
        glcdLine(lfsr(7) +2, lfsr(7) +2, lfsr(7) +2, lfsr(7) +2);
      }
    }
}

void testEllipses(uint8_t iteration) {

   glcdColor_t c[7];

   c[0] = YELLOW;
   c[1] = RED;
   c[2] = BLUE;
   c[3] = GREEN;
   c[4] = YELLOW;
   c[5] = RED;
   c[6] = BLUE;

   int8_t i, j = 0, count, k = 1, d = 1;

   for (; iteration > 0; iteration--) {
     glcdSetBkColor(NONE);
     for (count = 0; count < 3; count++) {
       for (i = 67; i > 0; i -= k) {
         glcdSetFgColor(c[j]);
         glcdSetFgColor(c[j +1]);
         glcdEllipse(65, 65, i, 67 - i);
         glcdSetFgColor(c[j +2]);
         glcdEllipse(65, 65, 67 - i, i);
       }
       if (++j >= 4) {j = 0;}
     }
     for (count = 0; count < 3; count++) {
       for (i = 67; i > 0; i -= k) {
         glcdSetFgColor(c[j]);
         glcdSetBkColor(c[j +1]);
         glcdEllipse(65, 65, i, 67 - i);
         glcdSetBkColor(c[j +2]);
         glcdEllipse(65, 65, 67 - i, i);
       }
       if (++j >= 4) {j = 0;}
     }
     k += d;
     if ((k > 5) | (k == 1)) {d = -d;}
   }
}

void testEllipses2(uint8_t iteration) {

    for (; iteration > 0; iteration--) {
      glcdClearScreen(0);
      for (uint8_t i = 0; i < 255; i++) {
        glcdSetColors(lfsr(16), lfsr(16));
        glcdEllipse(lfsr(7) +2, lfsr(7) +2, lfsr(6), lfsr(6));
      }
    }
}


void testRects(uint8_t iteration) {

    for (; iteration > 0; iteration--) {
      glcdClearScreen(0);
      for (uint8_t i = 0; i < 255; i++) {
        glcdSetColors(lfsr(16), lfsr(16));
        glcdRectangle(lfsr(7) +2, lfsr(7) +2, lfsr(7) +2, lfsr(7) +2);
      }
    }
}

// Rotate a rectangle form source orientation to dest orientation such that
// the rectangle is on display always on same location. Please remember the orientation
// of the display in this library is not relative and thus the clipping rect is relative
// to the current orientation set. This simplify normaly the work with different orientations
// on same code. Means the same source with painting can be directly used with different orientations
// without any changes on coordinates. But for this demonstration we have to take care about this,
// because we want always printing on same display locations with different orientations.

void glcdRotateRect(glcdRect_t *rect, uint8_t source, uint8_t dest) {

    if ((source & 3) != (dest & 3)) {

      glcdCoord_t x1=0, x2=0, y1=0, y2=0;

      switch (source & 3) {
        case 0: {
          x1 = (*rect).X1;
          y1 = (*rect).Y1;
          x2 = (*rect).X2;
          y2 = (*rect).Y2;
          break;
        }
        case 1: {
          x1 = 131 - (*rect).Y2;
          x2 = 131 - (*rect).Y1;
          y1 = (*rect).X1;
          y2 = (*rect).X2;
          break;
        }
        case 2: {
          x1 = 131 - (*rect).X2;
          x2 = 131 - (*rect).X1;
          y1 = (*rect).Y2 - 1;
          y2 = (*rect).Y1 - 1;
          break;
        }
        case 3: {
          x1 = (*rect).Y1;
          x2 = (*rect).Y2;
          y1 = 131 - (*rect).X2;
          y2 = 131 - (*rect).X1;
          break;
        }
      }

      switch (dest & 3) {
        case 0: {
          (*rect).X1 = x1;
          (*rect).Y1 = y1;
          (*rect).X2 = x2;
          (*rect).Y2 = y2;
          break;
        }
        case 1: {
          (*rect).X1 = y1;
          (*rect).X2 = y2;
          (*rect).Y1 = 131 - x2;
          (*rect).Y2 = 131 - x1;
          break;
        }
        case 2: {
          (*rect).X1 = 131 - x2;
          (*rect).X2 = 131 - x1;
          (*rect).Y1 = y2 + 1;
          (*rect).Y2 = y1 + 1;
          break;
        }
        case 3: {
          (*rect).X1 = 131 - y2;
          (*rect).X2 = 131 - y1;
          (*rect).Y1 = x1;
          (*rect).Y2 = x2;
          break;
        }
      }
    }
}

void glcdNewOrientation(uint8_t orientation) {

    glcdRotateRect(&glcd_Clip, glcd_MemCtrl, orientation);
    glcdSetOrientation(orientation);
}

void testSymbols(uint8_t iteration) {

    uint8_t mem = glcd_MemCtrl;     // save glcd_MemCtrl, thus orientation in 2 MSB's

    glcd_Flags.AutoLineFeed = 0;

    glcdSelectFont(nums, 0);
    glcdSetBkColor(NONE);
    for (; iteration > 0; iteration--) {
      glcdClearScreen(0);
      for (uint8_t i = 0; i < 255; i++) {
        glcdNewOrientation(lfsr(2));
        glcdSetColor(1, lfsr(16));
        glcdSetColor(2, lfsr(16));
        glcdSetColor(3, lfsr(16));
        glcdMoveTo(lfsr(7), lfsr(7));
        glcdDrawChar(lfsr(4) % 11 + 32);
      }
    }
    glcdNewOrientation(mem);
}



// print text centered horizontal and vertical into bounds r
void glcdPrintCenter(glcdRect_t r, char *text, uint8_t InFlashStored) {

    r.X1 += (r.X2 - r.X1 - glcdCharsWidth(text, InFlashStored)) / 2;
    r.Y1 += (r.Y2 - r.Y1 - glcd_FontHeight) / 2;
    glcdMoveTo(r.X1, r.Y1);
    glcdPrint(text, InFlashStored);
}


void testOrientation(void) {

    uint8_t mem = glcd_MemCtrl;          // save glcd_MemCtrl
    glcdFlags_t flags = glcd_Flags;      // save glcd_Flags

    glcd_Flags.All = 0;                  // all bits off, no clipping, no fixed font and no autolinefeed

    glcdRect_t r;
    glcdSetRect(r, 1, 1, 64, 64);

    glcdClearScreen(0);
    glcdSelectFont(f9x14, 0);

    glcdSetOrientation(0);
    glcdSetColors(BLACK, NONE);
    glcdRectangle(r.X1, r.Y1, r.X2, r.Y2);
    glcdLine(r.X1, r.Y1, r.X2, r.Y2);
    glcdCircle(r.X1, r.Y1, 20);
    glcdMoveTo(r.X1 + 2, r.Y1 + 2);
    glcdPrintCenter(r, PSTR("0 Grad"), 1);

    glcdSetOrientation(1);
    glcdSetColors(RED, NONE);
    glcdRectangle(r.X1, r.Y1, r.X2, r.Y2);
    glcdLine(r.X1, r.Y1, r.X2, r.Y2);
    glcdCircle(r.X1, r.Y1, 20);
    glcdMoveTo(r.X1 + 2, r.Y1 + 2);
    glcdPrintCenter(r, PSTR("90 Grad"), 1);

    glcdSetOrientation(2);
    glcdSetColors(GREEN, NONE);
    glcdRectangle(r.X1, r.Y1, r.X2, r.Y2);
    glcdLine(r.X1, r.Y1, r.X2, r.Y2);
    glcdCircle(r.X1, r.Y1, 20);
    glcdMoveTo(r.X1 + 2, r.Y1 + 2);
    glcdPrintCenter(r, PSTR("180 Grad"), 1);

    glcdSetOrientation(3);
    glcdSetColors(YELLOW, NONE);
    glcdRectangle(r.X1, r.Y1, r.X2, r.Y2);
    glcdLine(r.X1, r.Y1, r.X2, r.Y2);
    glcdCircle(r.X1, r.Y1, 20);
    glcdMoveTo(r.X1 + 2, r.Y1 + 2);
    glcdPrintCenter(r, PSTR("270 Grad"), 1);

    glcdWait(2000);
    glcd_Flags = flags;
    glcdSetOrientation(mem);
}

void testBitmaps(void) {

    uint8_t Bitmap[512];
    glcdCoord_t width = glcd_Clip.X2 - glcd_Clip.X1 +1;
    glcdCoord_t height = glcd_Clip.Y2 - glcd_Clip.Y1 +1;
    int16_t i,j;

    for (i = 0; i < 512; i++) {
      Bitmap[i] = i * 2;
    }

    glcdSetAddr(glcd_Clip.X1, glcd_Clip.Y1, glcd_Clip.X2, glcd_Clip.Y2);

    for (i = 0; i < 256; i++) {
      for (j = 0; j < height; j++) {
        glcdDisplayBuffer(&Bitmap[i + j], width, 0);
      }
    }

}

void glcdRandomClipRect(void) {

    while (1) {
      glcdSetRect(glcd_Clip, lfsr(7) +1, lfsr(7) +1, lfsr(7) +1, lfsr(7) +1);
      if (glcd_Clip.X1 > SCREEN_RIGHT) {glcd_Clip.X1 = SCREEN_RIGHT;}
      if (glcd_Clip.X2 > SCREEN_RIGHT) {glcd_Clip.X2 = SCREEN_RIGHT;}
      if (glcd_Clip.Y1 > SCREEN_BOTTOM) {glcd_Clip.Y1 = SCREEN_BOTTOM;}
      if (glcd_Clip.Y2 > SCREEN_BOTTOM) {glcd_Clip.Y2 = SCREEN_BOTTOM;}
      if ((glcd_Clip.X1 < glcd_Clip.X2) & (glcd_Clip.Y1 < glcd_Clip.Y2)) {break;}
    }
}

int main(void) {

#define cnt  5


    glcdClearScreen(1);
    glcdDisplayOn();

    uint8_t o = 0;
    while (1) {

      glcdSetOrientation(o++);
      glcdClearScreen(1);
      glcd_Flags.Clipping = 0;
      glcdSetColors(BLACK, NONE);
      glcdRectangle(glcd_Clip.X1 -1, glcd_Clip.Y1 -1, glcd_Clip.X2 +1, glcd_Clip.Y2 +1);
      glcd_Flags.Clipping = 1;

      testRects(cnt);
      testLines2(cnt);
      testLines(cnt);
      testEllipses(cnt);
      testEllipses2(cnt);
      testSymbols(cnt);
      testBitmaps();

      testOrientation();

      glcdRandomClipRect();
    }
}

// 596, 2887

