/*

//	AVR Studio 6.1

//  siehe Unterlagen EA 2 Wire I2C-Mode

// 	hier: Atmega644   11059200 Mhz

//	Atmega644				DOGXL160
//----------------------------------------------------------------------

// 	LCD_RST  PC2			Display RST		PIN 29
// 	SDA  	 PC1			Display SSA		PIN 31 	4,7K an 3,3V
// 	SCL      PC0			Display SCK		PIN 32  4,7K an 3,3V
// 							Display D6		PIN 26  an 3,3V
//							Display BM0		PIN 30 	an 3,3V
// 							Display CD		PIN 27  an GND
//							Display A2		PIN 28 	an GND
//
//
//	Thanks  Jan Michel for to this library!
//	http://www.mikrocontroller.net/topic/144500#new
//	EA-DOGM Grafikdisplays inkl. Font-Generator  LCD-Library,  Version  0.95a

*/



#include "tools.h"


static FILE mystdout = FDEV_SETUP_STREAM(dogxl160_putchar, NULL, _FDEV_SETUP_WRITE); // bindet printf() ein

int main(void)
{
	
	
	stdout = &mystdout; // bindet printf() ein
	DDRC = ( 1<<0)|(1<<1); // Atmega644 SCL/SDA
	sei();
	i2c_init();
	delay_ms(100);
	lcd_init();
	delay_ms(100);
	
	lcd_set_font(FONT_PROP_16, NORMAL); 		// FONT_PROP_16
	lcd_moveto_xy(0,0); printf("Atmega644 11059200 Mhz");
	

	while (1)
	{
		
		lcd_set_font(FONT_PROP_16, NORMAL); 		// FONT_PROP_16
		lcd_moveto_xy(0,0); printf("Atmega644 11059200 Mhz");
		lcd_moveto_xy(4,0); printf("DOGXL160 mit I2C");
		
		lcd_set_font(FONT_PROP_8, NORMAL); 			// FONT_PROP_8
		lcd_moveto_xy(10,0); printf("I2C/TWI Takt: 400 KHz");
		lcd_moveto_xy(12,0); printf("Lib von Jan Michel");
		lcd_moveto_xy(14,0); printf("Atmel AVR Studio 6");
		lcd_moveto_xy(16,0); printf("Version 6.1");
		draw_partialpic_dogxl160((char*)uhr_bmp,10, 76);			// UHR-Bmp  ELECTRONIC ASSEMBLY LCD-Tools (grafik.c)
		
	}


	return (0);
}

int dogxl160_putchar(char c, FILE *stream) //  bindet printf() ein
{
	lcd_putc(c);
	return 0;
}



