#ifndef DCF_EC_H
#define DCF_EC_H

#include <inttypes.h>

typedef struct
{
    unsigned char second;
    unsigned char minute;
    unsigned char hour;
    unsigned char day_of_week;    // 1=MO ... 7=SO
    unsigned char day;
    unsigned char month;
    unsigned char year;           // Jahr % 100
    struct
    {
        unsigned char parity_M :1;
        unsigned char parity_H :1;
        unsigned char parity_D :1;
        unsigned char parity_Z :1;
        unsigned char :4;
    } flags;
} ectime_t;


#define SYNC_NBITS  (30)
#define SYNC_NSEC   (10)

typedef struct
{
    // Die eingesammelten DCF-Bits
    // [0] aktuelle  Minute
    // [1] letzte    Minute
    // [2] vorletzte Minute
    // Ein DCF-Bit kann 4 Werte annehmen und belegt 2 Bits im Speicher
    // 0 --> 0
    // 1 --> 1
    // 2 --> # Minuten-Marke
    // 3 --> . Wert unbekannt

    ectime_t time;

    uint8_t time_updated;

    uint8_t synced_sec;
    uint8_t synced_min;
    uint8_t synced_min0;


    uint8_t insert_sample;
    int8_t min0_synccnt;
    uint8_t min0;

    uint8_t sync_nbits;

    uint8_t sample_idx;
    uint8_t sec_idx;
    uint8_t v[6];
} dcf_ec_t;

extern void dcf_eval_sample (uint8_t sample);

extern dcf_ec_t dcf_ec;

#endif // DCF_EC_H
