#include <avr/io.h>
#include <avr/interrupt.h>

#include "dcf-ec.h"

/*
    Das Programm kann zB so bersetzt werden:

        avr-gcc -mmcu=atmega8 -Os main.c dcf-ec.o dcf-ec-asm.o uput.o -o main-dcf.elf
        avr-objcopy -j .text -j .data  -O ihex main-dcf.elf main-dcf.hex
*/


extern void uart_putc (char);

// Mach was mit dem ASCII-Zeichen c
void uart_putc (char c)
{
    (void) c;
}

// Besorge irgendwoher Sample: ein Wert, der durch
// Abfrage des DCF-Signals im 10ms-Raster erhalten wird/wurde.
// 0 -> Traeger ist abgesenkt (zB Sekunden-Anfang)
// 1 -> Traeger ist nicht abgesenkt
// sonstige Werte: es gibt nix Neues zu vermelden
// Du kannst zB eine ISR schreiben, die dcf_sample setzt.
uint8_t volatile dcf_sample = 0xff;

// Traeger abgesenkt      : 0
// Traeger nicht abgesenkt: 1
uint8_t get_dcf_sample_10ms (void)
{
    // Hier wird der Wert zurueckgeliefert, der zB in einer ISR
    // besorgt wurde.

    // IRQs abschalten
    cli();

    // Sample abholen und ungueltig machen
    uint8_t sample = dcf_sample;
    dcf_sample = 0xff;

    // ISRs reaktivieren
    sei();

    return sample;
}

int main (void)
{
    // Hauptschleife
    while (1)
    {
        // Wert von DCF-Empfaenger besorgen
        uint8_t wert = get_dcf_sample_10ms();

        if (wert < 2)
            dcf_eval_sample (wert);

        if (dcf_ec.synced_sec)
        {
            // wir sind Sekunden-synchron

            if (dcf_ec.synced_min)
            {
                // wir sind Minuten-synchron

                if (dcf_ec.time_updated)
                {
                    // es gibt Neuigkeiten
                    dcf_ec.time_updated = 0;

                    if (dcf_ec.time.minute != 0xff)
                    {
                        // Mach was mit der Minute
                    }
                } // time_updated
            } // synced_min
        } //synced_sec

    } // while (1)

    // dead code
}
