/*
 * This file is part of lcd library for ssd1306/sh1106 oled-display.
 *
 * lcd library for ssd1306/sh1106 oled-display is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or any later version.
 *
 * lcd library for ssd1306/sh1106 oled-display is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Diese Datei ist Teil von lcd library for ssd1306/sh1106 oled-display.
 *
 * lcd library for ssd1306/sh1106 oled-display ist Freie Software: Sie können es unter den Bedingungen
 * der GNU General Public License, wie von der Free Software Foundation,
 * Version 3 der Lizenz oder jeder späteren
 * veröffentlichten Version, weiterverbreiten und/oder modifizieren.
 *
 * lcd library for ssd1306/sh1106 oled-display wird in der Hoffnung, dass es nützlich sein wird, aber
 * OHNE JEDE GEWÄHRLEISTUNG, bereitgestellt; sogar ohne die implizite
 * Gewährleistung der MARKTFÄHIGKEIT oder EIGNUNG FÜR EINEN BESTIMMTEN ZWECK.
 * Siehe die GNU General Public License für weitere Details.
 *
 * Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
 * Programm erhalten haben. Wenn nicht, siehe <http://www.gnu.org/licenses/>.
 *
 *  lcd.h
 *
 *  Created by Michael Köhler on 22.12.16.
 *  Copyright 2016 Skie-Systems. All rights reserved.
 *
 *  lib for OLED-Display with ssd1306/sh1106-Controller
 *  first dev-version only for I2C-Connection
 *  at ATMega328P like Arduino Uno
 *
 *  at GRAPHICMODE lib needs SRAM for display
 *  DISPLAY-WIDTH * DISPLAY-HEIGHT + 2 bytes
 */

#ifndef OLED_H
#define OLED_H

#ifndef FALSE
#define FALSE 0
#define TRUE (!FALSE)
#endif


#if (__GNUC__ * 100 + __GNUC_MINOR__) < 303
#error "This library requires AVR-GCC 3.3 or later, update to newer AVR-GCC compiler !"
#endif

#ifndef __ARM_ARCH
#include <inttypes.h>
#include <avr/pgmspace.h>
#include "i2c_master.h"                            // library for I2C-communication
                                            // if you want to use other lib for I2C
                                            // edit i2c_xxx commands in this library
                                            // i2c_start(), i2c_byte(), i2c_stop()
#endif

#include <oled_config.h>

#define WHITE		0x01
#define BLACK		0x00


#ifdef __ARM_ARCH
/*
 * ARM-speciffic macros
 */
#define PROGMEM
#define pgm_read_byte(a)	(*(a))
#define PSTR(a)			(a)
#define lcd_puts_p	lcd_puts


void lcd_init(I2C_HandleTypeDef *hi2c);

#else	// AVR stuff
void lcd_init(uint8_t dispAttr);
void lcd_command(uint8_t cmd[], uint8_t size);				// transmit command to display
void lcd_data(uint8_t data[], uint16_t size);				// transmit data to display
#endif

void lcd_home(void);                        	// set cursor to 0,0
void lcd_invert(uint8_t invert);		// invert display
void lcd_set_contrast(uint8_t contrast);	// set contrast for display
void lcd_puts(const char* s);			// print string, \n-terminated, from ram on screen (TEXTMODE)
// or buffer (GRAPHICMODE)
void lcd_puts_p(const char* progmem_s);		// print string from flash on screen (TEXTMODE)
// or buffer (GRAPHICMODE)

void lcd_clrscr(void);				// clear screen (and buffer at GRFAICMODE)
void lcd_gotoxy(uint8_t x, uint8_t y);		// set curser at pos x, y. x means character,
						// y means line (page, refer lcd manual)
void lcd_putc(char c);				// print character on screen at TEXTMODE
						// at GRAPHICMODE print character to buffer
#if defined GRAPHICMODE
void lcd_drawPixel(uint8_t x, uint8_t y, uint8_t color);
void lcd_drawLine(uint8_t x1, uint8_t y1, uint8_t x2, uint8_t y2, uint8_t color);
void lcd_drawRect(uint8_t px1, uint8_t py1, uint8_t px2, uint8_t py2, uint8_t color);
void lcd_fillRect(uint8_t px1, uint8_t py1, uint8_t px2, uint8_t py2, uint8_t color);
void lcd_drawCircle(uint8_t center_x, uint8_t center_y, uint8_t radius, uint8_t color);
void lcd_fillCircle(uint8_t center_x, uint8_t center_y, uint8_t radius, uint8_t color);
void lcd_drawBitmap(uint8_t x, uint8_t y, const uint8_t picture[], uint8_t width, uint8_t height, uint8_t color);
void lcd_display(void);						// copy buffer to display RAM
#endif
#endif /*  OLED_H  */
