/*
 * oled_defines.h
 *
 *  Created on: 16.08.2018
 *      Author: Harry L.
 */

#ifndef OLED_DEFINES_H_
#define OLED_DEFINES_H_

/************************************************************************************
 * generic OLED-defines
 ************************************************************************************/

/*
 * I²C-address
 */
#define OLED_I2C_ADR  0x78

/*
 * uncomment if you want to use graphics
 * on AVR this increases RAM-consumption by 1028 byte
 * on STM32 graphic-mode is the default - this line has no effect
 */
#define GRAPHICMODE

/*
 * choose used Display-Controller
 * uncomment for SH1106 - default is SSD1306
 *
 */
// #define SH1106

/************************************************************************************
 *
 * DON'T CHANGE ANYTHING BELOW THIS LINE !!!
 *
 ************************************************************************************/

#ifdef SH1106
#define OLED_WIDTH	132				// SH1106
#define OLED_RAM_WIDTH	160				// bytes per line in OLED-RAM
#else
#define OLED_WIDTH	128				// SSD1306 is 128 x 64
#define OLED_RAM_WIDTH	128				// bytes per line in OLED-RAM
#endif

#define OLED_HEIGHT	64				// height in pixel

#define OLED_VLINES	(OLED_HEIGHT / 8)		// height in memory lines
#define DISPLAYSIZE	(OLED_WIDTH * OLED_VLINES)	// overall size in bytes


/*
 * Commands
 * See datasheet
 *
 */
#define OLED_DTA_PREFIX			0x40
#define OLED_CMD_PREFIX			0x80

#define OLED_SETCONTRAST 		0x81
#define OLED_DISPLAYALLON_RESUME 	0xA4
#define OLED_DISPLAYALLON 		0xA5
#define OLED_NORMALDISPLAY 		0xA6
#define OLED_INVERTDISPLAY 		0xA7
#define OLED_DISPLAYOFF 		0xAE
#define OLED_DISPLAYON 			0xAF

#define OLED_SETDISPLAYOFFSET 		0xD3
#define OLED_SETCOMPINS 		0xDA

#define OLED_SETVCOMDETECT 		0xDB

#define OLED_SETDISPLAYCLOCKDIV 	0xD5
#define OLED_SETPRECHARGE 		0xD9

#define OLED_SETMULTIPLEX 		0xA8

#define OLED_SETLOWCOLUMN 		0x00
#define OLED_SETHIGHCOLUMN 		0x10

#define OLED_SETSTARTLINE 		0x40

#define OLED_MEMORYMODE 		0x20
#define OLED_COLUMNADDR 		0x21
#define OLED_PAGEADDR   		0x22
#define OLED_PAGESTART			0xB0

#define OLED_COMSCANINC 		0xC0
#define OLED_COMSCANDEC 		0xC8

#define OLED_SEGREMAP 			0xA0

#define OLED_CHARGEPUMP 		0x8D

#define OLED_EXTERNALVCC 		0x01
#define OLED_SWITCHCAPVCC 		0x02

// Scrolling #defines
#define OLED_ACTIVATE_SCROLL 				0x2F
#define OLED_DEACTIVATE_SCROLL 				0x2E
#define OLED_SET_VERTICAL_SCROLL_AREA 			0xA3
#define OLED_RIGHT_HORIZONTAL_SCROLL 			0x26
#define OLED_LEFT_HORIZONTAL_SCROLL 			0x27
#define OLED_VERTICAL_AND_RIGHT_HORIZONTAL_SCROLL 	0x29
#define OLED_VERTICAL_AND_LEFT_HORIZONTAL_SCROLL 	0x2A

#ifdef __ARM_ARCH			// if running on ARM always use GRAPHICMODE
#define GRAPHICMODE			// STM32 always uses graphic-mode
#endif

#endif /* OLED_DEFINES_H_ */
