//------------------------------------------------------------------------------
//                                  _            _     
//                                 | |          | |    
//      ___ _ __ ___  ___ _   _ ___| |_ ___  ___| |__  
//     / _ \ '_ ` _ \/ __| | | / __| __/ _ \/ __| '_ \. 
//    |  __/ | | | | \__ \ |_| \__ \ ||  __/ (__| | | |
//     \___|_| |_| |_|___/\__, |___/\__\___|\___|_| |_|
//                         __/ |                       
//                        |___/    Engineering
//
// Filename:    uart.c
// Description: UART and Output Functions
//              
// Author:      Martin Steppuhn
// History:     15.09.2008
//------------------------------------------------------------------------------

/**** Includes ****************************************************************/

#include <avr/io.h>
#include "std_c.h"
#include "uart.h"

/**** Preprocessing directives (#define) **************************************/

/**** Type definitions (typedef) **********************************************/

/**** Global constants ********************************************************/

/**** Global variables ********************************************************/

/**** Local constants  ********************************************************/

/**** Local function prototypes ***********************************************/

/**** Local variables *********************************************************/


//------------------------------------------------------------------------------
// Name:      uart_init
// Function:  Init UART
//            
// Parameter: 
// Return:    
//------------------------------------------------------------------------------
void uart_init(void)
{
	UCSRC |= (1<<URSEL)|(3<<UCSZ0);					// Asynchron 8N1 
	UCSRB |= ( 1 << TXEN ) + ( 1 << RXEN );	// UART TX and RX enable
	UCSRC |= ( 1 << URSEL )|( 3<<UCSZ0 );	  // Asynchron 8N1

	//USART-Init 38400 Baud @ 8MHz 

	UBRRH  = 0;            			    // high
	UBRRL  = 12;           					// low		
}	     

//------------------------------------------------------------------------------
// Name:      uart_kbhit
// Function:  Test if received Char is in Buffer
//            
// Parameter: 
// Return:    
//------------------------------------------------------------------------------
bool uart_kbhit(void)
{
	return(UCSRA & (1<<RXC));
}

//------------------------------------------------------------------------------
// Name:      uart_putc
// Function:  
//            
// Parameter: 
// Return:    
//------------------------------------------------------------------------------
void uart_putc(uint8 c) 
{
	while ( !( UCSRA & (1<<UDRE)) );
	UDR = c;
}

//------------------------------------------------------------------------------
// Name:    	uart_puts  
// Function:  Send String
//            
// Parameter: 
// Return:    
//------------------------------------------------------------------------------
void uart_puts(uint8 *s) 
{
	while (*s)
	{
		uart_putc(*s);
		s++;
	}
}

//------------------------------------------------------------------------------
// Name:    	uart_puts_P  
// Function:  Send String
//            
// Parameter: 
// Return:    
//------------------------------------------------------------------------------
void uart_puts_P(const char *s )
{
    register char c;
    while((c = pgm_read_byte(s++))) uart_putc(c);
}

//------------------------------------------------------------------------------
// Name:     	uart_getc 
// Function:  Receive Char (WAIT !!!)
//            
// Parameter: 
// Return:    
//------------------------------------------------------------------------------
uint8 uart_getc(void)
{
  while ( !(UCSRA & (1<<RXC)) );
	return UDR;
}
