/*
@file    main.c
@brief   main file for FT8xx_Test project, version for AVR controller
@version 1.2
@date    2018-12-13
@author  Rudolph Riedel

@section History

1.0
- initial release

1.1
- added simple profiling

1.2
- adapted to M644, removed profiling, simplified

 */ 

#include <avr/io.h>
#include <avr/interrupt.h>

#include "EVE_commands.h"
#include "tft.h"

volatile uint8_t system_tick = 0;

/* executed every ~10 ms */
ISR (TIMER2_COMPA_vect)
{
	system_tick = 42;
}


void init_timer2(void)
{
	/* Timer2 - ~10 ms @ 16 Mhz cpu-clock */
	TCCR2B = 0x00;	/* stop */
	TCCR2A = 0x00;
	OCR2A = 156;	/* TOP - timer counts to TOP and generates IRQ */
	TIMSK2 |= (1<<OCIE2A);
	TCCR2B = (1<<WGM22) | (1<<CS22) | (1<<CS21) | (1<<CS20);	/* mode = CTC, prescaler = 1024 -> 15625 Hz */
}


void init_ports(void)
{
	DDRA = 0x00;	/* all pins set to input */
	PORTA = 0xff;	/* pullup-resistors activated */

    // PB2 CS           Output, high
    // PB3 Power Down   Output, low
    // PB4 SS des ATMega Output, high   nicht benutzt
    // PB5 MOSI         Output
    // PB7 SCK          Output

    // PB0  Input mit Pullup
    // PB1  Input mit Pullup
    // PB6  Input mit Pullup
	DDRB = (1<<PB2) | (1<<PB3) | (1<<PB4) | (1<<PB5) | (1<<PB7) ;  /* SS=PB4 (not used), SCK=PB7, MOSI=PB5, CS=PB2, PowerDown=PB3 set to Output, others to set to input */
	PORTB = (1<<PB2) | (1<<PB4);                                  /* SS (not used) set to high, CS set to high, PowerDown set to low, pullup-resistors for unused pins activated */


	DDRC = 0x00;
	PORTC = 0xff;

	DDRD = 0x00; 
	PORTD = 0xff;
}


void init_spi(void)
{
	SPCR = (1<<SPE) | (1<<MSTR) | (0<<SPR1) | (0<<SPR0);	/* SPI on, MSB first, Mode 0, Master, Fosc/4 -> 4MHz @ 16MHz CPU */
	SPSR = (1<<SPI2X);	/* Fosc/2 -> 8 MHz @ 16MHz CPU */
}


int main(void)
{
	cli();
	init_ports();
	init_timer2();
	init_spi();
	sei();

	TFT_init();

	while(1)
	{
		if(system_tick)
		{
			system_tick = 0;
			
			TFT_loop();
		}
	} /* while */
}
