-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
-- Title      : oszillator
-- Project    : 
-------------------------------------------------------------------------------
-- File       : oszi.vhd
-------------------------------------------------------------------------------
--
-- oszillator example
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------

--****************************************************************************--
package config_pack is
constant DELAY_SIZE : integer := 32;
end config_pack;


library ieee;
    use ieee.std_logic_1164.all;
    use ieee.numeric_std.all;
    
library work;
    use work.config_pack.all;

--****************************************************************************--
entity oszi is
port(
    rst         : in    std_logic;
    clk_out     : out   std_logic;
    enable      : in    std_logic_vector(DELAY_SIZE-1 downto 0)
);
end oszi;

--****************************************************************************--
architecture bhv of oszi is

signal clk_int  : std_logic;
signal overflow : std_logic_vector(DELAY_SIZE-1 downto 0);

attribute keep : string; 
attribute keep of clk_int:  signal is "true";
attribute keep of overflow: signal is "true";

--****************************************************************************--
begin

-- delay levels
gen: for i in DELAY_SIZE-2 downto 1 generate
    overflow(i-1) <= (clk_int and enable(i)) or overflow(i);
end generate;

-- last delay level
overflow(DELAY_SIZE-2) <= (clk_int and enable(DELAY_SIZE-1));

clk_int <= not (not rst and overflow(0));
clk_out <= not clk_int;

end bhv;


