-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
-- Title      : oszi_tb
-- Project    : 
-------------------------------------------------------------------------------
-- File       : oszi_tb.vhd
-------------------------------------------------------------------------------
--
-- oszi example
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------

library ieee;
    use ieee.std_logic_1164.all;
    use ieee.numeric_std.all;

library work;
    use work.config_pack.all;

--****************************************************************************--
entity oszi_tb is
end oszi_tb;

--****************************************************************************--
architecture tb of oszi_tb is


--============================================================================--
component oszi is
port(
    rst         : in    std_logic;
    clk_out     : out   std_logic;
    enable      : in    std_logic_vector(DELAY_SIZE-1 downto 0)
);
end component;

signal rst      : std_logic;
signal enb      : std_logic_vector(DELAY_SIZE-1 downto 0);
signal clk_out  : std_logic;

--****************************************************************************--
begin  -- tb

--============================================================================--
-- Wire up Device Under Test
--============================================================================--
uut: oszi
port map
(
    rst     => rst,
    enable  => enb,
    clk_out => clk_out
);

--============================================================================--
-- stimuli
--============================================================================--
p_stim: process
begin

    for i in 0 to DELAY_SIZE-1 loop

        -- defaults --
        enb     <= (others => '0');
        enb(i)  <= '1';

        -- reset --
        rst <= '1';
        wait for 200 ns;
        rst <= '0';
        wait for 1000 ns;

    end loop;

    wait;

end process;

end architecture tb;
