ENTRY(_reset)

MEMORY {
  /* memory map des LPC1549 */
  Flash (rx):  ORIGIN = 0x00000000, LENGTH = 0x00040000 /* 256kB */
  SRAM0 (rwx): ORIGIN = 0x02000000, LENGTH = 0x00009000 /*  36kB */
}

_stack_end = ORIGIN(SRAM0) + LENGTH(SRAM0);

SECTIONS {
  .text : {
    _text_section_start = .;
    KEEP(*(._vectors))
    *(.text)
    *(.text*)
    *(.rodata .rodata.* .constdata .constdata.*)
    _text_section_end = .;
  } > Flash
  
  . = ALIGN(4);
  
  .bss : {
    _bss_section_start = .;
    *(.bss)
    *(.bss*)
    _bss_section_end = .;
  } > SRAM0
    
  . = ALIGN(4);
    
  .data : {
    _data_section_start = .;
    *(.data)
    *(.data*)
    _data_section_end = .;
  } > SRAM0 AT > Flash
}
