extern int main(void);
extern void _reset(void);
extern void _stack_end(void);

#define ALIAS(f) __attribute__ ((weak, alias (#f)))

/* Standard-Handler fuer nicht implementierte Interrupt-Service-Routinen */
void Default_Interrupt_Handler(void) __attribute__ ((weak));

void NMI_Handler(void) ALIAS(Default_Interrupt_Handler);
void HardFault_Handler(void) ALIAS(Default_Interrupt_Handler);
void MemManage_Handler(void) ALIAS(Default_Interrupt_Handler);
void BusFault_Handler(void) ALIAS(Default_Interrupt_Handler);
void UsageFault_Handler(void) ALIAS(Default_Interrupt_Handler);
void SVC_Handler(void) ALIAS(Default_Interrupt_Handler);
void DebugMon_Handler(void) ALIAS(Default_Interrupt_Handler);
void PendSV_Handler(void) ALIAS(Default_Interrupt_Handler);
void SysTick_Handler(void) ALIAS(Default_Interrupt_Handler);

void WDT_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void BOD_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void FMC_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void EEPROM_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void DMA_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void GINT0_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void GINT1_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void PIN_INT0_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void PIN_INT1_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void PIN_INT2_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void PIN_INT3_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void PIN_INT4_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void PIN_INT5_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void PIN_INT6_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void PIN_INT7_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void RIT_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void SCT0_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void SCT1_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void SCT2_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void SCT3_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void MRT_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void UART0_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void UART1_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void UART2_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void I2C0_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void SPI0_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void SPI1_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void CAN_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void USB_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void USB_FIQHandler(void) ALIAS(Default_Interrupt_Handler);
void USBWakeup_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void ADC0A_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void ADC0B_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void ADC0_THCMP_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void ADC0_OVR_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void ADC1A_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void ADC1B_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void ADC1_THCMP_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void ADC1_OVR_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void DAC_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void ACMP0_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void ACMP1_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void ACMP2_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void ACMP3_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void QEI_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void RTC_ALARM_IRQHandler(void) ALIAS(Default_Interrupt_Handler);
void RTC_WAKE_IRQHandler(void) ALIAS(Default_Interrupt_Handler);

extern void (* const _vectors[])(void) __attribute__ ((used, section("._vectors")));
void (* const _vectors[])(void) = {
    &_stack_end,
    _reset,
    NMI_Handler,                       // The NMI handler
    HardFault_Handler,                 // The hard fault handler
    MemManage_Handler,                 // The MPU fault handler
    BusFault_Handler,                  // The bus fault handler
    UsageFault_Handler,                // The usage fault handler
    0,                                 // LPC MCU Checksum
    0,                                 // Reserved
    0,                                 // Reserved
    0,                                 // Reserved
    SVC_Handler,                       // SVCall handler
    DebugMon_Handler,                  // Debug monitor handler
    0,                                 // Reserved
    PendSV_Handler,                    // The PendSV handler
    SysTick_Handler,                   // The SysTick handler

    WDT_IRQHandler,                    //  0 - Windowed watchdog timer
    BOD_IRQHandler,                    //  1 - BOD
    FMC_IRQHandler,                    //  2 - Flash controller
    EEPROM_IRQHandler,                 //  3 - EEPROM controller
    DMA_IRQHandler,                    //  4 - DMA
    GINT0_IRQHandler,                  //  5 - GINT0
    GINT1_IRQHandler,                  //  6 - GINT1
    PIN_INT0_IRQHandler,               //  7 - PIO INT0
    PIN_INT1_IRQHandler,               //  8 - PIO INT1
    PIN_INT2_IRQHandler,               //  9 - PIO INT2
    PIN_INT3_IRQHandler,               // 10 - PIO INT3
    PIN_INT4_IRQHandler,               // 11 - PIO INT4
    PIN_INT5_IRQHandler,               // 12 - PIO INT5
    PIN_INT6_IRQHandler,               // 13 - PIO INT6
    PIN_INT7_IRQHandler,               // 14 - PIO INT7
    RIT_IRQHandler,                    // 15 - RIT
    SCT0_IRQHandler,                   // 16 - State configurable timer
    SCT1_IRQHandler,                   // 17 - State configurable timer
    SCT2_IRQHandler,                   // 18 - State configurable timer
    SCT3_IRQHandler,                   // 19 - State configurable timer
    MRT_IRQHandler,                    // 20 - Multi-Rate Timer
    UART0_IRQHandler,                  // 21 - UART0
    UART1_IRQHandler,                  // 22 - UART1
    UART2_IRQHandler,                  // 23 - UART2
    I2C0_IRQHandler,                   // 24 - I2C0 controller
    SPI0_IRQHandler,                   // 25 - SPI0 controller
    SPI1_IRQHandler,                   // 26 - SPI1 controller
    CAN_IRQHandler,                    // 27 - C_CAN0
    USB_IRQHandler,                    // 28 - USB IRQ
    USB_FIQHandler,                    // 29 - USB FIQ
    USBWakeup_IRQHandler,              // 30 - USB wake-up
    ADC0A_IRQHandler,                  // 31 - ADC0 sequence A completion
    ADC0B_IRQHandler,                  // 32 - ADC0 sequence B completion
    ADC0_THCMP_IRQHandler,             // 33 - ADC0 threshold compare
    ADC0_OVR_IRQHandler,               // 34 - ADC0 overrun
    ADC1A_IRQHandler,                  // 35 - ADC1 sequence A completion
    ADC1B_IRQHandler,                  // 36 - ADC1 sequence B completion
    ADC1_THCMP_IRQHandler,             // 37 - ADC1 threshold compare
    ADC1_OVR_IRQHandler,               // 38 - ADC1 overrun
    DAC_IRQHandler,                    // 39 - DAC
    ACMP0_IRQHandler,                  // 40 - Analog Comparator 0
    ACMP1_IRQHandler,                  // 41 - Analog Comparator 1
    ACMP2_IRQHandler,                  // 42 - Analog Comparator 2
    ACMP3_IRQHandler,                  // 43 - Analog Comparator 3
    QEI_IRQHandler,                    // 44 - QEI
    RTC_ALARM_IRQHandler,              // 45 - RTC alarm
    RTC_WAKE_IRQHandler,               // 46 - RTC wake-up
};

void _reset(void) {
    /* hole die im Linker-Skript erstellen globalen Variablen */
    extern unsigned int _data_section_start;
    extern unsigned int _data_section_end;
    extern unsigned int _text_section_end;
    extern unsigned int _bss_section_start;
    extern unsigned int _bss_section_end;

    unsigned int *src;
    unsigned int *dest;
    /* jetzt überschreiben wir alle Varaiblen in der .bss-Section mit 0 */
    dest = &_bss_section_start;
    while (dest < &_bss_section_end) {
        *dest++ = 0;
    }
    
    /* jetzt initialisieren wir alle .data-Variablen mit den */
    /* Daten, die im Flash abgelegt wurden */
    src = &_text_section_end;
    dest = &_data_section_start;
    while (dest < &_data_section_end) {
        *dest++ = *src++;
    }
    
    /* und nun folgt endlich der Aufruf von main() */
    /* der return-wert wird nicht verwendet, man könnte also main als */
    /* void main(void) definieren und deklarieren, spart uU etwas Speicher */
    main();
    
    /* falls main() zurückkehrt: gehe in eine Endlosschleife */
    while(1) ;
}

void Default_Interrupt_Handler(void) {while(1);}
