/*
 ============================================================================
 Name        : main.c
 Author      : 
 Version     :
 Copyright   : Your copyright notice
 Description : Hello World in C
 ============================================================================
 */

#include <stdio.h>

/*
 *
 * Print a greeting message on standard output and exit.
 *
 * On embedded platforms this might require semi-hosting or similar.
 *
 * For example, for toolchains derived from GNU Tools for Embedded,
 * to enable semi-hosting, the following was added to the linker:
 *
 * --specs=rdimon.specs -Wl,--start-group -lgcc -lc -lc -lm -lrdimon -Wl,--end-group
 *
 * Adjust it for other toolchains.
 *
 */
void wait_cycles(int N)
{
    volatile static int c = 0;
    for(int i = 0; i < N; i++)
    {
        c++;
    }
}
int
main(void)
{
    /* enable GPIO0 (bit 14) and IOCON (bit 13) clock in the SYSAHBCLKCTRL0 register */
    *(volatile uint32_t*)0x400740C4 |= (1U << 13) | (1U << 14);
    /* setup PIO0_25: GPIO (bits [2:0]), Pull-Up (bits [4:3]), digital mode (bit 7) */
    *(volatile uint32_t*)(0x400F8000 + 25 * 0x4) = (0x2U << 3);
    /* set PIO0_25 to output using the GPIO->DIR0 register */
    *(volatile uint32_t*)(0x1C000000 + 0x2000 + 0) |= (1U << 25);

    while(1)
    {
        /* toggle LED at PIO0_25 using GPIO->NOT0 register */
        *(volatile uint32_t*)(0x1C000000 + 0x2300 + 0) = (1U << 25);

        wait_cycles(100000);
    }

    return 0;
}
