// =====================================================
//
//   miniLA_win - About box
//
//   (c) miniLA Team
//
// =====================================================
//
// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this package; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.


unit dlgAbout;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, FMXUtils, ImgList;

type
  TAboutBox = class(TForm)
    Panel1: TPanel;
    ProductName: TLabel;
    lbVersion: TLabel;
    Comments: TLabel;
    OKButton: TButton;
    ImageList1: TImageList;
    Image1: TImage;
    Timer1: TTimer;
    Label2: TLabel;
    Memo1: TMemo;
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CommentsClick(Sender: TObject);
  private
    { Private declarations }
    i:integer;
  public
    { Public declarations }
  end;

var
  AboutBox: TAboutBox;

implementation

uses uLATypes;

{$R *.DFM}

procedure TAboutBox.FormCreate(Sender: TObject);
begin
  i:=0;
end;

procedure TAboutBox.FormActivate(Sender: TObject);
begin
  Timer1.Enabled:=true;
  i:=-8;
  lbVersion.Caption := 'Version '+ProgVersion+' (FW'+FWVersion+')';
end;

procedure TAboutBox.FormDeactivate(Sender: TObject);
begin
  Timer1.Enabled:=false;
end;

procedure TAboutBox.Timer1Timer(Sender: TObject);
begin
  if i<1 then
    ImageList1.GetBitmap(0,Image1.Picture.Bitmap)
  else
    ImageList1.GetBitmap(i,Image1.Picture.Bitmap);
  Image1.Repaint;
  inc(i);
  if i>ImageList1.Count-1 then
    i:=-30;
end;

procedure TAboutBox.CommentsClick(Sender: TObject);
begin
  ExecuteFile('http://minila.sourceforge.net','','',SW_SHOW);
end;

end.

