// =====================================================
//
//   miniLA_win - Decoder Display routines
//
//   (c) miniLA Team
//
// =====================================================
//
// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this package; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
unit dlgDecDisplay;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TfrmDecDisplay = class(TForm)
    lbResults: TListBox;
    btnClose: TBitBtn;
    Label1: TLabel;
    rbCursor1: TRadioButton;
    rbCursor2: TRadioButton;
    Panel1: TPanel;
    btnSave: TBitBtn;
    SaveDialog: TSaveDialog;
    procedure FormResize(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure lbResultsDblClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure lbResultsKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDecDisplay: TfrmDecDisplay;

implementation

{$R *.dfm}

uses
   dlgMain;

//==========================================================
procedure TfrmDecDisplay.FormResize(Sender: TObject);
//==========================================================
begin
   lbResults.Height := frmDecDisplay.ClientHeight - 40;
end;


//==========================================================
procedure TfrmDecDisplay.lbResultsDblClick(Sender: TObject);
//==========================================================
var
   curpos	: integer;
   i		: integer;
   sel		: integer;
begin
   sel := 0;
   while not(lbResults.Selected[sel]) and (sel<lbResults.Count) do
      inc(sel);
   if sel>=lbResults.Count then
      exit;

   i := 1;
   while lbResults.Items.Strings[sel][i] in ['-','0'..'9'] do
      inc(i);
   if i=1 then
      exit;

   try
      curpos := StrToInt(Copy(lbResults.Items.Strings[sel],1,i-1));
   except
      exit;
   end;

   if rbCursor1.Checked then
    begin
      frmMain.LogPanel.SetCursorPosition(0,curpos+frmMain.LogPanel.Cursors[2].Position);
      frmMain.ScrollBar2.SetCursorPosition(0,curpos+frmMain.LogPanel.Cursors[2].Position);
      if not frmMain.LogPanel.Cursors[0].Visible then
         frmMain.LogPanel.SetCenterPosition(curpos+frmMain.LogPanel.Cursors[2].Position);
    end
   else
    begin
      frmMain.LogPanel.SetCursorPosition(1,curpos+frmMain.LogPanel.Cursors[2].Position);
      frmMain.ScrollBar2.SetCursorPosition(1,curpos+frmMain.LogPanel.Cursors[2].Position);
      if not frmMain.LogPanel.Cursors[1].Visible then
         frmMain.LogPanel.SetCenterPosition(curpos+frmMain.LogPanel.Cursors[2].Position);
    end;
end;

//==========================================================
procedure TfrmDecDisplay.lbResultsKeyPress(Sender: TObject; var Key: Char);
//==========================================================
begin
   if Key = #13 then
      lbResultsDblClick(Sender);
end;


//==========================================================
procedure TfrmDecDisplay.btnCloseClick(Sender: TObject);
//==========================================================
begin
   Hide;
end;

//==========================================================
procedure TfrmDecDisplay.btnSaveClick(Sender: TObject);
//==========================================================
begin
  if SaveDialog.Execute then
   begin
    frmMain.StatusBar1.Panels[5].Text := 'Saving data ...';
    frmMain.StatusBar1.Repaint;

    lbResults.Items.SaveToFile(SaveDialog.Filename);

    frmMain.StatusBar1.Panels[5].Text := '';
    frmMain.StatusBar1.Repaint;
   end;

end;


end.
