// =====================================================
//
//   miniLA_win - Hardware setup
//
//   (c) miniLA Team
//
// =====================================================
//
// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this package; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.


unit dlgHWSetup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Spin, ExtCtrls;

type
  TfrmHWSetup = class(TForm)
    btnCancel: TBitBtn;
    btnOK: TBitBtn;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edFreq: TEdit;
    lbSubversion: TLabel;
    cbSubversion: TComboBox;
    cbFallingEdge: TCheckBox;
    btnLPTSetup: TButton;
    btnUSBSetup: TButton;
    GroupBox2: TGroupBox;
    rbLPTPort: TRadioButton;
    rbUSBPort: TRadioButton;
    procedure btnOKClick(Sender: TObject);
    procedure cbSubversionChange(Sender: TObject);
    procedure btnLPTSetupClick(Sender: TObject);
    procedure btnUSBSetupClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure rbInterfaceClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmHWSetup: TfrmHWSetup;

implementation

uses dlgMain, uCommunication, dlgIO_LPT, dlgIO_USB;
{$R *.DFM}


//=================================================================
procedure TfrmHWSetup.FormActivate(Sender: TObject);
//=================================================================
begin
   cbSubversion.ItemIndex := frmMain.Analyzer.Subversion;
   cbFallingEdge.Checked := frmMain.Analyzer.FallingEdge;
   if frmMain.Analyzer.Connection = LPT then
    begin
      rbLPTPort.Checked := true;
      rbUSBPort.Checked := false;
    end
   else
    begin
      rbLPTPort.Checked := false;
      rbUSBPort.Checked := true;
    end;
   edFreq.Text := FloatToStr(frmMain.Analyzer.Frequency/1e6);

   cbFallingEdge.Enabled:=not(frmMain.Analyzer.StateAnalysis);
   lbSubversion.Enabled:=not(frmMain.Analyzer.StateAnalysis);
   cbSubversion.Enabled:=not(frmMain.Analyzer.StateAnalysis);
end;


//=================================================================
procedure TfrmHWSetup.cbSubversionChange(Sender: TObject);
//=================================================================
begin
   case cbSubversion.ItemIndex of
      0:begin // 100 MHz
	   edFreq.Text := '100';
	end;
      1:begin // 80 MHz
	   edFreq.Text := '80';
	end;
      2:begin // 40 MHz
	   edFreq.Text := '40';
	end;
      3:begin // 20 MHz
	   edFreq.Text := '20';
	end;
   end;
end;


//=================================================================
procedure TfrmHWSetup.rbInterfaceClick(Sender: TObject);
//=================================================================
begin
   btnLPTSetup.Enabled := rbLPTPort.Checked;
   btnUSBSetup.Enabled := rbUSBPort.Checked;
end;

//=================================================================
procedure TfrmHWSetup.btnLPTSetupClick(Sender: TObject);
//=================================================================
begin
   frmIO_LPT.ShowModal;
end;

//=================================================================
procedure TfrmHWSetup.btnUSBSetupClick(Sender: TObject);
//=================================================================
begin
   frmIO_USB.ShowModal;
end;

//=================================================================
procedure TfrmHWSetup.btnOKClick(Sender: TObject);
//=================================================================
var
   bad_dec_sep  : char;
   bad_dec_sep_p: byte;
   freq_t       : string;
   freq		: real;
   err_msg	: string;
begin
   err_msg := '';

   // set frequency
   if DecimalSeparator = '.' then
      bad_dec_sep := ','
   else
      bad_dec_sep := '.';

   // fix incorrect decimal separator
   freq_t := edFreq.Text;
   repeat
      bad_dec_sep_p :=pos(bad_dec_sep, freq_t);
      if bad_dec_sep_p <> 0 then
         freq_t[bad_dec_sep_p] := DecimalSeparator;
   until bad_dec_sep_p=0;
   edFreq.Text := freq_t;

   try
      freq := StrToFloat(freq_t) * 1e6;
   except
      on EConvertError do
         err_msg := 'frequency';
   end;

   if cbSubversion.ItemIndex<0 then
      err_msg := 'subversion';

   if err_msg <> '' then
    begin
      MessageDlg('Invalid '+err_msg, mtError,[mbOK],0);
      exit;
    end;

   frmMain.Analyzer.Frequency := freq;
   frmMain.Analyzer.Subversion := cbSubversion.ItemIndex;
   frmMain.Analyzer.FallingEdge := cbFallingEdge.Checked;

   if rbLPTPort.Checked then
      frmMain.Analyzer.Connection := lpt
   else
      frmMain.Analyzer.Connection := usb;

   Hide;
   frmMain.Analyzer.Init;				// re-initialize IO
   ModalResult := mrOK;
end;




end.
