// =====================================================
//
//   miniLA_win - Set zoom dialog
//
//   (c) miniLA Team
//
// =====================================================
//
// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this package; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.


unit dlgSetZoomPos;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Spin,
  uUtils;

type
  TfrmSetZoomPos = class(TForm)
    SpinEdit1: TSpinEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    btnApply: TBitBtn;
    procedure btnApplyClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSetZoomPos: TfrmSetZoomPos;

implementation

uses dlgMain;

{$R *.DFM}

procedure TfrmSetZoomPos.FormActivate(Sender: TObject);
begin
   SpinEdit1.SetFocus;
end;

procedure TfrmSetZoomPos.btnApplyClick(Sender: TObject);
begin
   if Caption='Set zoom' then
      frmMain.LogPanel.SetZoom(IntExp2(frmSetZoomPos.SpinEdit1.Value-1)*100)
   else if Caption='Set position' then
      frmMain.LogPanel.SetPosition(round( frmSetZoomPos.SpinEdit1.Value
      				        +frmMain.LogPanel.Cursors[2].Position
                                         -(frmMain.LogPanel.Display.Width-10)*frmMain.LogPanel.Display.ZoomRatio/2));
end;




end.
