// =====================================================
//
//   miniLA_win - Colors setup
//
//   (c) miniLA Team
//
// =====================================================
//
// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this package; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.


unit dlgColors;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ExtCtrls;

type
  TfrmColors = class(TForm)
    btnCursor1: TButton;
    btnCursor2: TButton;
    btnTrigger: TButton;
    btnCross: TButton;
    btnGroups: TButton;
    spCursor1: TShape;
    spCursor2: TShape;
    spTrigger: TShape;
    spCross: TShape;
    spGroups: TShape;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    btnBackground: TButton;
    spBackground: TShape;
    ColorDialog1: TColorDialog;
    GroupBox1: TGroupBox;
    btnChannels: TButton;
    spChannels: TShape;
    cbApply: TCheckBox;
    btnDefault: TButton;
    Label7: TLabel;
    spScale: TShape;
    btnScale: TButton;
    Label8: TLabel;
    spGrid: TShape;
    btnGrid: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnCursor1Click(Sender: TObject);
    procedure btnDefaultClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    { Private declarations }
    Shapes:array[0..8] of TShape;
    Buttons:array[0..8] of TButton;
  public
    { Public declarations }
  end;

var
  frmColors: TfrmColors;

implementation

uses dlgMain, dlgChannel, uLATypes;

{$R *.DFM}

//=================================================================
procedure TfrmColors.FormCreate(Sender: TObject);
//=================================================================
begin
  Shapes[0]:=spCursor1;
  Shapes[1]:=spCursor2;
  Shapes[2]:=spTrigger;
  Shapes[3]:=spCross;
  Shapes[4]:=spGroups;
  Shapes[5]:=spBackground;
  Shapes[6]:=spChannels; spChannels.Brush.Color:=(51*256+185)*256+85;
  Shapes[7]:=spScale;
  Shapes[8]:=spGrid;
  Buttons[0]:=btnCursor1;
  Buttons[1]:=btnCursor2;
  Buttons[2]:=btnTrigger;
  Buttons[3]:=btnCross;
  Buttons[4]:=btnGroups;
  Buttons[5]:=btnBackground;
  Buttons[6]:=btnChannels;
  Buttons[7]:=btnScale;
  Buttons[8]:=btnGrid;
end;

//=================================================================
procedure TfrmColors.FormActivate(Sender: TObject);
//=================================================================
begin
  spCursor1.Brush.Color:=frmMain.LogPanel.Cursors[0].ColorC;
  spCursor2.Brush.Color:=frmMain.LogPanel.Cursors[1].ColorC;
  spTrigger.Brush.Color:=frmMain.LogPanel.Cursors[2].ColorC;
  spCross.Brush.Color:=frmMain.LogPanel.Cursors[3].ColorC;
  spGroups.Brush.Color:=frmMain.LogPanel.Display.GroupColor;
  spBackground.Brush.Color:=frmMain.LogPanel.Display.BackColor;
  spChannels.Brush.Color:=frmChannel.DefaultSigColor;
  spScale.Brush.Color:=frmMain.LogPanel.Display.ScaleColor;
  spGrid.Brush.Color:=frmMain.LogPanel.Display.GridColor;
end;


//=================================================================
procedure TfrmColors.btnCursor1Click(Sender: TObject);
//=================================================================
var i:byte;
begin
  i:=0;
  while i<9 do begin
    if Sender=Buttons[i] then break;
    inc(i);
  end;
  if i=9 then exit;
  ColorDialog1.Color:=Shapes[i].Brush.Color;
  if ColorDialog1.Execute then
    Shapes[i].Brush.Color:=ColorDialog1.Color;
end;

//=================================================================
procedure TfrmColors.btnDefaultClick(Sender: TObject);
//=================================================================
const Colors:array[0..8] of TColor=(clBlue,clBlue,clRed,clAqua,(51*256+185)*256+85,clBlack,(51*256+185)*256+85,clWhite, $00444444);
var i:integer;
begin
  for i:=0 to 8 do
    Shapes[i].Brush.Color:=Colors[i];
end;


//=================================================================
procedure TfrmColors.btnOKClick(Sender: TObject);
//=================================================================
var i:integer;
begin
    frmMain.LogPanel.Cursors[0].ColorC:=spCursor1.Brush.Color;
    frmMain.Scrollbar2.SetCursorColor(0,spCursor1.Brush.Color);
    frmMain.LogPanel.Cursors[1].ColorC:=spCursor2.Brush.Color;
    frmMain.Scrollbar2.SetCursorColor(1,spCursor2.Brush.Color);
    frmMain.LogPanel.Cursors[2].ColorC:=spTrigger.Brush.Color;
    frmMain.Scrollbar2.SetCursorColor(2,spTrigger.Brush.Color);
    frmMain.LogPanel.Cursors[3].ColorC:=spCross.Brush.Color;
    frmMain.LogPanel.Cursors[4].ColorC:=spCross.Brush.Color;
    frmMain.LogPanel.Display.SetColors(spBackground.Brush.Color,
	      		               spGroups.Brush.Color,
			               spScale.Brush.Color,
                                       spGrid.Brush.Color);
    frmMain.sgSigNames.Color := spBackground.Brush.Color;
    frmMain.sgSigValues.Color := spBackground.Brush.Color;
    frmChannel.DefaultSigColor:=spChannels.Brush.Color;
    if cbApply.Checked then begin
      for i:=0 to MaxChannels-1 do
	frmChannel.ChannelInfo[i].Edit.Font.Color:=spChannels.Brush.Color;
      frmMain.LogPanel.Display.Recalc(0,0,
                                      frmMain.LogPanel.Display.Width,
      				      frmMain.LogPanel.Display.Height,
                                      frmMain.LogPanel.Display.Bitmap.Canvas);
      frmMain.LogPanel.Repaint;
      frmChannel.btnOKClick(self);
    end;

    frmMain.LogPanel.UpdateCursors;
    frmMain.sgSigNames.Repaint;
    frmMain.sgSigValues.Repaint;
    frmMain.StatusBar1.Repaint;
end;

end.
