// =====================================================
//
//   miniLA_win - Post status display form
//
//   (c) miniLA Team
//
// =====================================================
//
// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this package; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.


unit dlgPortStatus;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,
  uUtils,
  uLATypes;

type
  TfrmPortStatus = class(TForm)
    Label1: TLabel;
    lbPortValue: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    lbPortValue0: TLabel;
    lbPortValue1: TLabel;
    lbPortValue2: TLabel;
    lbPortValue3: TLabel;
    Timer1: TTimer;
    procedure FormActivate(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmPortStatus: TfrmPortStatus;

implementation

uses dlgMain;

{$R *.dfm}

procedure TfrmPortStatus.FormActivate(Sender: TObject);
begin
   frmMain.ViewPort1.Checked := true;
   Timer1Timer(self);
   Timer1.Enabled := true;
end;

procedure TfrmPortStatus.FormHide(Sender: TObject);
begin
   frmMain.ViewPort1.Checked := false;
   Timer1.Enabled := false;
end;

procedure TfrmPortStatus.Timer1Timer(Sender: TObject);
var
   portval	: cardinal;
begin
   if frmMain.Analyzer.State = tsNotDetected then
    begin
      lbPortValue.Caption  := '--------';
      lbPortValue0.Caption := '--------';
      lbPortValue1.Caption := '--------';
      lbPortValue2.Caption := '--------';
      lbPortValue3.Caption := '--------';
    end
   else
    begin
      portval := frmMain.Analyzer.PortValue;
      if not frmMain.Analyzer.StateAnalysis then		// timeanalysis
       begin
         lbPortValue.Caption  := IntToHex(portval,32);
         lbPortValue0.Caption := IntToBin(portval and $FF, 8, false);
         lbPortValue1.Caption := IntToBin((portval shr 8) and $FF, 8, false);
         lbPortValue2.Caption := IntToBin((portval shr 16) and $FF, 8, false);
         lbPortValue3.Caption := IntToBin((portval shr 24) and $FF, 8, false);
       end
      else							// stateanalysis
       begin
         lbPortValue.Caption  := '    '+IntToHex(portval and $FFFF,16);
         lbPortValue0.Caption := IntToBin(portval and $FF, 8, false);
         lbPortValue1.Caption := IntToBin((portval shr 8) and $FF, 8, false);
         lbPortValue2.Caption := '--------';
         lbPortValue3.Caption := '--------';
       end
    end;

end;

end.
