// =====================================================
//
//   miniLA_win - General setup
//
//   (c) miniLA Team
//
// =====================================================
//
// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this package; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.


// TODO:
// autosave window position
// autosave layout
// save immediately

unit dlgSetup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TfrmSetup = class(TForm)
    GroupBox1: TGroupBox;
    cbSaveWinPos: TCheckBox;
    cbSaveHWConfig: TCheckBox;
    cbSaveLayout: TCheckBox;
    btnOK: TBitBtn;
    BitBtn2: TBitBtn;
    cbSaveImmediately: TCheckBox;
    cbSaveLayoutWFile: TCheckBox;
    cbLoadLayoutWFile: TCheckBox;
    cbConfirmBefore: TCheckBox;
    cbShowGrid: TCheckBox;
    procedure cbLoadLayoutWFileClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    SaveLayoutWFile : boolean;
    LoadLayoutWFile : boolean;
    ConfirmBefore : boolean;
    ShowGrid : boolean;
  end;
var
  frmSetup: TfrmSetup;

implementation

uses uINIFile, dlgMain;
{$R *.DFM}

//=================================================================
procedure TfrmSetup.FormCreate(Sender: TObject);
//=================================================================
begin
   SaveLayoutWFile := INIFile.ReadBool('SETUP', 'SAVELAYOUTWFILE', true);
   LoadLayoutWFile := INIFile.ReadBool('SETUP', 'LOADLAYOUTWFILE', true);
   ConfirmBefore := INIFile.ReadBool('SETUP', 'CONFIRMBEFORE', true);
   ShowGrid := INIFile.ReadBool('SETUP', 'SHOWGRID', true);
end;

//=================================================================
procedure TfrmSetup.FormDestroy(Sender: TObject);
//=================================================================
begin
   INIFile.WriteBool('SETUP', 'SAVELAYOUTWFILE', SaveLayoutWFile);
   INIFile.WriteBool('SETUP', 'LOADLAYOUTWFILE', LoadLayoutWFile);
   INIFile.WriteBool('SETUP', 'CONFIRMBEFORE', ConfirmBefore);
   INIFile.WriteBool('SETUP', 'SHOWGRID', ShowGrid);
end;

//=================================================================
procedure TfrmSetup.FormActivate(Sender: TObject);
//=================================================================
begin
  cbSaveLayoutWFile.Checked := SaveLayoutWFile;
  cbLoadLayoutWFile.Checked := LoadLayoutWFile;
  cbConfirmBefore.Checked := ConfirmBefore;
  cbShowGrid.Checked := ShowGrid;
end;


//=================================================================
procedure TfrmSetup.cbLoadLayoutWFileClick(Sender: TObject);
//=================================================================
begin
  cbConfirmBefore.Enabled:=cbLoadLayoutWFile.Checked;
end;

//=================================================================
procedure TfrmSetup.btnOKClick(Sender: TObject);
//=================================================================
begin
   SaveLayoutWFile := cbSaveLayoutWFile.Checked;
   LoadLayoutWFile := cbLoadLayoutWFile.Checked;
   ConfirmBefore := cbConfirmBefore.Checked;
   ShowGrid := cbShowGrid.Checked;

   // refresh display
   frmMain.LogPanel.Display.Recalc(0,0,
                                   frmMain.LogPanel.Display.Width,
                                   frmMain.LogPanel.Display.Height,
                                   frmMain.LogPanel.Display.Bitmap.Canvas);
   frmMain.LogPanel.Repaint;
end;

end.


