// =====================================================
//
//   miniLA_win - Decoder utilities
//
//   (c) miniLA Team
//
// =====================================================
//
// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this package; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.


// Object ChannelSel is used for selection of channels using Combo
// components.

unit uDecUtils;
interface

uses StdCtrls, SysUtils, Classes, Graphics;

type
   TChannelSel=class(TList)
    protected
      FMultiSelect	: boolean;
    public
      function Add(AObject: TObject): Integer;
      procedure SelCheck(Sender: TObject);
      function GetChannelNumber(Combo :TComboBox):integer;
      destructor Destroy; override;

      property MultiSelect: boolean read FMultiSelect;
    end;

implementation
uses
   uLATypes,
   dlgChannel;


{ TcbChannel }

//==========================================================
function TChannelSel.Add(AObject: TObject): Integer;
//==========================================================
var
   i		: word;
   sel		: integer;
   chnum	: integer;
begin
   Result := inherited Add(AObject);
   chnum := 0;

   // update list of available channels
   sel := (AObject as TComboBox).ItemIndex;
   (AObject as TComboBox).Items.Clear;
   for i:=0 to MaxChannels-1 do
     with frmChannel.ChannelInfo[i] do
       if ((Group.ItemIndex<>0) or Enabled.Checked) and Enabled.Enabled then
        begin
          (AObject as TComboBox).Items.Add(IntToStr(i+1)+'. '+Edit.Text);
          inc(chnum);
        end;

   if sel > (chnum-1) then
      (AObject as TComboBox).ItemIndex := 0
   else
      (AObject as TComboBox).ItemIndex := sel;

   // check for channel selection conflict
   SelCheck(self);

   // assign combo OnClick event
   (AObject as TComboBox).OnClick := self.SelCheck;
end;

//==========================================================
// Check selection of new channel for conflicts
//==========================================================
procedure TChannelSel.SelCheck(Sender: TObject);
var
   i,j	: integer;
   combo_i, combo_j: TComboBox;
begin
   FMultiSelect := false;

   for i:=0 to Count-1 do
    begin
      combo_i := Items[i];
      combo_i.Color := clWindow;
    end;

   for i:=0 to Count-1 do
    begin
      combo_i := Items[i];
      for j:=i+1 to Count-1 do
       begin
         combo_j := Items[j];
         if combo_i.ItemIndex = combo_j.ItemIndex then
          begin
            combo_i.Color := clRed;
            combo_j.Color := clRed;
            FMultiSelect := True;
          end;
       end;
    end;
end;

//==========================================================
// convert combo ItemIndex to channel number
//==========================================================
function TChannelSel.GetChannelNumber(Combo :TComboBox):integer;
var
   i		: word;
   n		: word;
   found	: boolean;
begin
   found := false;

   i := 0;
   n := 0;
   while (i<MaxChannels-1) and not found do
    begin
      with frmChannel.ChannelInfo[i] do
        if ((Group.ItemIndex<>0) or Enabled.Checked) and Enabled.Enabled then
         begin
            if n=Combo.ItemIndex then
               found:=true
            else
               inc(n);
         end;
      if not found then
         inc(i);
    end;

   if found then
      result := i
   else
      result := -1;
end;


//==========================================================
// Destructor, also deassigns OnClick event
//==========================================================
destructor TChannelSel.Destroy;
var
   i: integer;
   combo_i: TComboBox;
begin
   for i:=0 to Count-1 do
    begin
      combo_i := Items[i];
      combo_i.OnClick := nil;
    end;

   inherited;
end;

end.
