// =====================================================
//
//   miniLA_win - Common declarations
//
//   (c) miniLA Team
//
// =====================================================
//
// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this package; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.


unit uLATypes;

interface

uses graphics,stdctrls;

const MaxDataLength	= 131072;
      MaxChannels	= 32; 			// max. pocet kanalu
      ScaleHeight	= 15; 			// vyska stupnice
      SnapDistance	= 6;			// cursor snapping distance
      MaxSignalHeight	= 2;			// max. value of signal height (ratio of default font size)
      TriggerStep 	: integer = $2000;	// pre/posttrigger size step
      ProgVersion 	= '0.6.0';		// program version
      FWVersion		= '1.7, 2.2';		// firmware version

const EnChannels = 16;		    		// number of initially enabled channels


// dlgDisplay
type
     // databuffer
     TDataBuffer=array[0..MaxDataLength-1] of cardinal; // buffer pro zaznam dat

     TChannelInfo=record                // distribuovana data pro zobrazeni
       Color            :TColor;        // barva kanalu, v pripade skupiny nema vyznam
       Name             :string;        // jmeno signalu nebo skupiny
       Group            :boolean;       // priznak, zda se jedna o skupinu
       Mask             :cardinal;      // bitova maska
       NumberOfSignals  :byte;          // pocet sdruzenych signalu
       Signals          :array[0..MaxChannels-1] of byte;      // seznam signalu (0..NumberOfSignals-1), signalweight defined by order
       Base             :integer;       // ciselna zakladna skupiny (0 - bin, 1 - oct, 2 - dec, 3 - hex)
       DispVal		:byte;		// value to display (value, number of rising/falling/both edges)
     end;

     TDisplayData=record
       NumberOfLines    :byte; 		// 0..32 zobrazenych kanalu
       Data		:array[0..MaxChannels-1] of TChannelInfo;
     end;

// dlgTrigger
type TTrigField=record
       cbEnabled:TCheckBox;
       TrigCondition:array[0..3] of TRadioButton;
     end;

     TTrigArray=array[0..16] of TTrigField;

     TGroupEdits=array[0..MaxChannels-1] of TEdit;
     TGroupButtons=array[0..15] of TButton;
     TGroupNames=array[0..MaxChannels-1] of string;


// dlgChannel
type TChannelI=record
       Edit:TEdit;
       Enabled:TCheckBox;
       Color:TButton;
       Group:TComboBox;
     end;

     TChannelRecs=array[0..MaxChannels-1] of TChannelI;

// uCommunication
type TData=array[0..MaxDataLength-1] of cardinal;
     TState=(tsNotDetected, tsReady, tsWaitForTrigger, tsPosttrigger, tsReading);

implementation

end.
