#include <avr/io.h>
#include <avr/interrupt.h>

uint8_t temp;
uint8_t audio;
uint8_t status;

ISR(TIMER0_COMPA_vect) {

   OCR1A = audio;

	if(status == 0) {
	   status = 1;
	   }
	else if(status == 1) {
	   status = 0;
	   }
}

void ini(void) {
   DDRB  = 0x07;

   TCCR1 = (1 << PWM1A) | (0 << COM1A1) | (1 << COM1A0) | (0 << CS13) | (0 << CS12) | (0 << CS11) | (1 << CS10) ;
   PLLCSR = (1 << PCKE);



   TCCR0A = (0 << COM0A1) | (0 << COM0A0) | (0 << COM0B0) | (0 << COM0B0) | (1 << WGM01) | (0 << WGM00);
   TCCR0B = (0 << CS02) | (1 << CS01) | (0 << CS00);
   OCR0A = 255;
   TIMSK = (1 << OCIE0A);

   USICR = (1 << USIWM1) | (1 << USICLK);

   temp = 128;
   OCR1A = temp;
   status = 0;

   sei();
   return 0;
}

int main(void) {
   ini();
	while(1){
	   if(status == 0) {
	   audio = 128;
	   }
	   else if(status == 1) {
	   audio = 0;
	   }

	}
while(1);
}
