/* Nuvoton NUC120RE3AN:  USB als COM Port betreiben */

#ifndef __USB_H__
#define __USB_H__


/* Liste der von aussen zu benutzenden Funktionen */
extern bool UsbRxAvail (void);    /* true, wenn Char's vom Host abholbar sind */
extern char UsbGetChar (void);    /* liest ein Char vom Host */
extern bool UsbTxReady (void);    /* true, wenn mindestens 1 Char gesendet werden kann */
extern bool UsbTxEmpty (void);    /* true, wenn der Sendepuffer total leer ist */
extern char UsbCharOut (char c);  /* sendet ein Char zum Host */
extern void UsbStrOut  (char* S); /* sendet einen String zum Host */
extern word UsbSetup   (void);    /* Starten des USB-Cores */


/* Debug-Zeugs */
#define lbLen 0x800
extern char LogBuf[lbLen];
extern int  lbw, lbr;


#endif



/*  Informationen zur Benutzung (von Nuvoton):
    ==========================================

usbser.sys is required for USB Virtual COM device.
It is included by windows operation system and could be found at
\WINDOWS\system32\drivers   or \i386\driver.cab

To install the VCOM driver, user must find usbser.sys on their OS first
and copy it to the same directory with Nuvoton CDC INF file.
Finally install the driver manually when windows request to install
the VCOM device driver.


passendes File  "NuvotonCDC.inf"
--hier raustrennen-------------------------------------------------------------------------
;
; Windows USB CDC Driver Setup File for Nuvoton-CDC (XP/2000)
;
;	(c) Copyright 2008 Recursion Co., Ltd.
;

[Version]
Signature	= "$Windows NT$"
Provider	= %COMPANY%
DriverVer	= 06/28/2008,1.0.0.1

Class		= Ports
ClassGuid	= {4D36E978-E325-11CE-BFC1-08002BE10318}

[Manufacturer]
%MFGNAME%	= Devices,NT,NTamd64

;--------------------------------------------------------------------------
; Files
;--------------------------------------------------------------------------

[DestinationDirs]
DefaultDestDir	= 12

;--------------------------------------------------------------------------
; Device driver
;--------------------------------------------------------------------------

[NuvotonCDC_DEV.NT]
Include	= mdmcpq.inf
CopyFiles	= FakeModemCopyFileSection
AddReg		= NuvotonCDC_DEV.NT.AddReg

[NuvotonCDC_DEV.NT.AddReg]
HKR,,DevLoader,,*ntkern
HKR,,NTMPDriver,,usbser.sys
HKR,,EnumPropPages32,,"MsPorts.dll,SerialPortPropPageProvider"

[NuvotonCDC_DEV.NT.Services]
AddService=usbser, 0x00000002, DriverService

;--------------------------------------------------------------------------
; Services
;--------------------------------------------------------------------------

[DriverService]
DisplayName	= %SERVICE%
ServiceType	= 1
StartType	= 3
ErrorControl	= 1
ServiceBinary	= %12%\usbser.sys

;--------------------------------------------------------------------------
; Devices
;--------------------------------------------------------------------------

[Devices.NT]
%DESCRIPTION%	= NuvotonCDC_DEV, USB\VID_0416&PID_5011

[Devices.NTamd64]
%DESCRIPTION%	= NuvotonCDC_DEV, USB\VID_0416&PID_5011

;--------------------------------------------------------------------------
; Strings
;--------------------------------------------------------------------------

[Strings]
COMPANY	= "Nuvoton Co., Ltd."
MFGNAME	= "www.nuvoton.com"
DESCRIPTION	= "Nuvoton Virtual Com Port"
SERVICE	= "USB RS-232 Emulation Driver"
--hier raustrennen-------------------------------------------------------------------------


*/

