
#include <math.h>
#include <stdlib.h>


/************* Debug Funktionen ***************************/

/*
Prinzip:
Der Ringpuffer 'LogBuf' kann mit diversen Funktionen in diesem
Stck Quelltext gefllt werden ohne dabei Wartezeiten zu verursachen.

Zur Ausgabe mu man sich irgendeine Routine schreiben, die nacheinander
alles, was in diesem Ringpuffer steht, irgendwohin ausgibt, z.B.
ber den UART. Beispiel: lb_Out() ganz unten im Text.
*/

char LogBuf[lbLen];
int  lbw, lbr;


void lbChar (char c)
{ int i;
  i = (lbw+1) & (lbLen-1);
  if (i==lbr) return;       /* Puffer voll! */
  LogBuf[lbw] = c;
  lbw = i;
}

void lbStr (char* s)
{ while (*s) lbChar(*s++);
}

const char HaChars[17]   = {"0123456789ABCDEF"};

/* ein Hex-Zeichen ausgeben */
void lbNibble (int aHex) { lbChar(HaChars[aHex & 0x0F]); }

/* ein Byte als Hexa ausgeben */
void lbHexB  (byte aHex)
{ lbNibble (aHex >> 4);
  lbNibble (aHex);
}

void lbHexW  (word aHex)
{ lbHexB (aHex >> 8);
  lbHexB (aHex);
}

void lbHexD  (dword aHex)
{ lbHexW (aHex >> 16);
  lbHexW (aHex);
}


void lbDezi (long aDez)
{ int i;
  char s[24];
  ldiv_t T;
  bool v;

  i = 0; v = false;
  if (aDez < 0)
  { aDez = -aDez; v = true; }
  if (!aDez)
  { lbChar('0');
    return;
  }

  while (aDez)
  { T = ldiv(aDez,10);
    aDez = T.quot;
    s[i++] = '0'+T.rem;
  }
  if (v) lbChar('-');
  while (i) lbChar(s[--i]);
  return;
}

extern long System_Tick;

void lbUhr (void)
{ long u;
  char z[16];
  int  i;

  u = System_Tick;   // woanders:  Uhr;
  if (!u) return;

  i = 15;
  z[i--] = 0;
  z[i--] = ' ';
  z[i--] = 's';
  z[i--] = 'm';
  z[i--] = ' ';
  while (u)
  { z[i--] = '0' + (u % 10);
    u = u / 10;
  }
  z[i] = ' ';
  lbStr(&z[i]);
}


void report_SetupPacket (void)
{
 lbStr(" Setup ");
 if (CMD.SetupPacket.bmRequestType & (1<<7))
   lbStr("D->H");
 else
   lbStr("H->D");
 lbStr(" reqtyp:"); lbHexB(CMD.SetupPacket.bmRequestType);
 lbStr(", req:");  lbHexB(CMD.SetupPacket.bRequest);
 lbStr(", wVal:"); lbHexW(CMD.SetupPacket.wValue);
 lbStr(", wIdx:"); lbHexW(CMD.SetupPacket.wIndex);
 lbStr(", len:");  lbHexW(CMD.SetupPacket.wLength);
 lbStr("\r\n");
}

/*  (war nur fr Nuvoton)
void report_USBStatus (void)
{ dword s;
  s = CMD.USBState;
  lbStr("\r\nUSB: ");
  if (s & isSUSPENDED) lbStr("suspended ");
  s = s & 0x1F;
  switch(s)
  { case isDETACHED:   lbStr("detached"); break;
    case isATTACHED:   lbStr("attached"); break;
    case isPOWERED:    lbStr("powered"); break;
    case isDEFAULT:    lbStr("default"); break;
    case isADDRESSED:  lbStr("addressed"); break;
    case isCONFIGURED: lbStr("configured"); break;
  }
  lbStr("\r\n");
}
*/

extern void Char_Out (char c, word towo);

void lb_Out (void)
{ char c;
   while (lbr!=lbw)
  { c = LogBuf[lbr];
    lbr = (lbr + 1) & (lbLen-1);
    Char_Out(c, ComPort);
  }
}


