.include "tn13def.inc"
;*********************************************************************************
;vier unabhngige elektronische grillen mit realistischer zirplngen variation und
;klatschschalter zum ruhigsein. Fr Tiny13. 
;fuses: nur SutoO und Cksel1 an (haken da im ponyprog).    --- oktober 2008 Alex S.---   
;*********************************************************************************
;prinzip fr eine grille:
;1.: piezolautsprecher anschalten
;2.: whrenddessen zufallswerte fr zirplngenvariation und zirpdauer erzeugen
;3.: piezolautsprecher aus
;4.: zirpdauer ende erreicht? ja dann zirpen auslassen bis zirppausenende erreicht ist
;5.: alles von vorne. 

;registerliste:
; r0=pseudozufallwert 1
; r1=pseudozufallwert 2
; r2=pseudozufallwert 3
; r3=pseudozufallwert 4
; r4=pseudozufallwert 5
; r5=pseudozufallwert 6
; r6=pseudozufallwert 7
; r7=pseudozufallwert 8
; r8=zirpen aus low zhler grille 1
; r9=zirpen aus high zhler grille 1
;r10=zirpen aus low zhler grille 2
;r11=zirpen aus high zhler grille 2
;r12=zirpen aus low zhler grille 3
;r13=zirpen aus high zhler grille 3
;r14=zirpen aus low zhler grille 4
;r15=zirpen aus high zhler grille 4
;r16=ton an lnge (einzelnes zirp) grille 1
;r17=ton an lnge (einzelnes zirp) grille 2
;r18=ton an lnge (einzelnes zirp) grille 3
;r19=ton an lnge (einzelnes zirp) grille 4
;r20=ton aus lnge (einzelnes zirp) grille 1
;r21=ton aus lnge (einzelnes zirp) grille 2
;r22=ton aus lnge (einzelnes zirp) grille 3
;r23=ton aus lnge (einzelnes zirp) grille 4
;r24=zirpen an zhler grille 1
;r25=zirpen an zhler grille 2
;r26=zirpen an zhler grille 3
;r27=zirpen an zhler grille 4
;r28=zirpen aus zhler verlngerer
;r29=hilfsregister beim zufallszahlenerzeugen
;r30=
;r31=
;sram 96-103=r8/r10/r12/r14/r24/r25/r26/r27 zwischenspeicher wegen zuwenig freie register

.equ zufallwert1=0b01001110
.equ zufallwert2=0b10111011 
.equ zufallwert3=0b11001101
.equ zufallwert4=0b01011001

rjmp start
.org 0x0002 rjmp ruhe;pinchangeinterrupt

start:
	ldi r17,0b10000000 ;systemclockprescaler nderung anmelden...
	out clkpr,r17 ;...
	ldi r18,0b00000011 ;systemclock geteilt durch 8  (4,8MHz:8=600KHz)...
	out clkpr,r18 ;...	

	sbi acsr,acd ;komparator aus (strom sparen)

	sbi ddrb,0 ;portb0 ist ein ausgang (piezo lautsprecher von pin 5 an masse) grille 1
	sbi ddrb,1 ;portb1 ist ein ausgang (piezo lautsprecher von pin 6 an masse) grille 2
	sbi ddrb,3 ;portb3 ist ein ausgang (piezo lautsprecher von pin 2 an masse) grille 3
	sbi ddrb,4 ;portb4 ist ein ausgang (piezo lautsprecher von pin 3 an masse) grille 4
	
	cbi ddrb,2 ;portb2 ist ein eingang (mikrofon mit op-amp)	
	sbi portb,2 ;pullup widerstand am portb2 anschalten
	sbi pcmsk,2 ;portb2 soll pinchangeinterrupt auslsen knnen  	
	ldi r16,0b00100000 ;pinchangeinterrupt anschalten...
	out gimsk,r16 ;...
	sei ;interrupte zulassen	

	ldi r31,3
	mov  r8,r31 ;zirpen aus low zhler grille 1
	sts  97, r8
	mov r10,r31 ;zirpen aus low zhler grille 2
	sts  99,r10
	mov r12,r31 ;zirpen aus low zhler grille 3
	sts 101,r12
	mov r14,r31 ;zirpen aus low zhler grille 4
	sts 103,r14
	
	ldi r31,1	
	mov  r9,r31 ;zirpen aus high zhler grille 1
	mov r11,r31 ;zirpen aus high zhler grille 2
	mov r13,r31 ;zirpen aus high zhler grille 3
	mov r15,r31 ;zirpen aus high zhler grille 4

	ldi r16,30 ;ton an lnge (einzelnes zirp) grille 1
	ldi r17,33 ;ton an lnge (einzelnes zirp) grille 2
	ldi r18,36 ;ton an lnge (einzelnes zirp) grille 3
	ldi r19,39 ;ton an lnge (einzelnes zirp) grille 4

	ldi r20,15 ;ton aus lnge (einzelnes zirp) grille 1
	ldi r21,17 ;ton aus lnge (einzelnes zirp) grille 2
	ldi r22,19 ;ton aus lnge (einzelnes zirp) grille 3
	ldi r23,21 ;ton aus lnge (einzelnes zirp) grille 4
		
	ldi r24,20 ;zirpen an zhler grille 1
	sts  96,r24
	ldi r25,20 ;zirpen an zhler grille 2
	sts  98,r25
	ldi r26,20 ;zirpen an zhler grille 3
	sts 100,r26
	ldi r27,20 ;zirpen an zhler grille 4
	sts 102,r27	

	ldi r28,10 ;zirpen aus zhler verlngerer
	
	ldi r29,zufallwert1 ;zu r0 addieren...
	add r0,r29 ;...
	com r29 ;umgedrehte bits zu r1 addieren...
	add r1,r29 ;...

	ldi r29,zufallwert2 ;zu r2 addieren...
	add r2,r29 ;...
	com r29 ;umgedrehte bits zu r3 addieren...
	add r3,r29 ;...
	
	ldi r29,zufallwert3 ;zu r4 addieren...
	add r4,r29 ;...
	com r29 ;umgedrehte bits zu r5 addieren...
	add r5,r29 ;...
	
	ldi r29,zufallwert4 ;zu r6 addieren...
	add r6,r29 ;...
	com r29 ;umgedrehte bits zu r7 addieren...
	add r7,r29 ;...
	
start1:	;einzelnes zirp an
	tst r16 ;grille 1
	breq e1
	sbi portb,0
e1:	tst r17 ;grille 2
	breq e2
	sbi portb,1
e2:	tst r18 ;grille 3
	breq e3
	sbi portb,2
e3:	tst r19 ;grille 4
	breq e4
	sbi portb,4
e4:	 


	;einzelnes zirp an
	;pseudozufall erzeugen
	lsr r0 ;alle bits von r0 & r1 eins nach rechts schieben...
	ror r1 ;...
	clr r29 ;bit 6 von r0 exor mit bit 5 von r1 und ergebnis nach bit 8 von r0...
	sbrc r0,5 ;...
	sbr r29,1 ;...
	sbrc r1,4 ;...
	sbr r29,2 ;...
	breq zu1 ;...ist das ergebnis 0?...ja dann zu zu1...
	cpi r29,3 ;...ist das ergebnis 3 (exor) dann zu zu1...
	breq zu1 ;...
	ldi r29,0b10000000 ;...nein dann eine 1 in bit 8 von r0 schreiben...
	or r0,r29 ;... 
zu1:
	lsr r2 ;alle bits von r2 & r3 eins nach rechts schieben...
	ror r3 ;...
	clr r29 ;bit 6 von r2 exor mit bit 5 von r3 und ergebnis nach bit 8 von r2...
	sbrc r2,5 ;...
	sbr r29,1 ;...
	sbrc r3,4 ;...
	sbr r29,2 ;...
	breq zu2 ;...ist das ergebnis 0?...ja dann zu zu2...
	cpi r29,3;...ist das ergebnis 3 (exor) dann zu zu2...
	breq zu2 ;...
	ldi r29,0b10000000 ;...nein dann eine 1 in bit 8 von r2 schreiben...
	or r2,r29 ;... 
zu2:	
	lsr r4 ;alle bits von r4 & r5 eins nach rechts schieben...
	ror r5 ;...
	clr r29 ;bit 6 von r4 exor mit bit 5 von r5 und ergebnis nach bit 8 von r4...
	sbrc r4,5 ;...
	sbr r29,1 ;...
	sbrc r5,4 ;...
	sbr r29,2 ;...
	breq zu3 ;...ist das ergebnis 0?...ja dann zu zu3...
	cpi r29,3;...ist das ergebnis 3 (exor) dann zu zu3...
	breq zu3 ;...
	ldi r29,0b10000000 ;...nein dann eine 1 in bit 8 von r4 schreiben...
	or r4,r29 ;... 
zu3:
	lsr r6 ;alle bits von r6 & r7 eins nach rechts schieben...
	ror r7 ;...
	clr r29 ;bit 6 von r6 exor mit bit 5 von r7 und ergebnis nach bit 8 von r6...
	sbrc r6,5 ;...
	sbr r29,1 ;...
	sbrc r7,4 ;...
	sbr r29,2 ;...
	breq zu4 ;...ist das ergebnis 0?...ja dann zu zu4...
	cpi r29,3;...ist das ergebnis 3 (exor) dann zu zu4...
	breq zu4 ;...
	ldi r29,0b10000000 ;...nein dann eine 1 in bit 8 von r6 schreiben...
	or r6,r29 ;... 
zu4:	
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop

;	nop ;(zirpen frequenz wird tiefer wenn diese nops auch angeschaltet werden)
;	nop
;	nop
;	nop
;	nop
;	nop
;	nop
;	nop
;	nop
;	nop

;	nop
;	nop
;	nop
;	nop
;	nop
;	nop
;	nop
;	nop
;	nop
;	nop

;	nop
;	nop
;	nop
;	nop
;	nop
;	nop
;	nop
;	nop
;	nop
;	nop

	;einzelnes zirp aus
	tst r16 ;grille 1
	breq s1
	dec r16
	cbi portb,0
s1:	tst r17 ;grille 2
	breq s2
	dec r17
	cbi portb,1
s2:	tst r18 ;grille 3
	breq s3
	dec r18
	cbi portb,2
s3:	tst r19 ;grille 4
	breq s4
	dec r19
	cbi portb,4
s4:

	;zirpen an generator
	tst r16 ;grille 1
	brne t1
	dec r20
	brne t1
	tst r24
	breq t1
	dec r24
	ldi r20,6 ;(20 fr tiefere zirpfrequenz)
	ldi r16,30
t1:	tst r17 ;grille 2
	brne t2
	dec r21
	brne t2
	tst r25
	breq t2
	dec r25
	ldi r21,6 ;(20 fr tiefere zirpfrequenz)
	ldi r17,30
t2:	tst r18 ;grille 3
	brne t3
	dec r22
	brne t3
	tst r26
	breq t3
	dec r26
	ldi r22,6 ;(20 fr tiefere zirpfrequenz)
	ldi r18,30
t3:	tst r19 ;grille 4
	brne t4
	dec r23
	brne t4
	tst r27
	breq t4
	dec r27
	ldi r23,6 ;(20 fr tiefere zirpfrequenz)
	ldi r19,30
t4:


	;zirpen aus generator
	dec r28
	breq l1
	rjmp start1
l1:	ldi r28,10	
	
	tst r24 ;grille 1
	brne u1
	clr r16
	ldi r20,2
	dec r8
	brne u1
	dec r9
	brne u1
	lds r24,96
	sbrs r0,0
	subi r24,2
	inc r24
	cpi r24,10
	brsh u11 
	ldi r24,10
u11:	sts 96,r24
	lds r8,97
	sbrs r1,0
	sub r8,r20
	inc r8
	sts 97,r8
	ldi r29,2
	cp r0,r29
	brsh m1
	mov r9,r1	
	rjmp u1
m1:	clr r9
	inc r9 
u1:	tst r25 ;grille 2
	brne u2
	clr r17
	ldi r21,2
	dec r10
	brne u2
	dec r11
	brne u2
	lds r25,98
	sbrs r2,0
	subi r25,2
	inc r25
	cpi r25,10
	brsh u22 
	ldi r25,10
u22:	sts 98,r25
	lds r10,99
	sbrs r3,0
	sub r10,r21
	inc r10
	sts 99,r10
	ldi r29,2
	cp r2,r29
	brsh m2
	mov r11,r3	
	rjmp u2
m2:	clr r11
	inc r11 
u2:	tst r26 ;grille 3
	brne u3
	clr r18
	ldi r22,2
	dec r12
	brne u3
	dec r13
	brne u3
	lds r26,100
	sbrs r4,0
	subi r26,2
	inc r26
	cpi r26,10
	brsh u33 
	ldi r26,10
u33:	sts 100,r26
	lds r12,101
	sbrs r5,0
	sub r12,r22
	inc r12
	sts 101,r12
	ldi r29,2
	cp r4,r29
	brsh m3
	mov r13,r5	
	rjmp u3
m3:	clr r13
	inc r13 
u3:	tst r27 ;grille 4
	brne u4
	clr r19
	ldi r23,2
	dec r14
	brne u4
	dec r15
	brne u4
	lds r27,102
	sbrs r6,0
	subi r27,2
	inc r27
	cpi r27,10
	brsh u44 
	ldi r27,10
u44:	sts 102,r27
	lds r14,103
	sbrs r7,0
	sub r14,r23
	inc r14
	sts 103,r14
	ldi r29,2
	cp r6,r29
	brsh m4
	mov r15,r7	
	rjmp u4
m4:	clr r15
	inc r15 
u4:	


	rjmp start1



ruhe:	
	clr r16
	clr r17
	clr r18
	clr r19

	clr r24
	clr r25
	clr r26
	clr r27

	mov r9,r0
	mov r11,r2
	mov r13,r4
	mov r15,r6
	
	add r0,r2
	add r2,r4
	add r4,r6
	add r6,r0
	add r1,r3
	add r3,r5
	add r5,r7
	add r7,r1

	reti
