/*
  ==============================================================================

    This file was auto-generated!

    It contains the basic startup code for a JUCE application.

  ==============================================================================
*/

#include "../JuceLibraryCode/JuceHeader.h"

#include <fstream>

class DUT {
public:
	DUT(double fc = 1'378.12500, double fs = 44'100.0) : coef(std::exp(-2.0 * juce::MathConstants<double>::pi * fc / fs)), inv_coef(1.0 - this->coef) {
	}

	void operator()(float* data, size_t size) noexcept {
		for (size_t i = 0; i < size; ++i) {
			this->operator()(data[i]);
		}
	}

	void operator()(float &v) noexcept {
		this->r = this->r * this->coef + double(v) * this->inv_coef;
		v = float(this->r);

	}

private:
	double coef, inv_coef;
	double r = 0.0;
};

//==============================================================================
int main (int argc, char* argv[]) {
	juce::dsp::FFT fft(8);
	DUT dut;

	std::vector<float> arr(fft.getSize() * 2ull);
	for (size_t i = 2; i <= fft.getSize(); i += 2) {
		arr[i] = 1.0; // set real = 1.0 / imag = 0.0
	}
	fft.performRealOnlyInverseTransform(arr.data());

	dut(arr.data(), fft.getSize());

	fft.performRealOnlyForwardTransform(arr.data());

	std::ofstream file("fft.txt");
	for (size_t i = 0; i < fft.getSize(); i += 2) {
		std::complex<float> c(arr[i], arr[i + 1]);
		double frequency = 44'100.0 / double(fft.getSize()) * double(i / 2);
		double amplitude = std::log10(std::abs(c)) * 20.0;
		double phase = std::arg(c) * 360.0 / 2.0 / juce::MathConstants<double>::pi;
		double groupdelay = 0.0; //????????
		file << frequency << "," << amplitude << "," << phase << "\n";
	}

    return 0;
}
