#include ".\..\inc\ch552_keil.h"
#include ".\..\inc\isd_ch55x.h"

#define FREQ_SYS 24000000L 
#define CALL(addr)   (((void(*)(void))(unsigned char code *)addr)()) //call any 

// from Aarons board
  #define LED1   TXD      
  #define LED3   RXD 
  #define SW1    INT0


unsigned int crc;

void crc16(unsigned int b)
{
   register unsigned int i;
   crc^=b;
   for(i=8;i;i--)
   {
     crc= (crc>>1)^((crc&1) ? 0xA001:0);
   }
}  
// build a crc over the bootloader
unsigned int BuildCrc(unsigned char *p)
{
   unsigned int i;
   crc=0; 
   for (i=0; i < 0x07F0;i++)
   {
      crc16(*p);
      p++;
   }
   return crc;
}

void InitTimeout(void)
{
   T2CON   =  0x00;    // 0000 0000
   RCAP2   = -20000;   // 10 ms
   T2COUNT = -20000;
   TF2     = 0;
   TR2     = 1;        // T2 run
   ET2     = 1;        // enable the irq
}

void  CfgFsys(void)
{
   SAFE_MOD  = 0x55;
   SAFE_MOD  = 0xAA;
   CLOCK_CFG = CLOCK_CFG & ~ MASK_SYS_CK_SEL | 0x06;  // 24MHz
   SAFE_MOD  = 0x00;
   InitTimeout();
   while (!TF2);
   TF2=0;
}

void TimeoutIrq (void) interrupt INT_NO_TMR2
{
   TF2=0;
}

void main (void)
{
   if (SW1 == 0) CALL (0x3800); 
   LED1=0;
   LED3=0;
   CfgFsys();
   ISDInitUart();
   
   EA=1;
  
   
   while(1)
   {
      ISDcheck(); 
      BuildCrc((unsigned char code *)BOOT_LOAD_ADDR);   
   }  
}  