/* Taktgenerator SI5351A, LowLevel-Treiber  */

#include "StdTypes.h"
#include "i2cs.h"
#include "si5351a_ll.h"
#include "gio.h"
#include "conv.h"

#define  SI5351Adr  0x60   // die I2C Adresse des Chips


/* schreibt count Bytes ab RegisterAddr in den SI5351A */
bool Write_SI5351 (byte  RegisterAddr,    // ab wo
                   void* was,             // Zeiger auf Daten
                   byte  count)           // wieviel zu schreiben
{ bool erg;
  byte* iwas;

  iwas = was;

  // SI5351 adressieren
  erg = Do_I2CS_Start(SI5351Adr, 0);
  if (!erg) goto raus;

  // Registeradresse senden
  erg = Do_I2CS_Write(RegisterAddr);
  if (!erg) goto raus;

  while (count)
  { erg = Do_I2CS_Write(*iwas);
    if (!erg) goto raus;
    ++iwas;
    --count;
  }
  raus:
  Do_I2CS_Stop();
  return erg;
}


int Read_SI5351 (byte  RegisterAddr)
{ bool erg;
  int  result;

  erg = Do_I2CS_Start(SI5351Adr, 0);
  if (!erg) return -1;

  erg = Do_I2CS_Write(RegisterAddr);
  if (!erg) return -1;

  Do_I2CS_Stop();

  erg = Do_I2CS_Start(SI5351Adr, 1);
  if (!erg) return -1;

  result = Do_I2CS_Read(false);
  Do_I2CS_Stop();
  return result;
}



  /***/
