#ifndef F_CPU
/* In neueren Version der WinAVR/Mfile Makefile-Vorlage kann
   F_CPU im Makefile definiert werden, eine nochmalige Definition
   hier wuerde zu einer Compilerwarnung fuehren. Daher "Schutz" durch
   #ifndef/#endif

   Dieser "Schutz" kann zu Debugsessions fhren, wenn AVRStudio
   verwendet wird und dort eine andere, nicht zur Hardware passende
   Taktrate eingestellt ist: Dann wird die folgende Definition
   nicht verwendet, sondern stattdessen der Defaultwert (8 MHz?)
   von AVRStudio - daher Ausgabe einer Warnung falls F_CPU
   noch nicht definiert: */
#warning "F_CPU war noch nicht definiert, wird nun nachgeholt mit 16000000"
#define F_CPU 16000000UL    // Systemtakt in Hz - Definition als unsigned long beachten >> Ohne ergeben Fehler in der Berechnung
#endif

#include <stdio.h>
#include <stdint.h>
#include <avr/io.h>
#include <util/delay.h>

#include "wintek2704.h"

/*
	Test programm for wintek display
	2005 Stefan Seegel dahamm@gmx.net

	Modifiziert von Dieter Engelhardt dieter@ew6.org
	Am 11.11.2008
*/


void CHECK_Ports(){
	int i;
    DDRD = (1 << PD5) | (1 << PD6) | (1 << PD7) ;   // LED uses OC1A  OC1A
    DDRB = (1 << PB3);

    PORTD |= (1 << PD5) | (1 << PD6) | (1 << PD7);
    PORTB |= (1 << PB3);
    for (i = 0; i < 256; i++ ){
    	_delay_loop_2(30000);
    }

}


int main(void)
{
	uint32_t count = 0L;
	uint32_t zyklus = 0L;
	char sbuff[28];
	char sdots[28];
	char szyklus[28];


    lcd_init(LCD_DISP_ON);
	lcd_puts("Guten Tag\n2. Zeile\n3. Zeile");
//    lcd_puts("Soderla");
	set_cursor(3, 4);
	lcd_puts("4. Zeile Mitte");

	CHECK_Ports();
	for (;;)
	{
        // LED an (Lebendkontrolle)
	    PORTD |= (1 << PD5) | (1 << PD6) | (1 << PD7);
	    PORTB |= (1 << PB3);

        _delay_ms (50);


        // LED aus
        PORTD &= ~(1 << PD5) | (1 << PD6) | (1 << PD7);
        PORTB &= ~(1 << PB3);

        _delay_ms (50);
        lcd_clrscr();
        set_cursor(0, 1);
        lcd_puts("LCD-Test: by D.Engelhardt");
        int i = count%27;

        if(i != 0){
        	*(sdots + i) = '.';
        	*(sdots + i +1) = '\0';
        }
        else {
        	*sdots = ':';
        	*(sdots + i +1 ) = '\0';
        	sprintf(szyklus, "Zyklus: %ld", ++zyklus );

		}
        set_cursor(0, 2);
        lcd_puts(sdots);
        sprintf(sbuff, "Count: %ld", count);

        set_cursor(0, 3);
        lcd_puts(sbuff);
        count++;

        set_cursor(0, 4);
    	lcd_puts(szyklus);
    }

	// Das passiert wohl nie
	return 0;
}
