#include <CombieAdc.h>
using Combie::Adc;

/**
 * 
 * Differezial Input eines Arduino Mega nutzen.
 * 
 * Verwendet werden Pin A3 als positiver Input
 * und Pin A2 als negativer Input
 * Ausgabe, ein vorzeichenbehafteter Integer
 * Eine Gain Einstellung von 10 facher Verstärkung
 * Die Auflösung beträgt dann 2.56V/512/10 = 0.0005V
 * Also 0,5mV pro Digit. 
 * 
 * Setup:
 * Divisor setzen
 * Referenz setzen
 * Offsetkorrekturwert lesen
 * 
 * 
 * In loop: 
 * Messwert lesen
 * Offsetkorrektur
 * Ausgabe
 * 
*/

Adc adc;


const float konkreterReferenzWert = 2.52; // mit Multimeter gemessen
int OffsetKorrekturWert;

void setup() 
{
   Serial.begin(9600);

   adc  .enable()
        .setClockDivisor(Adc::DIV_128)
        .setReference(Adc::REF_256); 
        
  OffsetKorrekturWert = adc(Adc::MUX_ADC2_ADC2_G10);

  Serial.print("OffsetKorrekturWert  ");
  Serial.println(OffsetKorrekturWert);

  adc.setSource(Adc::MUX_ADC3_ADC2_G10);        
}

void loop() 
{

  int gelesenerWert       = adc;
  int korrigierterWert    = gelesenerWert - OffsetKorrekturWert;
  float spannung          = float(korrigierterWert)*(konkreterReferenzWert/512.0/10.0);
 
  Serial.print("gelesenerWert ");    Serial.println(gelesenerWert);
  Serial.print("korrigierterWert "); Serial.println(korrigierterWert);
  Serial.print("spannung ");         Serial.println(spannung,6);
  Serial.println("---");
  delay(1000);
}
